/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.omfapplication;

import java.io.IOException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverFactory;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverFactoryImpl;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinderFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibHandlerFactory;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibHandlerFactoryImpl;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibMgrWrapperFactoryImpl;
import se.ericsson.crbs.omf.mao.commonmo.mo.LdnFinderImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContextImpl;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactoryFactory;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactoryFactoryImpl;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.mao.genericmo.froproxy.FroProxyFactory;
import se.ericsson.crbs.omf.mao.genericmo.froproxy.FroProxyFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.NotificationHandlerFactory;
import se.ericsson.crbs.omf.mao.indications.NotificationHandlerFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.ServiceHandlerFactory;
import se.ericsson.crbs.omf.mao.indications.ServiceHandlerFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.wrappers.AlarmWrapperFactory;
import se.ericsson.crbs.omf.mao.indications.wrappers.AlarmWrapperFactoryImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapperFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapperFactoryImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapperImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapperFactoryImpl;
import se.ericsson.crbs.omf.mao.xml.ParserFactory;
import se.ericsson.crbs.omf.mao.xml.ParserFactoryImpl;
import se.ericsson.crbs.omf.omfapplication.FactoryInitializer;
import se.ericsson.crbs.omf.omfapplication.GenericFactoryInitializer;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.crbs.omf.omfapplication.OmfContextId;

class GenericOmfContextImpl
implements OmfContext {
    private static AbstractLogger logger = LoggingService.getLogger(GenericOmfContextImpl.class.getName());
    private final FactoryInitializer genericFactoryInitializer;
    private final MibHandlerFactory mibHandlerFactory;
    private final MaoFactoryFactory maoFactoryFactory;
    private final MoMetaDataFinder moMetaDataFinder;
    private final FroProxyFactory froProxyFactory;
    private final ServiceHandlerFactory serviceHandlerFactory;
    private final MoDataWrapperFactory moDataWrapperFactory;
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final NotificationHandlerFactory notificationHandlerFactory;
    private final MoFactoryMgrWrapper moFactoryMgrWrapper;
    private final LdnFinder ldnFinder;
    private final ParserFactory parserFactory;
    private final PmAttribute pmAttributeHandler;
    private final AlarmWrapperFactory alarmWrapperFactory;
    private final MoMetaDataNames moMetaDataNames;
    private final OmfContextId omfContextId;

    public GenericOmfContextImpl(OmfContextId anOmfContextId, PmAttribute aPmAttributeHandler, MoMetaDataNames aMoMetaDataNames) throws IOException {
        logger.traceDebug(this.getClass(), "Creating MoMetaDataFinder");
        this.omfContextId = anOmfContextId;
        this.moMetaDataNames = aMoMetaDataNames;
        this.moMetaDataFinder = MoMetaDataFinderFactory.getFinderInstance("MOM_META_DATA", this.moMetaDataNames);
        logger.traceDebug(this.getClass(), "Creating MibMgrWrapperFactory");
        MibMgrWrapperFactoryImpl mibMgrWrapperFactory = new MibMgrWrapperFactoryImpl();
        logger.traceDebug(this.getClass(), "Creating MibHandlerFactory");
        this.mibHandlerFactory = new MibHandlerFactoryImpl(this.moMetaDataFinder, mibMgrWrapperFactory);
        logger.traceDebug(this.getClass(), "Creating MaoFactoryFactory");
        this.maoFactoryFactory = new MaoFactoryFactoryImpl(this);
        logger.traceDebug(this.getClass(), "Creating GenericFactoryInitializer");
        this.genericFactoryInitializer = new GenericFactoryInitializer(this.moMetaDataFinder, this.maoFactoryFactory);
        logger.traceDebug(this.getClass(), "Creating FroProxyFactory");
        this.froProxyFactory = new FroProxyFactoryImpl(this.moMetaDataFinder);
        logger.traceDebug(this.getClass(), "Creating ServiceHandlerFactory");
        this.serviceHandlerFactory = new ServiceHandlerFactoryImpl(this.froProxyFactory);
        logger.traceDebug(this.getClass(), "Creating MoRepositoryWrapperFactory");
        MoRepositoryWrapperFactoryImpl moRepositoryWrapperFactory = new MoRepositoryWrapperFactoryImpl();
        logger.traceDebug(this.getClass(), "Creating MoRepositoryWrapper");
        this.moRepositoryWrapper = moRepositoryWrapperFactory.getMoRepository();
        logger.traceDebug(this.getClass(), "Creating MoDataWrapperFactory");
        this.moDataWrapperFactory = new MoDataWrapperFactoryImpl();
        logger.traceDebug(this.getClass(), "Creating NotificationHandlerFactory");
        this.notificationHandlerFactory = new NotificationHandlerFactoryImpl();
        logger.traceDebug(this.getClass(), "Creating MoFactoryMgrWrapper");
        this.moFactoryMgrWrapper = new MoFactoryMgrWrapperImpl();
        logger.traceDebug(this.getClass(), "Creating LdnFinderImpl");
        this.ldnFinder = new LdnFinderImpl();
        logger.traceDebug(this.getClass(), "Creating ParserFactoryImpl");
        this.parserFactory = new ParserFactoryImpl();
        this.pmAttributeHandler = aPmAttributeHandler;
        this.alarmWrapperFactory = new AlarmWrapperFactoryImpl();
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        serviceRepository.addService((Object)this, OmfContext.class, null);
    }

    public FactoryInitializer getGenericFactoryInitializer() {
        return this.genericFactoryInitializer;
    }

    public GenericMaoContext getGenericMaoContext(String moType) {
        return new GenericMaoContextImpl(moType, this.froProxyFactory, this.maoFactoryFactory, this.serviceHandlerFactory, this.moRepositoryWrapper, this.moDataWrapperFactory, this.notificationHandlerFactory, this.moMetaDataFinder, this.moFactoryMgrWrapper, this.pmAttributeHandler, this.parserFactory, this.alarmWrapperFactory, this.moMetaDataNames);
    }

    public MaoFactoryFactory getMaoFactoryFactory() {
        return this.maoFactoryFactory;
    }

    public MibHandlerFactory getMibHandlerFactory() {
        return this.mibHandlerFactory;
    }

    public MoFactoryMgrWrapper getMoFactoryMgrWrapper() {
        return this.moFactoryMgrWrapper;
    }

    public MoMetaDataFinder getMoMetaDataFinder() {
        return this.moMetaDataFinder;
    }

    public MoRepositoryWrapper getMoRepositoryWrapper() {
        return this.moRepositoryWrapper;
    }

    public LdnFinder getLdnFinder() {
        return this.ldnFinder;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public OseSenderReceiverFactory getOseSenderReceiverFactory() {
        return OseSenderReceiverFactoryImpl.getInstance();
    }

    public OmfContextId getId() {
        return this.omfContextId;
    }
}

