/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactory;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.XMLCredentialsFactory;

class EncryptedXMLCredentialsFactory
extends XMLCredentialsFactory {
    EncryptedXMLCredentialsFactory() {
    }

    public Credentials engineGenerateCredentials(InputStream inputStream, char[] cArray) throws CredentialsException {
        try {
            byte[] byArray = this.readToByteArray(inputStream);
            CodecFactory codecFactory = CodecFactory.getInstance("PKCS#5");
            byte[] byArray2 = (byte[])codecFactory.decodeAndDecrypt(byArray, cArray);
            return super.engineGenerateCredentials(new ByteArrayInputStream(byArray2), null);
        }
        catch (CodecException codecException) {
            throw new CredentialsException("Failed to decrypt credentials", codecException);
        }
        catch (IOException iOException) {
            throw new CredentialsException("Failed to generate credentials", iOException);
        }
    }

    private byte[] readToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

