/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.login;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsFactory;
import se.ericsson.security.login.login.LoginCauseException;
import se.ericsson.security.login.login.LoginProxy;
import se.ericsson.security.login.login.SendReceiveOnHttps;

public class SLSProxy
implements LoginProxy {
    private static int index = 0;
    private static URL[] urls = null;
    private byte[] data;
    private static Log log = Log.getInstance();
    private final File credsFile;
    private char[] ssuPwd;

    public SLSProxy(URL[] uRLArray, File file, char[] cArray) {
        if (uRLArray != urls) {
            urls = uRLArray;
            index = 0;
        }
        this.credsFile = file;
        this.ssuPwd = cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateUser(String string, char[] cArray) throws LoginException {
        Properties properties = new Properties();
        properties.put("action", "getNetworkModeCredentials2");
        properties.put("usr", string);
        properties.put("pwd", new String(cArray));
        try {
            this.data = this.doTheInquiry(properties);
            Object var5_4 = null;
            properties.put("usr", "");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            properties.put("usr", "");
            properties.put("pwd", "");
            properties = null;
            throw throwable;
        }
        properties.put("pwd", "");
        properties = null;
        return true;
    }

    public Credentials getCredentials() throws LoginException {
        try {
            CredentialsFactory credentialsFactory = CredentialsFactory.getInstance("SLS");
            Credentials credentials = credentialsFactory.generateCredentials(new ByteArrayInputStream(this.data));
            this.store(credentials);
            return credentials;
        }
        catch (CredentialsException credentialsException) {
            log.error("Failed to validate credentials", credentialsException);
            throw new LoginCauseException("Failed to interpret credentials", credentialsException);
        }
    }

    public void shutDown() {
    }

    private byte[] doTheInquiry(Properties properties) throws LoginException {
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("No valid response from any of the SLS's for request: ");
        stringBuffer.append(properties.getProperty("action"));
        for (int i = 0; i < urls.length; ++i) {
            log.debug("Contacting " + urls[index]);
            try {
                byArray = SendReceiveOnHttps.get(urls[index], properties);
            }
            catch (IOException iOException) {
                log.warning("Failed to contact SLS: " + urls[index]);
                SLSProxy.appendError("Failed to contact", urls[index], iOException, stringBuffer);
            }
            if (byArray != null) break;
            ++index;
            index %= urls.length;
        }
        if (byArray == null) {
            throw new LoginException(stringBuffer.toString());
        }
        stringBuffer = null;
        return this.interpretRespons(byArray);
    }

    private byte[] interpretRespons(byte[] byArray) throws FailedLoginException, AccountExpiredException, CredentialExpiredException, LoginException {
        StringBuffer stringBuffer = new StringBuffer(new String(byArray));
        int n = stringBuffer.indexOf("<responsemessage>");
        int n2 = stringBuffer.indexOf("</responsemessage>", n);
        if (n < 0 || n2 < 0) {
            log.error("No <responsemessage> found in response from : " + urls[index] + "\n" + stringBuffer);
            throw new LoginException("Unkown message format received from SLS " + urls[index]);
        }
        String string = stringBuffer.substring(n + 17, n2).trim();
        this.interpretStausCode(string);
        stringBuffer.replace(n, n2 + 18, "");
        return stringBuffer.toString().getBytes();
    }

    private void interpretStausCode(String string) throws FailedLoginException, AccountExpiredException, CredentialExpiredException, LoginException {
        log.debug("interpretStausCode: " + string);
        if ("ok".equals(string)) {
            return;
        }
        if ("authentication failed".equals(string)) {
            throw new FailedLoginException("Wrong username or password");
        }
        if ("account locked".equals(string)) {
            throw new AccountExpiredException("Account locked");
        }
        if ("password expired".equals(string)) {
            throw new CredentialExpiredException("Password expired");
        }
        throw new LoginException("Unkown status code sent from SLS " + urls[index] + " : " + string);
    }

    private static void appendError(String string, URL uRL, Exception exception, StringBuffer stringBuffer) {
        stringBuffer.append("\n").append(string).append(" ");
        stringBuffer.append(urls[index]).append(" : ");
        String string2 = exception.getLocalizedMessage();
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer.append(exception.getMessage());
        } else {
            stringBuffer.append(exception.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void store(Credentials credentials) {
        if (this.credsFile == null) {
            log.warning("Failed to store NM credentials. No filename given");
            return;
        }
        String string = "";
        File file = null;
        try {
            try {
                file = this.credsFile.getParentFile();
                if (!file.isDirectory() && !file.mkdirs()) {
                    log.error("Failed to create directory for NM credentials: " + file);
                    Object var7_4 = null;
                    File file2 = new File(string);
                    if (!file2.exists()) return;
                    if (file2.delete()) return;
                    log.info("Could not delete temporary file " + file2.getName() + " from dir " + file.getAbsolutePath());
                    return;
                }
                File file3 = File.createTempFile("tmpFile", ".xml", file);
                SLSProxy.setFileProtected(file3);
                string = file3.getPath();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(credentials.getEncoded(this.ssuPwd));
                fileOutputStream.flush();
                fileOutputStream.close();
                if (this.credsFile.exists() && !this.credsFile.delete()) {
                    log.error("Could not delete file " + this.credsFile.getAbsolutePath());
                }
                if (!file3.renameTo(this.credsFile)) {
                    log.error("Could not rename temporary file to " + this.credsFile.getAbsolutePath());
                }
            }
            catch (CredentialsException credentialsException) {
                log.error("Failed to encode NM credentials", credentialsException);
                Object var7_6 = null;
                File file6 = new File(string);
                if (!file6.exists()) return;
                if (file6.delete()) return;
                log.info("Could not delete temporary file " + file6.getName() + " from dir " + file.getAbsolutePath());
                return;
            }
            catch (IOException iOException) {
                log.error("Failed to store NM credentials", iOException);
                Object var7_7 = null;
                File file7 = new File(string);
                if (!file7.exists()) return;
                if (file7.delete()) return;
                log.info("Could not delete temporary file " + file7.getName() + " from dir " + file.getAbsolutePath());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            File file4 = new File(string);
            if (!file4.exists()) throw throwable;
            if (file4.delete()) throw throwable;
            log.info("Could not delete temporary file " + file4.getName() + " from dir " + file.getAbsolutePath());
            throw throwable;
        }
        Object var7_5 = null;
        File file5 = new File(string);
        if (!file5.exists()) return;
        if (file5.delete()) return;
        log.info("Could not delete temporary file " + file5.getName() + " from dir " + file.getAbsolutePath());
    }

    private static void setFileProtected(File file) {
        try {
            if (System.getProperty("os.name").indexOf("Sun") != -1 || System.getProperty("os.name").indexOf("Linux") != -1) {
                String string = "chmod 600 " + file.getAbsolutePath();
                Process process = Runtime.getRuntime().exec(string);
                process.waitFor();
                if (process.exitValue() != 0) {
                    log.warning("Could not set file permissions to 600");
                }
            }
        }
        catch (IOException iOException) {
            log.warning("Failed to change file permissions", iOException);
        }
        catch (InterruptedException interruptedException) {
            log.warning("Process running chmod was interupted. Don't know if it finished it's job...", interruptedException);
        }
    }
}

