/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.NavigableSet;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class ConcurrentSkipListSet
extends AbstractSet
implements NavigableSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143111061671589L;
    private final ConcurrentSkipListMap m;

    public ConcurrentSkipListSet() {
        this.m = new ConcurrentSkipListMap();
    }

    public ConcurrentSkipListSet(Comparator comparator) {
        this.m = new ConcurrentSkipListMap(comparator);
    }

    public ConcurrentSkipListSet(Collection collection) {
        this.m = new ConcurrentSkipListMap();
        this.addAll(collection);
    }

    public ConcurrentSkipListSet(SortedSet sortedSet) {
        this.m = new ConcurrentSkipListMap(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    public Object clone() {
        ConcurrentSkipListSet concurrentSkipListSet = null;
        try {
            concurrentSkipListSet = (ConcurrentSkipListSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        concurrentSkipListSet.m.initialize();
        concurrentSkipListSet.addAll(this);
        return concurrentSkipListSet;
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    public boolean add(Object object) {
        return this.m.putIfAbsent(object, Boolean.TRUE) == null;
    }

    public boolean remove(Object object) {
        return this.m.removep(object);
    }

    public void clear() {
        this.m.clear();
    }

    public Iterator iterator() {
        return this.m.keyIterator();
    }

    public Iterator descendingIterator() {
        return this.m.descendingKeyIterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)object;
        try {
            return this.containsAll(collection) && collection.containsAll(this);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public Object lower(Object object) {
        return this.m.lowerKey(object);
    }

    public Object floor(Object object) {
        return this.m.floorKey(object);
    }

    public Object ceiling(Object object) {
        return this.m.ceilingKey(object);
    }

    public Object higher(Object object) {
        return this.m.higherKey(object);
    }

    public Object pollFirst() {
        return this.m.pollFirstKey();
    }

    public Object pollLast() {
        return this.m.pollLastKey();
    }

    public Comparator comparator() {
        return this.m.comparator();
    }

    public Object first() {
        return this.m.firstKey();
    }

    public Object last() {
        return this.m.lastKey();
    }

    public NavigableSet navigableSubSet(Object object, Object object2) {
        return new ConcurrentSkipListSubSet(this.m, object, object2);
    }

    public NavigableSet navigableHeadSet(Object object) {
        return new ConcurrentSkipListSubSet(this.m, null, object);
    }

    public NavigableSet navigableTailSet(Object object) {
        return new ConcurrentSkipListSubSet(this.m, object, null);
    }

    public SortedSet subSet(Object object, Object object2) {
        return this.navigableSubSet(object, object2);
    }

    public SortedSet headSet(Object object) {
        return this.navigableHeadSet(object);
    }

    public SortedSet tailSet(Object object) {
        return this.navigableTailSet(object);
    }

    static class ConcurrentSkipListSubSet
    extends AbstractSet
    implements NavigableSet,
    Serializable {
        private static final long serialVersionUID = -7647078645896651609L;
        private final ConcurrentSkipListMap.ConcurrentSkipListSubMap s;

        ConcurrentSkipListSubSet(ConcurrentSkipListMap concurrentSkipListMap, Object object, Object object2) {
            this.s = new ConcurrentSkipListMap.ConcurrentSkipListSubMap(concurrentSkipListMap, object, object2);
        }

        public NavigableSet navigableSubSet(Object object, Object object2) {
            if (!this.s.inOpenRange(object) || !this.s.inOpenRange(object2)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet(this.s.getMap(), object, object2);
        }

        public NavigableSet navigableHeadSet(Object object) {
            Object object2 = this.s.getLeast();
            if (!this.s.inOpenRange(object)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet(this.s.getMap(), object2, object);
        }

        public NavigableSet navigableTailSet(Object object) {
            Object object2 = this.s.getFence();
            if (!this.s.inOpenRange(object)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet(this.s.getMap(), object, object2);
        }

        public SortedSet subSet(Object object, Object object2) {
            return this.navigableSubSet(object, object2);
        }

        public SortedSet headSet(Object object) {
            return this.navigableHeadSet(object);
        }

        public SortedSet tailSet(Object object) {
            return this.navigableTailSet(object);
        }

        public int size() {
            return this.s.size();
        }

        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        public boolean contains(Object object) {
            return this.s.containsKey(object);
        }

        public void clear() {
            this.s.clear();
        }

        public Object first() {
            return this.s.firstKey();
        }

        public Object last() {
            return this.s.lastKey();
        }

        public Object ceiling(Object object) {
            return this.s.ceilingKey(object);
        }

        public Object lower(Object object) {
            return this.s.lowerKey(object);
        }

        public Object floor(Object object) {
            return this.s.floorKey(object);
        }

        public Object higher(Object object) {
            return this.s.higherKey(object);
        }

        public boolean remove(Object object) {
            return this.s.remove(object) == Boolean.TRUE;
        }

        public boolean add(Object object) {
            return this.s.put(object, Boolean.TRUE) == null;
        }

        public Comparator comparator() {
            return this.s.comparator();
        }

        public Iterator iterator() {
            return this.s.keySet().iterator();
        }

        public Iterator descendingIterator() {
            return this.s.descendingKeySet().iterator();
        }

        public Object pollFirst() {
            Map.Entry entry = this.s.pollFirstEntry();
            return entry == null ? null : entry.getKey();
        }

        public Object pollLast() {
            Map.Entry entry = this.s.pollLastEntry();
            return entry == null ? null : entry.getKey();
        }
    }
}

