/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.DelayQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.List;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = Utils.nanoTime();

    final long now() {
        return Utils.nanoTime() - NANO_ORIGIN;
    }

    private void delayedExecute(Runnable runnable) {
        if (this.isShutdown()) {
            this.reject(runnable);
            return;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        super.getQueue().add(runnable);
    }

    private void cancelUnwantedTasks() {
        boolean bl = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean bl2 = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!bl && !bl2) {
            super.getQueue().clear();
        } else if (bl || bl2) {
            Object[] objectArray = super.getQueue().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                RunnableScheduledFuture runnableScheduledFuture;
                Object object = objectArray[i2];
                if (!(object instanceof RunnableScheduledFuture) || !((runnableScheduledFuture = (RunnableScheduledFuture)object).isPeriodic() ? !bl2 : !bl)) continue;
                runnableScheduledFuture.cancel(false);
            }
            objectArray = null;
            this.purge();
        }
    }

    public boolean remove(Runnable runnable) {
        if (!(runnable instanceof RunnableScheduledFuture)) {
            return false;
        }
        return this.getQueue().remove(runnable);
    }

    protected RunnableScheduledFuture decorateTask(Runnable runnable, RunnableScheduledFuture runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    protected RunnableScheduledFuture decorateTask(Callable callable, RunnableScheduledFuture runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    public ScheduledThreadPoolExecutor(int n2) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayQueue());
    }

    public ScheduledThreadPoolExecutor(int n2, ThreadFactory threadFactory) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayQueue(), rejectedExecutionHandler);
    }

    public ScheduledThreadPoolExecutor(int n2, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayQueue(), threadFactory, rejectedExecutionHandler);
    }

    public ScheduledFuture schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        long l3 = this.now() + timeUnit.toNanos(l2);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(runnable, (RunnableScheduledFuture)new ScheduledFutureTask(runnable, null, l3));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public ScheduledFuture schedule(Callable callable, long l2, TimeUnit timeUnit) {
        if (callable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l3 = this.now() + timeUnit.toNanos(l2);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(callable, (RunnableScheduledFuture)new ScheduledFutureTask(callable, l3));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l4 = this.now() + timeUnit.toNanos(l2);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(runnable, (RunnableScheduledFuture)new ScheduledFutureTask(runnable, null, l4, timeUnit.toNanos(l3)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l4 = this.now() + timeUnit.toNanos(l2);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(runnable, (RunnableScheduledFuture)new ScheduledFutureTask(runnable, null, l4, timeUnit.toNanos(-l3)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable runnable) {
        return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable runnable, Object object) {
        return this.schedule(Executors.callable(runnable, object), 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Callable callable) {
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean bl) {
        this.continueExistingPeriodicTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean bl) {
        this.executeExistingDelayedTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void shutdown() {
        this.cancelUnwantedTasks();
        super.shutdown();
    }

    public List shutdownNow() {
        return super.shutdownNow();
    }

    public BlockingQueue getQueue() {
        return super.getQueue();
    }

    private class ScheduledFutureTask
    extends FutureTask
    implements RunnableScheduledFuture {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(Runnable runnable, Object object, long l2) {
            super(runnable, object);
            this.time = l2;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable runnable, Object object, long l2, long l3) {
            super(runnable, object);
            this.time = l2;
            this.period = l3;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable callable, long l2) {
            super(callable);
            this.time = l2;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public long getDelay(TimeUnit timeUnit) {
            long l2 = timeUnit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return l2;
        }

        public int compareTo(Object object) {
            return this.compareTo((Delayed)object);
        }

        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
            long l2 = this.time - scheduledFutureTask.time;
            if (l2 < 0L) {
                return -1;
            }
            if (l2 > 0L) {
                return 1;
            }
            if (this.sequenceNumber < scheduledFutureTask.sequenceNumber) {
                return -1;
            }
            return 1;
        }

        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            boolean bl = ScheduledFutureTask.super.runAndReset();
            boolean bl2 = ScheduledThreadPoolExecutor.this.isShutdown();
            if (bl && (!bl2 || ScheduledThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !ScheduledThreadPoolExecutor.this.isTerminating())) {
                long l2 = this.period;
                this.time = l2 > 0L ? (this.time += l2) : ScheduledThreadPoolExecutor.this.now() - l2;
                ScheduledThreadPoolExecutor.super.getQueue().add(this);
            } else if (bl2) {
                ScheduledThreadPoolExecutor.this.interruptIdleWorkers();
            }
        }

        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                ScheduledFutureTask.super.run();
            }
        }
    }
}

