/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStreamConfiguration;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.IORMutator;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.typecode.DelegatingTypeCodeReader;
import org.jacorb.orb.typecode.TypeCodeCache;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Stack;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public class CDRInputStream
extends InputStream {
    private Stack encaps_stack;
    private SortedMap repeatedTCMap;
    private Map recursiveTCMap;
    private int marked_pos;
    private int marked_index;
    private int marked_chunk_end_pos;
    private int marked_valueNestingLevel;
    private boolean closed;
    Logger logger;
    private boolean cometInteropFix;
    private boolean laxBooleanEncoding;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    protected int giop_minor = 2;
    private Map valueMap;
    private int currentValueIndex;
    private Map repIdMap;
    private Map codebaseMap;
    private boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    private boolean chunkedValue = false;
    private int valueNestingLevel = 0;
    private int chunk_end_pos = -1;
    private IORMutator mutator;
    private boolean isMutatorEnabled;
    private boolean codesetEnabled;
    private final org.omg.CORBA.ORB orb;
    private static final int MAX_BLOCK_SIZE = 0x7FFFFF00;
    private boolean sunInteropFix;
    private static final DelegatingTypeCodeReader typeCodeReader = new DelegatingTypeCodeReader();
    private final TypeCodeCache typeCodeCache;
    private int typeCodeNestingLevel = -1;
    private boolean enableNullString = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$Any;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InputStream;

    private CDRInputStream(org.omg.CORBA.ORB orb) {
        this.orb = orb == null ? ORB.init() : orb;
        if (!(this.orb instanceof ORBSingleton)) {
            throw new BAD_PARAM("don't pass in a non JacORB ORB");
        }
        try {
            this.configure(((ORBSingleton)this.orb).getConfiguration());
        }
        catch (ConfigurationException e2) {
            throw new INTERNAL("ConfigurationException: " + e2);
        }
        this.typeCodeCache = ((ORBSingleton)this.orb).getTypeCodeCache();
    }

    private CDRInputStream(org.omg.CORBA.ORB orb, byte[] buffer, java.lang.Object ignored) {
        this(orb);
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
    }

    public CDRInputStream(byte[] buffer) {
        this(null, buffer, null);
    }

    public CDRInputStream(org.omg.CORBA.ORB orb, byte[] buf) {
        this(orb, buf, null);
        if (orb == null) {
            throw new BAD_PARAM("don't pass in a null ORB");
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB orb, byte[] buf, boolean littleEndian) {
        this(orb, buf);
        this.littleEndian = littleEndian;
    }

    private void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration jacorbConfig = (org.jacorb.config.Configuration)configuration;
        CDRInputStreamConfiguration cdrConfig = (CDRInputStreamConfiguration)jacorbConfig.getAttributeAsObject("jacorb.orb.cdr.in.config", CDRInputStreamConfiguration.CONFIG_DEFAULT);
        this.logger = cdrConfig.logger;
        this.codesetEnabled = cdrConfig.codesetEnabled;
        this.cometInteropFix = cdrConfig.cometInteropFix;
        this.laxBooleanEncoding = cdrConfig.laxBooleanEncoding;
        this.sunInteropFix = cdrConfig.sunInteropFix;
        this.isMutatorEnabled = cdrConfig.isMutatorEnabled;
        this.enableNullString = cdrConfig.enableNullString;
        if (this.isMutatorEnabled) {
            this.mutator = (IORMutator)jacorbConfig.getAttributeAsObject("jacorb.iormutator");
        }
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new HashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    public void setGIOPMinor(int giop_minor) {
        this.giop_minor = giop_minor;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.encaps_stack = null;
        this.closed = true;
        if (this.recursiveTCMap != null) {
            this.recursiveTCMap.clear();
        }
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public void setCodeSet(int codeSet, int codeSetWide) {
        this.codeSet = codeSet;
        this.codeSetW = codeSetWide;
    }

    private static final int _read4int(boolean _littleEndian, byte[] _buffer, int _pos) {
        if (_littleEndian) {
            return ((_buffer[_pos + 3] & 0xFF) << 24) + ((_buffer[_pos + 2] & 0xFF) << 16) + ((_buffer[_pos + 1] & 0xFF) << 8) + ((_buffer[_pos] & 0xFF) << 0);
        }
        return ((_buffer[_pos] & 0xFF) << 24) + ((_buffer[_pos + 1] & 0xFF) << 16) + ((_buffer[_pos + 2] & 0xFF) << 8) + ((_buffer[_pos + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean _littleEndian, byte[] _buffer, int _pos) {
        if (_littleEndian) {
            return (short)(((_buffer[_pos + 1] & 0xFF) << 8) + ((_buffer[_pos] & 0xFF) << 0));
        }
        return (short)(((_buffer[_pos] & 0xFF) << 8) + ((_buffer[_pos + 1] & 0xFF) << 0));
    }

    private final int _read_long() {
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    private final long _read_longlong() {
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    private final void handle_chunking() {
        int aligned_pos;
        int remainder = 4 - this.index % 4;
        int n2 = aligned_pos = remainder != 4 ? this.pos + remainder : this.pos;
        if (this.chunk_end_pos >= this.pos && this.chunk_end_pos <= aligned_pos) {
            this.chunk_end_pos = -1;
            int saved_pos = this.pos;
            int saved_index = this.index;
            int tag = this.read_long();
            if (tag < 0) {
                if (-tag > this.valueNestingLevel) {
                    throw new INTERNAL("received end tag " + tag + " with value nesting level " + this.valueNestingLevel);
                }
                this.valueNestingLevel = -tag;
                --this.valueNestingLevel;
                if (this.valueNestingLevel > 0) {
                    this.chunk_end_pos = this.pos;
                    this.handle_chunking();
                }
            } else if (tag < 0x7FFFFF00) {
                this.chunk_end_pos = this.pos + tag;
            } else {
                this.pos = saved_pos;
                this.index = saved_index;
            }
        }
    }

    public final void skip(int distance) {
        this.pos += distance;
        this.index += distance;
    }

    public final void closeEncapsulation() {
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        EncapsInfo ei = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = ei.littleEndian;
        int start = ei.start;
        int size = ei.size;
        if (this.pos < start + size) {
            this.pos = start + size;
        }
        this.index = ei.index + size;
    }

    public final int openEncapsulation() {
        boolean old_endian = this.littleEndian;
        int size = this.read_long();
        if (this.cometInteropFix && (size < 0 || size > this.buffer.length)) {
            int temp = (size >> 24 & 0xFF) + (size >> 8 & 0xFF00) + (size << 8 & 0xFF0000) + (size << 24 & 0xFF000000);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of CDR encapsulation larger than buffer, swapping byte order\nSize of CDR encapsulation was " + size + ", is now " + temp);
            }
            size = temp;
        }
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        this.encaps_stack.push(new EncapsInfo(old_endian, this.index, this.pos, size));
        this.openEncapsulatedArray();
        return size;
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBufferCopy() {
        byte[] result = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, result, 0, this.buffer.length);
        return result;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        ++this.index;
        return this.buffer[this.pos++];
    }

    public int available() {
        return this.buffer.length - this.index;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new IOException("buffer may not be null");
        }
        if (off < 0 || len < 0 || off + len > b2.length) {
            throw new IOException("buffer index out of bounds");
        }
        if (len == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int min = Math.min(len, this.available());
        System.arraycopy(this.buffer, this.index, b2, off, min);
        this.pos += min;
        this.index += min;
        return min;
    }

    public final Any read_any() {
        org.omg.CORBA.TypeCode _tc = this.read_TypeCode();
        Any any = this.orb.create_any();
        any.read_value(this, _tc);
        return any;
    }

    public final boolean read_boolean() {
        this.handle_chunking();
        ++this.index;
        byte value = this.buffer[this.pos++];
        return this.parseBoolean(value);
    }

    public final void read_boolean_array(boolean[] value, int offset, int length) {
        this.handle_chunking();
        if (length == 0) {
            return;
        }
        int until = offset + length;
        int j2 = offset;
        do {
            byte bb = this.buffer[this.pos++];
            value[j2] = this.parseBoolean(bb);
        } while (++j2 < until);
        this.index += length;
    }

    private final boolean parseBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        if (this.laxBooleanEncoding) {
            return true;
        }
        throw new MARSHAL("Unexpected boolean value: " + value + " pos: " + this.pos);
    }

    public final char read_char() {
        this.handle_chunking();
        ++this.index;
        return (char)(this.buffer[this.pos++] & 0xFF);
    }

    public final void read_char_array(char[] value, int offset, int length) {
        int stop = offset + length;
        if (value == null) {
            throw new MARSHAL("Cannot marshall result into null array.");
        }
        if (stop > value.length || length < 0 || offset < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        this.handle_chunking();
        for (int j2 = offset; j2 < stop; ++j2) {
            value[j2] = (char)(0xFF & this.buffer[this.pos++]);
        }
        this.index += length;
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = Double.longBitsToDouble(this._read_longlong());
        }
    }

    public BigDecimal read_fixed() {
        this.handle_chunking();
        StringBuffer sb = new StringBuffer();
        int signum = this.read_fixed_internal(sb, (short)-1);
        BigDecimal result = new BigDecimal(new BigInteger(sb.toString()));
        return this.read_fixed_negate(signum, result);
    }

    public BigDecimal read_fixed(short digits, short scale) {
        if (digits < 1) {
            throw new BAD_PARAM("digits must be a positive value: " + digits + ".");
        }
        if (scale < 0) {
            throw new BAD_PARAM("scale must be a non-negative value: " + scale + ".");
        }
        if (scale > digits) {
            throw new BAD_PARAM("scale factor " + scale + " must be less than or equal to the total number of digits " + digits + ".");
        }
        this.handle_chunking();
        StringBuffer sb = new StringBuffer();
        int c2 = this.read_fixed_internal(sb, digits);
        BigDecimal result = new BigDecimal(new BigInteger(sb.toString()), scale);
        return this.read_fixed_negate(c2, result);
    }

    private BigDecimal read_fixed_negate(int signum, BigDecimal result) {
        if (signum == 13) {
            return result.negate();
        }
        return result;
    }

    private int read_fixed_internal(StringBuffer outBuffer, short digits) {
        byte b2 = this.buffer[this.pos++];
        int c2 = b2 & 0xF;
        ++this.index;
        while (true) {
            c2 = (b2 & 0xF0) >>> 4;
            if (outBuffer.length() > 0 || c2 != 0) {
                outBuffer.append(c2);
            }
            if ((c2 = b2 & 0xF) == 12 || c2 == 13) break;
            outBuffer.append(c2);
            b2 = this.buffer[this.pos++];
            ++this.index;
        }
        if (digits != -1 && outBuffer.length() > digits) {
            throw new MARSHAL("unexpected number of digits: expected " + digits + " got " + outBuffer.length() + " " + outBuffer);
        }
        return c2;
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = Float.intBitsToFloat(this._read_long());
        }
    }

    public final int read_long() {
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    public final void read_long_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * length;
    }

    public final long read_longlong() {
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        return this._read_longlong();
    }

    public final void read_longlong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            for (int j2 = offset; j2 < offset + length; ++j2) {
                value[j2] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int j3 = offset; j3 < offset + length; ++j3) {
                value[j3] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final Object read_Object() {
        if (!(this.orb instanceof ORB)) {
            throw new MARSHAL("Cannot use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        this.handle_chunking();
        IOR ior = IORHelper.read(this);
        if (this.isMutatorEnabled) {
            ior = this.mutator.mutateIncoming(ior);
        }
        if (ParsedIOR.isNull(ior)) {
            return null;
        }
        return ((ORB)this.orb)._getObject(ior);
    }

    public Object read_Object(Class clazz) {
        if (ObjectImpl.class.isAssignableFrom(clazz)) {
            Object obj = this.read_Object();
            if (obj instanceof ObjectImpl) {
                ObjectImpl stub = null;
                try {
                    stub = (ObjectImpl)clazz.newInstance();
                }
                catch (InstantiationException e2) {
                    throw new MARSHAL("Exception in stub instantiation: " + e2);
                }
                catch (IllegalAccessException e3) {
                    throw new MARSHAL("Exception in stub instantiation: " + e3);
                }
                stub._set_delegate(((ObjectImpl)obj)._get_delegate());
                return stub;
            }
            return obj;
        }
        if (clazz.isInterface() && ValueHandler.isAssignableFrom(clazz)) {
            return (Object)ValueHandler.portableRemoteObject_narrow(this.read_Object(), clazz);
        }
        return this.read_Object();
    }

    public final byte read_octet() {
        this.handle_chunking();
        ++this.index;
        return this.buffer[this.pos++];
    }

    public final void read_octet_array(byte[] value, int offset, int length) {
        this.handle_chunking();
        System.arraycopy(this.buffer, this.pos, value, offset, length);
        this.index += length;
        this.pos += length;
    }

    public final Principal read_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final short read_short() {
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        short result = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return result;
    }

    public final void read_short_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += length * 2;
    }

    public final String read_string() {
        int size;
        String result = null;
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if ((size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos)) < 1 && !this.enableNullString) {
            throw new MARSHAL("invalid string size: " + size);
        }
        int start = this.pos + 4;
        this.index += size + 4;
        this.pos += size + 4;
        int stringTerminatorPosition = start + size - 1;
        if (this.enableNullString && size == 0) {
            return null;
        }
        if (this.buffer.length < stringTerminatorPosition + 1) {
            throw new MARSHAL("buffer to small");
        }
        if (this.buffer[stringTerminatorPosition] != 0) {
            throw new MARSHAL("unexpected string terminator value " + Integer.toHexString(this.buffer[stringTerminatorPosition]) + " at buffer index " + stringTerminatorPosition);
        }
        if (--size == 0) {
            return "";
        }
        if (start + size > this.buffer.length) {
            String message = "Size (" + size + ") invalid for string extraction from buffer length of " + this.buffer.length + " from position " + start;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message);
            }
            throw new MARSHAL(message);
        }
        if (this.codesetEnabled) {
            String csname = CodeSet.csName(this.codeSet);
            try {
                result = new String(this.buffer, start, size, csname);
            }
            catch (UnsupportedEncodingException ex) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Charset " + csname + " is unsupported");
                    result = "";
                }
            }
        } else {
            char[] buf = new char[size];
            for (int i2 = 0; i2 < size; ++i2) {
                buf[i2] = (char)(0xFF & this.buffer[start + i2]);
            }
            result = new String(buf);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final org.omg.CORBA.TypeCode read_TypeCode() {
        if (this.recursiveTCMap == null) {
            this.recursiveTCMap = new HashMap();
        }
        if (this.repeatedTCMap == null) {
            this.repeatedTCMap = new TreeMap();
        }
        try {
            org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(this.recursiveTCMap, this.repeatedTCMap);
            return typeCode;
        }
        finally {
            this.recursiveTCMap.clear();
            this.repeatedTCMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final org.omg.CORBA.TypeCode read_TypeCode(Map recursiveTCMap, Map repeatedTCMap) {
        try {
            ++this.typeCodeNestingLevel;
            org.omg.CORBA.TypeCode typeCode = typeCodeReader.readTypeCode(this.logger, this, recursiveTCMap, repeatedTCMap);
            return typeCode;
        }
        finally {
            --this.typeCodeNestingLevel;
        }
    }

    public void skipRemainingTypeCode(Integer start_pos, int size) {
        this.skip(size - (this.pos - start_pos - 4 - 4));
    }

    public final int read_ulong() {
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    public final void read_ulong_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * length;
    }

    public final long read_ulonglong() {
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_ulonglong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            for (int j2 = offset; j2 < offset + length; ++j2) {
                value[j2] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int j3 = offset; j3 < offset + length; ++j3) {
                value[j3] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final short read_ushort() {
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        short result = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return result;
    }

    public final void read_ushort_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += length * 2;
    }

    public final char read_wchar() {
        if (this.giop_minor == 0) {
            int minor = Messages.getMsgType(this.buffer) == 1 ? 6 : 5;
            throw new MARSHAL("GIOP 1.0 does not support the type wchar", minor, CompletionStatus.COMPLETED_NO);
        }
        this.handle_chunking();
        if (this.giop_minor == 2) {
            this.read_wchar_size();
            boolean wchar_little_endian = this.readBOM();
            return this.read_wchar(wchar_little_endian);
        }
        return this.read_wchar(this.littleEndian);
    }

    private final int read_wchar_size() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final char read_wchar(boolean wchar_little_endian) {
        switch (this.codeSetW) {
            case 0x5010001: {
                if (this.giop_minor < 2) {
                    throw new MARSHAL("GIOP 1." + this.giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
                }
                short value = (short)(0xFF & this.buffer[this.pos++]);
                ++this.index;
                if ((value & 0x80) == 0) {
                    return (char)value;
                }
                if ((value & 0xE0) == 192) {
                    ++this.index;
                    return (char)((value & 0x1F) << 6 | this.buffer[this.pos++] & 0x3F);
                }
                this.index += 2;
                short b2 = (short)(0xFF & this.buffer[this.pos++]);
                return (char)((value & 0xF) << 12 | (b2 & 0x3F) << 6 | this.buffer[this.pos++] & 0x3F);
            }
            case 65801: {
                char value = wchar_little_endian ? (char)(this.buffer[this.pos++] & 0xFF | this.buffer[this.pos++] << 8) : (char)(this.buffer[this.pos++] << 8 | this.buffer[this.pos++] & 0xFF);
                this.index += 2;
                return value;
            }
        }
        throw new MARSHAL("Bad CodeSet: " + this.codeSetW);
    }

    private final boolean readBOM() {
        if (this.buffer[this.pos] == -2 && this.buffer[this.pos + 1] == -1) {
            this.pos += 2;
            this.index += 2;
            return false;
        }
        if (this.buffer[this.pos] == -1 && this.buffer[this.pos + 1] == -2) {
            this.pos += 2;
            this.index += 2;
            return true;
        }
        return false;
    }

    public final void read_wchar_array(char[] value, int offset, int length) {
        this.handle_chunking();
        for (int j2 = offset; j2 < offset + length; ++j2) {
            value[j2] = this.read_wchar();
        }
    }

    public final String read_wstring() {
        if (this.giop_minor == 0) {
            int minor = Messages.getMsgType(this.buffer) == 1 ? 6 : 5;
            throw new MARSHAL("GIOP 1.0 does not support the IDL type wstring", minor, CompletionStatus.COMPLETED_NO);
        }
        String result = null;
        char[] buf = null;
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.giop_minor == 2) {
            int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            if (size == 0) {
                return "";
            }
            buf = new char[size];
            int i2 = 0;
            int endPos = this.pos + size;
            boolean wchar_litte_endian = this.readBOM();
            while (this.pos < endPos) {
                buf[i2++] = this.read_wchar(wchar_litte_endian);
            }
            result = new String(buf, 0, i2);
        } else {
            int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            buf = new char[size];
            int endPos = this.pos + size;
            if (this.codeSetW == 65801) {
                endPos += size;
            }
            int i3 = 0;
            while (this.pos < endPos) {
                buf[i3++] = this.read_wchar(this.littleEndian);
            }
            result = i3 != 0 && buf[i3 - 1] == '\u0000' ? new String(buf, 0, i3 - 1) : new String(buf, 0, i3);
        }
        buf = null;
        return result;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readLimit) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
        this.marked_chunk_end_pos = this.chunk_end_pos;
        this.marked_valueNestingLevel = this.valueNestingLevel;
    }

    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new MARSHAL("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
        this.chunk_end_pos = this.marked_chunk_end_pos;
        this.valueNestingLevel = this.marked_valueNestingLevel;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean b2) {
        this.littleEndian = b2;
    }

    protected boolean getLittleEndian() {
        return this.littleEndian;
    }

    final void read_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.OutputStream out) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int kind = typeCode.kind().value();
        try {
            switch (kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    out.write_short(this.read_short());
                    break;
                }
                case 3: {
                    out.write_long(this.read_long());
                    break;
                }
                case 4: {
                    out.write_ushort(this.read_ushort());
                    break;
                }
                case 5: {
                    out.write_ulong(this.read_ulong());
                    break;
                }
                case 6: {
                    out.write_float(this.read_float());
                    break;
                }
                case 7: {
                    out.write_double(this.read_double());
                    break;
                }
                case 8: {
                    out.write_boolean(this.read_boolean());
                    break;
                }
                case 9: {
                    out.write_char(this.read_char());
                    break;
                }
                case 10: {
                    out.write_octet(this.read_octet());
                    break;
                }
                case 11: {
                    out.write_any(this.read_any());
                    break;
                }
                case 12: {
                    out.write_TypeCode(this.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    out.write_Object(this.read_Object());
                    break;
                }
                case 15: {
                    for (int i2 = 0; i2 < typeCode.member_count(); ++i2) {
                        this.read_value(typeCode.member_type(i2), out);
                    }
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode disc = typeCode.discriminator_type();
                    disc = TypeCode.originalType(disc);
                    int def_idx = typeCode.default_index();
                    int member_idx = -1;
                    block33 : switch (disc.kind().value()) {
                        case 2: {
                            short s2 = this.read_short();
                            out.write_short(s2);
                            for (int i3 = 0; i3 < typeCode.member_count(); ++i3) {
                                if (i3 == def_idx || s2 != typeCode.member_label(i3).extract_short()) continue;
                                member_idx = i3;
                                break block33;
                            }
                            break;
                        }
                        case 3: {
                            int s3 = this.read_long();
                            out.write_long(s3);
                            for (int i4 = 0; i4 < typeCode.member_count(); ++i4) {
                                if (i4 == def_idx || s3 != typeCode.member_label(i4).extract_long()) continue;
                                member_idx = i4;
                                break block33;
                            }
                            break;
                        }
                        case 4: {
                            short s4 = this.read_ushort();
                            out.write_ushort(s4);
                            for (int i5 = 0; i5 < typeCode.member_count(); ++i5) {
                                if (i5 == def_idx || s4 != typeCode.member_label(i5).extract_ushort()) continue;
                                member_idx = i5;
                                break block33;
                            }
                            break;
                        }
                        case 5: {
                            int s5 = this.read_ulong();
                            out.write_ulong(s5);
                            for (int i6 = 0; i6 < typeCode.member_count(); ++i6) {
                                if (i6 == def_idx || s5 != typeCode.member_label(i6).extract_ulong()) continue;
                                member_idx = i6;
                                break block33;
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 8: {
                            boolean b2 = this.read_boolean();
                            out.write_boolean(b2);
                            for (int i7 = 0; i7 < typeCode.member_count(); ++i7) {
                                if (i7 == def_idx || b2 != typeCode.member_label(i7).extract_boolean()) continue;
                                member_idx = i7;
                                break block33;
                            }
                            break;
                        }
                        case 9: {
                            char s6 = this.read_char();
                            out.write_char(s6);
                            for (int i8 = 0; i8 < typeCode.member_count(); ++i8) {
                                if (i8 == def_idx || s6 != typeCode.member_label(i8).extract_char()) continue;
                                member_idx = i8;
                                break block33;
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 17: {
                            int s7 = this.read_long();
                            out.write_long(s7);
                            for (int i9 = 0; i9 < typeCode.member_count(); ++i9) {
                                int label;
                                if (i9 == def_idx || s7 != (label = typeCode.member_label(i9).create_input_stream().read_long())) continue;
                                member_idx = i9;
                                break block33;
                            }
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 23: {
                            long s8 = this.read_longlong();
                            out.write_longlong(s8);
                            for (int i10 = 0; i10 < typeCode.member_count(); ++i10) {
                                if (i10 == def_idx || s8 != typeCode.member_label(i10).extract_longlong()) continue;
                                member_idx = i10;
                                break block33;
                            }
                            break;
                        }
                        case 24: {
                            long s9 = this.read_ulonglong();
                            out.write_ulonglong(s9);
                            for (int i11 = 0; i11 < typeCode.member_count(); ++i11) {
                                if (i11 == def_idx || s9 != typeCode.member_label(i11).extract_ulonglong()) continue;
                                member_idx = i11;
                                break block33;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                    }
                    if (member_idx != -1) {
                        this.read_value(typeCode.member_type(member_idx), out);
                        break;
                    }
                    if (def_idx != -1) {
                        this.read_value(typeCode.member_type(def_idx), out);
                    }
                    break;
                }
                case 17: {
                    out.write_long(this.read_long());
                    break;
                }
                case 18: {
                    out.write_string(this.read_string());
                    break;
                }
                case 19: {
                    int len = this.read_long();
                    out.write_long(len);
                    for (int i12 = 0; i12 < len; ++i12) {
                        this.read_value(typeCode.content_type(), out);
                    }
                    break;
                }
                case 20: {
                    int length = typeCode.length();
                    for (int i13 = 0; i13 < length; ++i13) {
                        this.read_value(typeCode.content_type(), out);
                    }
                    break;
                }
                case 21: {
                    this.read_value(typeCode.content_type(), out);
                    break;
                }
                case 22: {
                    out.write_string(this.read_string());
                    for (int i14 = 0; i14 < typeCode.member_count(); ++i14) {
                        this.read_value(typeCode.member_type(i14), out);
                    }
                    break;
                }
                case 23: {
                    out.write_longlong(this.read_longlong());
                    break;
                }
                case 24: {
                    out.write_ulonglong(this.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    out.write_wchar(this.read_wchar());
                    break;
                }
                case 27: {
                    out.write_wstring(this.read_wstring());
                    break;
                }
                case 28: {
                    short digits = typeCode.fixed_digits();
                    short scale = typeCode.fixed_scale();
                    BigDecimal value = this.read_fixed(digits, scale);
                    if (out instanceof CDROutputStream) {
                        CDROutputStream cdrOut = (CDROutputStream)out;
                        cdrOut.write_fixed(value, digits, scale);
                        break;
                    }
                    out.write_fixed(value);
                    break;
                }
                case 29: {
                    Serializable val = this.read_value();
                    ((OutputStream)out).write_value(val, typeCode.id());
                    break;
                }
                case 30: {
                    String id = typeCode.id();
                    BoxedValueHelper helper = ((ORB)this.orb).getBoxedValueHelper(id);
                    if (helper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + id);
                    }
                    Serializable value = this.read_value(helper);
                    ((OutputStream)out).write_value(value, helper);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
        catch (BadKind ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
        catch (Bounds ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
    }

    public Serializable read_value() {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            throw new MARSHAL("missing value type information");
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    public Serializable read_value(String rep_id) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{rep_id}, start_offset, codebase);
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    public Serializable read_value(Serializable value) {
        if (value instanceof Streamable) {
            this.register_value(value);
            ((Streamable)((java.lang.Object)value))._read(this);
        } else if (value instanceof CustomValue) {
            this.register_value(value);
            ((CustomValue)value).unmarshal(new DataInputStream(this));
        } else {
            throw new BAD_PARAM("read_value is only implemented for Streamables");
        }
        return value;
    }

    public Serializable read_value(Class clz) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{ValueHandler.getRMIRepositoryID(clz)}, start_offset, codebase);
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    public Serializable read_value(BoxedValueHelper factory) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            Serializable result = factory.read_value(this);
            if (result != null) {
                this.getValueMap().put(ObjectUtil.newInteger(start_offset), result);
            }
            return result;
        }
        if (tag == 2147483394) {
            Serializable result = this.read_typed_value(start_offset, codebase, factory);
            if (result != null) {
                this.getValueMap().put(ObjectUtil.newInteger(start_offset), result);
            }
            return result;
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    private Serializable read_untyped_value(String[] repository_ids, int index, String codebase) {
        java.lang.Object result = null;
        if (this.chunkedValue || this.valueNestingLevel > 0) {
            ++this.valueNestingLevel;
            int chunk_size_tag = this.readChunkSizeTag();
            this.chunk_end_pos = this.pos + chunk_size_tag;
            this.handle_chunking();
        }
        for (int i2 = 0; i2 < repository_ids.length; ++i2) {
            if (repository_ids[i2].equals(WStringValueHelper.id())) {
                result = this.read_wstring();
                break;
            }
            if (repository_ids[i2].equals(StringValueHelper.id())) {
                result = this.read_string();
                break;
            }
            if (repository_ids[i2].startsWith("RMI:javax.rmi.CORBA.ClassDesc:")) {
                String classCodebase = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? CDRInputStream.class$("java.lang.String") : class$java$lang$String));
                String reposId = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? CDRInputStream.class$("java.lang.String") : class$java$lang$String));
                String className = RepositoryID.className(reposId, null);
                try {
                    result = this.loadClass(className, classCodebase);
                    break;
                }
                catch (ClassNotFoundException e2) {
                    if (i2 < repository_ids.length - 1) continue;
                    throw new MARSHAL("class not found: " + className);
                }
            }
            if (repository_ids[i2].startsWith("IDL:")) {
                ValueFactory factory = ((org.omg.CORBA_2_3.ORB)this.orb()).lookup_value_factory(repository_ids[i2]);
                if (factory != null) {
                    this.currentValueIndex = index;
                    result = factory.read_value(this);
                    break;
                }
                if (i2 < repository_ids.length - 1) continue;
                throw new MARSHAL("No factory found for: " + repository_ids[0]);
            }
            String className = RepositoryID.className(repository_ids[i2], null);
            try {
                Class clazz = this.loadClass(className, codebase);
                if ((class$org$omg$CORBA$portable$IDLEntity == null ? CDRInputStream.class$("org.omg.CORBA.portable.IDLEntity") : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz)) {
                    Method readMethod = null;
                    if (clazz != (class$org$omg$CORBA$Any == null ? CDRInputStream.class$("org.omg.CORBA.Any") : class$org$omg$CORBA$Any)) {
                        String helperClassName = clazz.getName() + "Helper";
                        try {
                            ClassLoader classLoader = clazz.getClassLoader();
                            Class<?> helperClass = classLoader == null ? ObjectUtil.classForName(helperClassName) : classLoader.loadClass(helperClassName);
                            Class[] paramTypes = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? CDRInputStream.class$("org.omg.CORBA.portable.InputStream") : class$org$omg$CORBA$portable$InputStream};
                            readMethod = helperClass.getMethod("read", paramTypes);
                        }
                        catch (ClassNotFoundException e3) {
                            throw new MARSHAL("Error loading class " + helperClassName + ": " + e3);
                        }
                        catch (NoSuchMethodException e4) {
                            throw new MARSHAL("No read method in helper class " + helperClassName + ": " + e4);
                        }
                    }
                    if (readMethod == null) {
                        result = this.read_any();
                        continue;
                    }
                    try {
                        result = (Serializable)readMethod.invoke(null, this);
                        continue;
                    }
                    catch (IllegalAccessException e5) {
                        throw new MARSHAL("Internal error: " + e5);
                    }
                    catch (InvocationTargetException e6) {
                        throw new MARSHAL("Exception unmarshaling IDLEntity: " + e6.getTargetException());
                    }
                }
                result = ValueHandler.readValue(this, index, clazz, repository_ids[i2], null);
                continue;
            }
            catch (ClassNotFoundException e7) {
                if (i2 < repository_ids.length - 1) continue;
                throw new MARSHAL("class not found: " + className);
            }
        }
        if (result != null) {
            this.getValueMap().put(ObjectUtil.newInteger(index), result);
        }
        return result;
    }

    private Class loadClass(String className, String codebase) throws ClassNotFoundException {
        Class clazz;
        ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader();
        if (clazzLoader == null) {
            clazz = ValueHandler.loadClass(className, codebase, null);
        } else {
            try {
                clazz = clazzLoader.loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                clazz = ValueHandler.loadClass(className, codebase, null);
            }
        }
        return clazz;
    }

    private int readChunkSizeTag() {
        int savedPos = this.pos;
        int savedIndex = this.index;
        int chunk_size_tag = this.read_long();
        if (!this.sunInteropFix || chunk_size_tag >= 0 && chunk_size_tag < 0x7FFFFF00) {
            return chunk_size_tag;
        }
        this.pos = savedPos;
        this.index = savedIndex;
        return 0x7FFFFF00;
    }

    private Serializable read_typed_value(int index, String codebase) {
        return this.read_untyped_value(new String[]{this.read_repository_id()}, index, codebase);
    }

    private Serializable read_typed_value(int index, String codebase, BoxedValueHelper factory) {
        String repId = this.read_repository_id();
        if (!factory.get_id().equals(repId)) {
            throw new MARSHAL("unexpected RepositoryID. expected: " + factory.get_id() + " got: " + repId);
        }
        return factory.read_value(this);
    }

    private Serializable read_multi_typed_value(int index, String codebase) {
        int id_count = this.read_long();
        String[] ids = new String[id_count];
        for (int i2 = 0; i2 < id_count; ++i2) {
            ids[i2] = this.read_repository_id();
        }
        return this.read_untyped_value(ids, index, codebase);
    }

    private String read_repository_id() {
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            index = index + this.pos - 4;
            String repId = (String)this.getRepIdMap().get(ObjectUtil.newInteger(index));
            if (repId == null) {
                throw new MARSHAL("stale RepositoryID indirection");
            }
            return repId;
        }
        this.pos -= 4;
        this.index -= 4;
        int start_offset = this.pos;
        String repId = this.read_string();
        this.getRepIdMap().put(ObjectUtil.newInteger(start_offset), repId);
        return repId;
    }

    private String read_codebase() {
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            index = index + this.pos - 4;
            String codebase = (String)this.getCodebaseMap().get(ObjectUtil.newInteger(index));
            if (codebase == null) {
                throw new MARSHAL("stale codebase indirection");
            }
            return codebase;
        }
        this.pos -= 4;
        this.index -= 4;
        int start_offset = this.pos;
        String codebase = this.read_string();
        this.getCodebaseMap().put(ObjectUtil.newInteger(start_offset), codebase);
        return codebase;
    }

    private Serializable read_indirect_value() {
        int index = this.read_long();
        index = index + this.pos - 4;
        java.lang.Object value = this.getValueMap().get(ObjectUtil.newInteger(index));
        if (value == null) {
            throw new IndirectionException(index);
        }
        return (Serializable)value;
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_boolean() ? this.read_Object() : this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        return this.read_boolean() ? this.read_Object(clazz) : this.read_value(clazz);
    }

    public int get_pos() {
        return this.pos;
    }

    public void register_value(Serializable value) {
        this.getValueMap().put(ObjectUtil.newInteger(this.currentValueIndex), value);
    }

    public void updateMutatorConnection(GIOPConnection connection) {
        if (this.isMutatorEnabled) {
            this.mutator.updateConnection(connection.getTransport());
        }
    }

    public void updateTypeCodeCache(String repositoryID, Integer startPosition, int size) {
        Integer from = ObjectUtil.newInteger(startPosition);
        Integer to = ObjectUtil.newInteger(startPosition + size);
        SortedMap sortedMap = this.repeatedTCMap.subMap(from, to);
        ArrayList<TypeCodeCache.Pair> toBeCached = new ArrayList<TypeCodeCache.Pair>();
        Iterator<Integer> j2 = sortedMap.keySet().iterator();
        while (j2.hasNext()) {
            Integer key = j2.next();
            TypeCode value = (TypeCode)sortedMap.get(key);
            Integer offset = ObjectUtil.newInteger(key - startPosition);
            toBeCached.add(new TypeCodeCache.Pair(value, offset));
        }
        this.typeCodeCache.cacheTypeCode(repositoryID, toBeCached.toArray(new TypeCodeCache.Pair[toBeCached.size()]));
    }

    public org.omg.CORBA.TypeCode readTypeCodeCache(String repositoryID, Integer startPosition) {
        TypeCodeCache.Pair[] result = this.typeCodeCache.getCachedTypeCodes(repositoryID);
        if (result == null) {
            return null;
        }
        if (result.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < result.length; ++i2) {
            Integer position = ObjectUtil.newInteger(startPosition + result[i2].position);
            this.repeatedTCMap.put(position, result[i2].typeCode);
        }
        return result[0].typeCode;
    }

    public String getIndentString() {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < this.typeCodeNestingLevel; ++i2) {
            buffer.append("    ");
        }
        return buffer.toString();
    }

    public Logger getLogger() {
        return this.logger;
    }
}

