/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.orb.listener.SSLSessionListener;

public class SSLListenerUtil {
    public static void addListener(ORB orb, Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSessionListener listener = orb.getTransportManager().getSocketFactoryManager().getSSLListener();
            Logger logger = orb.getConfiguration().getNamedLogger("jacorb.ssl.sessionlistener");
            ((SSLSocket)socket).addHandshakeCompletedListener(new SSLHandshakeListener(logger, listener));
        }
    }

    public static void processException(ORB orb, IIOPConnection iiop, Socket socket, IOException ex) {
        String localhost;
        SSLSessionListener listener = orb.getTransportManager().getSocketFactoryManager().getSSLListener();
        Logger logger = orb.getConfiguration().getNamedLogger("jacorb.ssl.sessionlistener");
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to resolve local IP address - using default");
            }
            localhost = "127.0.0.1";
        }
        if (ex instanceof SSLHandshakeException) {
            listener.handshakeException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
        } else if (ex instanceof SSLKeyException) {
            listener.keyException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
        } else if (ex instanceof SSLPeerUnverifiedException) {
            listener.peerUnverifiedException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
        } else if (ex instanceof SSLProtocolException) {
            listener.protocolException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
        } else if (ex instanceof SSLException) {
            listener.sslException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unknown exception type " + ex.getClass().getName() + " with exception ", ex);
        }
    }
}

