/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class SSLComponentInterceptor
extends LocalObject
implements IORInterceptor,
Configurable {
    private final ORB orb;
    private final Logger logger;
    private TaggedComponent tc = null;
    private short supported = 0;
    private short required = 0;

    public SSLComponentInterceptor(ORB orb) throws ConfigurationException {
        this.orb = orb;
        this.configure(orb.getConfiguration());
        this.logger = orb.getConfiguration().getNamedLogger(this.getClass().getName());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.supported = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.required = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
    }

    public String name() {
        return "SSLComponentCreator";
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info) {
        try {
            if (this.tc == null) {
                SSL ssl = new SSL(this.supported, this.required, (short)this.orb.getBasicAdapter().getSSLPort());
                ssl.target_supports = (short)(ssl.target_supports | 0x80);
                ssl.target_supports = (short)(ssl.target_supports | 0x20);
                CDROutputStream sslDataStream = new CDROutputStream(this.orb);
                sslDataStream.beginEncapsulatedArray();
                SSLHelper.write(sslDataStream, ssl);
                this.tc = new TaggedComponent(20, sslDataStream.getBufferCopy());
                sslDataStream.close();
                Object var3_4 = null;
            }
            info.add_ior_component_to_profile(this.tc, 0);
        }
        catch (Exception e2) {
            this.logger.error("unexpected exception", e2);
            throw new INTERNAL(e2.toString());
        }
    }
}

