/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class FixEcBusRefOnEcPortAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = FixEcBusRefOnEcPortAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String ECBUS_MO_TYPE = "EcBus";
    private static final int ECBUS_FRO_TYPE_ID = 117702672;
    private static final String ECPORT_MO_TYPE = "EcPort";
    private static final String ECPORT_ATT_ECBUSREF = "ecBusRef";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(ECPORT_MO_TYPE);
            TableData tableData2 = tableHandler.getTableData(ECBUS_MO_TYPE);
            if (tableData != null && tableData.getNumberOfRecords() != 0 && tableData2 != null && tableData2.getNumberOfRecords() != 0) {
                logger.traceGeneral(THIS_CLASS, "Found ecPortTable data with " + tableData.getNumberOfRecords() + " rows.");
                this.updateAllEcBusRefs(tableData, tableData2);
            } else {
                logger.traceGeneral(THIS_CLASS, "No ecPortTableData found.");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read EcPort tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private void updateAllEcBusRefs(TableData tableData, TableData tableData2) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updateAllEcBusRefs()");
        Object[] objectArray = tableData.getAttributeValues(ECPORT_ATT_ECBUSREF);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = TableDataUtil.getLdnFromMoRef((String)objectArray[i].toString());
            String string2 = TableDataUtil.getFroid((String)string, (TableData)tableData2);
            String string3 = TableDataUtil.createMoRefXmlString((String)ECPORT_ATT_ECBUSREF, (String)string, (String)Integer.toString(117702672), (String)string2);
            tableData.setAttributeValue(i, ECPORT_ATT_ECBUSREF, (Object)string3);
        }
        logger.traceReturn(THIS_CLASS, "updateAllEcBusRefs()");
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

