/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;
import se.ericsson.crbs.supsys.omf.aue.step1.util.CabinetParametersHelper;

public class SetCabinetParametersFromFileAction
extends AbstractConversionAction {
    private static final String CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    private static final String CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    private static final String CABINET_PARAMETERS_ATTRIBUTE_NAME = "cabinetParameters";
    private static final String CLIMATE_SYSTEM = "climateSystem";
    private static final String PRODUCT_DATA = "productData";
    private static final String PRODUCT_NAME = "productName";
    private static final String CLIMATE_REGULATION_SYSTEM = "climateRegulationSystem";
    private static final String CABINET = "Cabinet";
    private static final int PARAMETERS_ARRAY_LENGHT = 100;
    private static final Class THIS_CLASS = SetCabinetParametersFromFileAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        try {
            try {
                TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
                TableData tableData = tableHandler.getTableData(CABINET);
                if (tableData.isNotEmpty()) {
                    for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                        CabinetParametersHelper cabinetParametersHelper = new CabinetParametersHelper();
                        Map map = tableData.getRecordMap(i);
                        String string = null;
                        String string2 = null;
                        boolean bl = false;
                        boolean bl2 = false;
                        String string3 = (String)map.get(PRODUCT_DATA);
                        logger.traceGeneral(THIS_CLASS, "Struct: " + string3);
                        if (this.getProductNameFromCabinetPID(tableHandler, string3) != null) {
                            string = CabinetParametersHelper.getValidCabinetTypeFromProductName(this.getProductNameFromCabinetPID(tableHandler, string3));
                        }
                        if (map.containsKey(CLIMATE_REGULATION_SYSTEM)) {
                            string2 = map.get(CLIMATE_REGULATION_SYSTEM).toString();
                        }
                        logger.info(THIS_CLASS, "Cabinet[" + i + "] productName: " + string + ", climateRegulationSystem: " + string2);
                        String string4 = cabinetParametersHelper.getStandardParameters(aueContext, string, string2);
                        String string5 = cabinetParametersHelper.getExtendedParameters(aueContext, string, string2);
                        bl = string4 != null && !string4.trim().equals("");
                        boolean bl3 = bl2 = string5 != null && !string5.trim().equals("");
                        if (!bl && !bl2) {
                            cabinetParametersHelper = new CabinetParametersHelper();
                            string4 = cabinetParametersHelper.getStandardParameters(aueContext, string2);
                            string5 = cabinetParametersHelper.getExtendedParameters(aueContext, string2);
                        }
                        bl = string4 != null && !string4.trim().equals("");
                        boolean bl4 = bl2 = string5 != null && !string5.trim().equals("");
                        if (!bl && !bl2) {
                            logger.traceAbnormal(THIS_CLASS, "Unexpected contents in file. Expected to find cabinet standard or extended parameters in cabinet xml-file but they were not found. Cabinet parameters will not be updated");
                            continue;
                        }
                        if (bl && !bl2) {
                            string5 = string4;
                        } else if (!bl && bl2) {
                            string4 = string5;
                        }
                        String string6 = this.isStandardProfile(i, tableData) ? string4 : string5;
                        this.setCabinetParameters(i, string6, tableData);
                        String string7 = this.getCabinetMoLdn(i, tableData);
                        this.storeCabinetParametersProfileToAuePersistency(string4, string5, string7, tableHandler);
                    }
                }
            }
            catch (ParseException parseException) {
                throw new CrbsAueException("Failed to Parse XmlStruct", (Throwable)parseException);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Caught TableDataException in " + THIS_CLASS.getName(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private String getProductNameFromCabinetPID(TableHandler tableHandler, String string) throws ParseException {
        logger.traceEnter(THIS_CLASS, "getProductNameFromProductData()");
        FroStruct froStruct = new FroStruct(tableHandler);
        String string2 = null;
        froStruct.parse(string);
        XmlTag[] xmlTagArray = froStruct.getXmlTags();
        for (int i = 0; i < xmlTagArray.length; ++i) {
            if (!((NameTypeValue)xmlTagArray[i]).getName().toLowerCase().equals(PRODUCT_NAME.toLowerCase())) continue;
            string2 = ((NameTypeValue)xmlTagArray[i]).getValue();
        }
        logger.traceReturn(THIS_CLASS, "getProductNameFromProductData()");
        return string2;
    }

    private String getCabinetMoLdn(int n, TableData tableData) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getCabinetMoLdn()");
        Object[] objectArray = tableData.getAttributeValues("ldn");
        logger.traceReturn(THIS_CLASS, "getCabinetMoLdn()");
        return objectArray[n].toString();
    }

    private boolean isStandardProfile(int n, TableData tableData) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "isStandardProfile()");
        boolean bl = true;
        Object[] objectArray = tableData.getAttributeValues(CLIMATE_SYSTEM);
        int n2 = Integer.valueOf(objectArray[n].toString());
        if (n2 == 1) {
            bl = false;
        }
        logger.traceReturn(THIS_CLASS, "isStandardProfile()");
        return bl;
    }

    private void storeCabinetParametersProfileToAuePersistency(String string, String string2, String string3, TableHandler tableHandler) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "storeCabinetParametersProfileToAuePersistency()");
        if (string != null) {
            tableHandler.storeInAuePersistency(string3, CABINET_PARAMETERS_PROFILE_STANDARD, string);
        }
        if (string2 != null) {
            tableHandler.storeInAuePersistency(string3, CABINET_PARAMETERS_PROFILE_EXTENDED, string2);
        }
        logger.traceReturn(THIS_CLASS, "storeCabinetParametersProfileToAuePersistency()");
    }

    private void setCabinetParameters(int n, String string, TableData tableData) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "setCabinetParameters()");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = string;
        for (int i = stringTokenizer.countTokens(); i < 100; ++i) {
            string2 = string2 + ",0";
        }
        String string3 = TableDataUtil.createArrayXmlString((String)CABINET_PARAMETERS_ATTRIBUTE_NAME, (String)"S32", (String)string2, (String)",");
        tableData.setAttributeValue(n, CABINET_PARAMETERS_ATTRIBUTE_NAME, (Object)string3);
        logger.traceReturn(THIS_CLASS, "setCabinetParameters()");
    }

    private class ClimateSystemEnum {
        public static final int EXTENDED_VALUE = 1;

        private ClimateSystemEnum() {
        }
    }
}

