/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ComplexXmlHandler
extends DefaultHandler {
    public static final String ALREADY_COMPLEX = "attributeAlreadyComplex";
    private static final String MOREF = "moref";
    private static final String ARRAY = "array";
    private static final String STRUCT = "struct";
    private static final String VALUE = "value";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String ATTR = "attr";
    private static final String COMPLEX = "complex";
    private static final String STRCT = "strct";
    private static final String SEQ = "seq";
    private static final String DATA = "data";
    private String convertedXmlData = "";
    private StringBuffer dataBuffer = new StringBuffer();
    private StringBuffer typeBuffer = new StringBuffer();
    private int level = 0;
    private boolean newLevel = true;
    private final ArrayList elementList = new ArrayList();

    public ComplexXmlHandler(String xmlDataToConvert) throws SAXException, IOException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        parser.setContentHandler(this);
        InputSource inputSource = new InputSource(new StringReader(xmlDataToConvert));
        parser.parse(inputSource);
    }

    public String getEncodedXmlData() {
        return this.convertedXmlData;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        String attrType = attributes.getValue(TYPE);
        String attrValue = attributes.getValue(VALUE);
        String attrName = attributes.getValue(NAME);
        if (ATTR.equals(qName)) {
            this.handleAttr(attrName, attrType, attrValue);
        } else if (ARRAY.equals(qName)) {
            if (this.getElement(this.level) == null) {
                attrName = attrName == null ? SEQ : attrName;
                Element array = new Element(attrName, ARRAY);
                if (this.hasParent()) {
                    Element parent = this.getElement(this.level - 1);
                    array.setIsFirstSibling(parent.isFirstSibling());
                    if (this.elementIsArray(this.level - 1) && array.isFirstSibling()) {
                        this.typeBuffer.append("\n<seq name=\"" + parent.getName() + "\" type=\"" + SEQ + "\">");
                    } else if (this.elementIsStruct(this.level - 1) && this.newLevel && parent.getName() != STRUCT) {
                        this.typeBuffer.append("\n<strct name=\"" + parent.getName() + "\">");
                    }
                }
                this.elementList.add(array);
            }
        } else if (STRUCT.equals(qName) || MOREF.equals(qName)) {
            String string = attrName = attrName == null ? qName : attrName;
            if (this.getElement(this.level) == null) {
                this.elementList.add(new Element(attrName, qName));
                Element parent = this.getElement(this.level - 1);
                if (this.hasParent() && parent.isFirstSibling()) {
                    if (this.elementIsArray(this.level - 1)) {
                        this.typeBuffer.append("\n<seq name=\"" + parent.getName() + "\" type=\"" + (STRUCT.equals(qName) ? "strct\">" : "moref\"/>"));
                    } else {
                        if (this.elementIsStruct(this.level - 1) && !this.elementIsArray(this.level - 2) && this.newLevel) {
                            this.typeBuffer.append("\n<strct name=\"" + parent.getName() + "\">");
                        }
                        this.typeBuffer.append("\n<" + qName + " name=\"" + attrName + "\"/>");
                    }
                }
            }
        } else {
            if (COMPLEX.equals(qName)) {
                throw new SAXException(ALREADY_COMPLEX);
            }
            throw new SAXException("Unknown element type. Only attr, array, struct and moref allowed.");
        }
        ++this.level;
        this.newLevel = true;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        --this.level;
        this.newLevel = false;
        if (ARRAY.equals(qName)) {
            Element array = this.getElement(this.level);
            if ((this.elementIsStruct(this.level + 1) || this.elementIsArray(this.level + 1)) && array.isFirstSibling()) {
                this.typeBuffer.append("\n</seq>");
            } else if (array.getDataSize() < 1) {
                this.typeBuffer.append("\n<seq name=\"" + array.getName() + "\" type=\"\"/>");
            }
            if (this.hasParent()) {
                Element parent = this.getElement(this.level - 1);
                parent.addData(array.getData());
                array.setIsFirstSibling(false);
            } else {
                this.dataBuffer.append(array.getData());
            }
        } else if (STRUCT.equals(qName) || MOREF.equals(qName)) {
            Element element = this.getElement(this.level);
            if (this.hasParent()) {
                Element array = this.getElement(this.level - 1);
                array.addData(element.getData());
                element.setIsFirstSibling(false);
            } else {
                this.dataBuffer.append(element.getData());
                if (this.elementIsStruct(this.level) && element.isFirstSibling()) {
                    this.typeBuffer.append("\n</strct>");
                }
            }
        }
        if (!this.elementIsArray(this.level - 1)) {
            this.removeElementsAboveIndex(this.level);
        }
        if (this.level == 0) {
            String data = "";
            if (this.dataBuffer.length() > 0) {
                data = this.dataBuffer.substring(0, this.dataBuffer.length() - 1);
            }
            this.convertedXmlData = "<complex>" + this.typeBuffer.toString() + "\n" + "<" + DATA + ">" + data + "</" + DATA + ">\n" + "</" + COMPLEX + ">";
        }
    }

    private void handleAttr(String attrName, String attrType, String attrValue) {
        Element parent;
        attrName = attrName == null ? attrType : attrName;
        this.addData(attrValue);
        if (this.newLevel) {
            if (this.elementIsArray(this.level - 1)) {
                parent = this.getElement(this.level - 1);
                if (parent.isFirstSibling()) {
                    this.typeBuffer.append("\n<seq name=\"" + parent.getName() + "\" type=\"" + attrType + "\"/>");
                }
            } else {
                parent = this.getElement(this.level - 1);
                if (parent.isFirstSibling && this.level <= 1) {
                    if (this.elementIsStruct(this.level - 1)) {
                        this.typeBuffer.append("\n<strct name=\"" + parent.getName() + "\">");
                    } else {
                        this.typeBuffer.append("\n<moref name=\"" + parent.getName() + "\"/>");
                    }
                }
            }
        }
        if (this.elementIsStruct(this.level - 1) && (parent = this.getElement(this.level - 1)).isFirstSibling()) {
            this.typeBuffer.append("\n<attr name=\"" + attrName + "\" type=\"" + attrType + "\"/>");
        }
    }

    private void addData(String dataString) {
        String replacedComma = this.replaceAll(dataString, ",", "\\,");
        Element parent = this.getElement(this.level - 1);
        parent.addData(replacedComma + ",");
    }

    private boolean elementIsStruct(int index) {
        return this.elementIsType(STRUCT, index);
    }

    private boolean elementIsArray(int index) {
        return this.elementIsType(ARRAY, index);
    }

    private boolean elementIsType(String type, int index) {
        boolean isType = false;
        Element element = this.getElement(index);
        if (element != null && type.equals(element.getType())) {
            isType = true;
        }
        return isType;
    }

    private boolean hasParent() {
        return this.getElement(this.level - 1) != null;
    }

    private Element getElement(int index) {
        Element element = null;
        if (this.elementList.size() - 1 >= index && index >= 0) {
            element = (Element)this.elementList.get(index);
        }
        return element;
    }

    private void removeElementsAboveIndex(int index) {
        if (this.elementList.size() - 1 >= index && index >= 0) {
            while (this.elementList.size() - 1 >= index) {
                this.elementList.remove(this.elementList.size() - 1);
            }
        }
    }

    private String replaceAll(String inputString, String findWhat, String replaceTo) {
        int idx;
        int start = 0;
        StringBuffer sb = new StringBuffer();
        do {
            if ((idx = inputString.indexOf(findWhat, start)) == -1) continue;
            sb.append(inputString.substring(start, idx));
            sb.append(replaceTo);
            start = idx + findWhat.length();
        } while (idx != -1);
        sb.append(inputString.substring(start, inputString.length()));
        String ret = sb.toString();
        return ret;
    }

    private class Element {
        private final String name;
        private final String type;
        private final ArrayList data;
        private boolean isFirstSibling = true;

        public Element(String elementName, String elementType) {
            this.name = elementName;
            this.type = elementType;
            this.data = new ArrayList();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setIsFirstSibling(boolean isFirst) {
            this.isFirstSibling = isFirst;
        }

        public boolean isFirstSibling() {
            return this.isFirstSibling;
        }

        public void addData(String dataString) {
            this.data.add(this.replaceString(dataString));
        }

        public String getData() {
            String dataString = "";
            if (this.type == ComplexXmlHandler.ARRAY) {
                dataString = this.data.size() + ",";
            }
            for (int i = 0; i < this.data.size(); ++i) {
                dataString = dataString + this.data.get(i);
            }
            this.data.clear();
            return dataString;
        }

        public int getDataSize() {
            return this.data.size();
        }

        private String replaceString(String inString) {
            String outString = inString;
            outString = ComplexXmlHandler.this.replaceAll(outString, "<", "&lt;");
            outString = ComplexXmlHandler.this.replaceAll(outString, ">", "&gt;");
            outString = ComplexXmlHandler.this.replaceAll(outString, "\"", "&quot;");
            return outString;
        }
    }
}

