/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import com.polyhedra.sql.SQLException;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;

public class ChangeFroTypeIdAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$ChangeFroTypeIdAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$ChangeFroTypeIdAction = ChangeFroTypeIdAction.class$("se.ericsson.crbs.omf.aue.step1.actions.ChangeFroTypeIdAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$ChangeFroTypeIdAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$ChangeFroTypeIdAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String newFroTypeIdStr = this.getAndCheckParamMapString("newFroTypeId", this.paramMap, "The new FRO type id is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(froTypeName);
            Integer newFrotypeId = Integer.valueOf(newFroTypeIdStr);
            if (tableData.isNotEmpty()) {
                Integer oldFrotypeId = tableData.getFroTypeId();
                FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
                FroVersionsData[] froVersionsDatas = froVersionsTable.getDatas();
                for (int i = 0; i < froVersionsDatas.length; ++i) {
                    this.checkAndUpdateReferencingMoRefs(tableHandler, froVersionsDatas[i], oldFrotypeId, newFrotypeId);
                }
            }
            if (tableData.getFroTypeId() != -1) {
                tableData.setFroTypeId(newFrotypeId);
            }
        }
        catch (Exception e) {
            logger.traceGeneral(THIS_CLASS, AueUtil.convertToString(e));
            String errorMsg = "Failed to change FRO type id for: " + AueUtil.doubleQuote(froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            throw new CrbsAueException(AueUtil.appendReason(errorMsg, e), e);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void checkAndUpdateReferencingMoRefs(TableHandler tableHandler, FroVersionsData froVersionsData, Integer oldFroTypeId, Integer newFroTypeId) throws TableDataException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, CrbsAueException, ParseException {
        logger.traceEnter(THIS_CLASS, "checkAndUpdateReferencingMoRefs()");
        boolean tableDataWasUpdatedFromStart = false;
        TableData tableData = tableHandler.getTableData(froVersionsData.froTypeName);
        if (tableData.isNotEmpty() && froVersionsData.froType == tableData.getFroTypeId()) {
            tableDataWasUpdatedFromStart = tableData.isTableDataUpdated();
            tableData.setTableDataUpdated(false);
            String[] referencingAttributes = tableData.getReferencingAttributes();
            for (int i = 0; i < referencingAttributes.length; ++i) {
                this.checkAndUpdateFroDataTable(tableHandler, tableData, referencingAttributes[i], oldFroTypeId, newFroTypeId);
            }
            if (!tableData.isTableDataUpdated()) {
                logger.traceGeneral(THIS_CLASS, "No referencing attribute contained, " + AueUtil.doubleQuote(oldFroTypeId.toString()) + ", in " + AueUtil.doubleQuote(froVersionsData.froTypeName));
                tableData.setTableDataUpdated(tableDataWasUpdatedFromStart);
            }
            tableHandler.checkAndDropIfNotUpdated(tableData);
        }
        logger.traceReturn(THIS_CLASS, "checkAndUpdateReferencingMoRefs()");
    }

    private boolean checkAndUpdateFroDataTable(TableHandler tableHandler, TableData tableData, String attributeName, Integer oldFroTypeId, Integer newFroTypeId) throws CrbsAueException, ParseException, TableDataException {
        logger.traceGeneral(THIS_CLASS, "Looking for attribute: \"" + attributeName + "\"");
        boolean updated = false;
        String momType = tableData.getMomType(attributeName);
        String froTypeName = tableData.getFroTypeName();
        Object[] columnDatas = tableData.getAttributeValues(attributeName);
        if (momType.equalsIgnoreCase("moref")) {
            updated = this.updateMoRef(tableHandler, froTypeName, attributeName, oldFroTypeId, newFroTypeId, columnDatas);
        } else if (momType.equalsIgnoreCase("struct")) {
            updated = this.updateStruct(tableHandler, froTypeName, attributeName, oldFroTypeId, newFroTypeId, columnDatas);
        } else if (momType.equalsIgnoreCase("array")) {
            updated = this.updateArray(tableHandler, froTypeName, attributeName, oldFroTypeId, newFroTypeId, columnDatas);
        }
        if (!updated) {
            logger.traceGeneral(THIS_CLASS, "No referencing attributes (MORef, struct or array) contained the FRO type id, " + AueUtil.doubleQuote(oldFroTypeId.toString()) + ", in " + AueUtil.doubleQuote(tableData.getFroTypeName()));
        }
        return updated;
    }

    private boolean updateMoRef(TableHandler tableHandler, String froTypeName, String attributeName, Integer oldFroTypeId, Integer newFroTypeId, Object[] attrColumnDatas) throws ParseException, TableDataException {
        boolean updated = false;
        for (int i = 0; i < attrColumnDatas.length; ++i) {
            String moRefXmlString = (String)attrColumnDatas[i];
            FroMoRef froMoRef = new FroMoRef(tableHandler);
            froMoRef.parse(moRefXmlString);
            boolean thisIsUpdated = this.updateXmlTags(attributeName, froTypeName, froMoRef.getXmlTags(), oldFroTypeId, newFroTypeId);
            if (!thisIsUpdated) continue;
            updated = true;
            TableData localTableData = tableHandler.getTableData(froTypeName);
            localTableData.setAttributeValue(i, attributeName, froMoRef.toXmlString());
        }
        return updated;
    }

    private boolean updateStruct(TableHandler tableHandler, String froTypeName, String attributeName, Integer oldFroTypeId, Integer newFroTypeId, Object[] structColumnDatas) throws ParseException, TableDataException {
        boolean updated = false;
        for (int i = 0; i < structColumnDatas.length; ++i) {
            String structXmlString = (String)structColumnDatas[i];
            FroStruct froStruct = new FroStruct(tableHandler);
            froStruct.parse(structXmlString);
            boolean thisIsUpdated = this.updateXmlTags(attributeName, froTypeName, froStruct.getXmlTags(), oldFroTypeId, newFroTypeId);
            if (!thisIsUpdated) continue;
            updated = true;
            TableData localTableData = tableHandler.getTableData(froTypeName);
            localTableData.setAttributeValue(i, attributeName, froStruct.toXmlString());
        }
        return updated;
    }

    private boolean updateArray(TableHandler tableHandler, String froTypeName, String attributeName, Integer oldFroTypeId, Integer newFroTypeId, Object[] arrayColumnDatas) throws ParseException, TableDataException {
        boolean updated = false;
        for (int i = 0; i < arrayColumnDatas.length; ++i) {
            String arrayXmlString = (String)arrayColumnDatas[i];
            FroArray froArray = new FroArray(tableHandler);
            froArray.parse(arrayXmlString);
            boolean thisIsUpdated = this.updateXmlTags(attributeName, froTypeName, froArray.getXmlTags(), oldFroTypeId, newFroTypeId);
            if (!thisIsUpdated) continue;
            updated = true;
            TableData localTableData = tableHandler.getTableData(froTypeName);
            localTableData.setAttributeValue(i, attributeName, froArray.toXmlString());
        }
        return updated;
    }

    private boolean updateXmlTags(String attributeName, String froTypeName, XmlTag[] xmlTags, Integer oldFroTypeId, Integer newFroTypeId) {
        boolean updated = false;
        block6: for (int i = 0; i < xmlTags.length; ++i) {
            int tagType = xmlTags[i].getTagType();
            switch (tagType) {
                case 1: {
                    updated |= this.updateNameTypeValue(attributeName, froTypeName, oldFroTypeId, newFroTypeId, (NameTypeValue)xmlTags[i]);
                    continue block6;
                }
                case 3: {
                    updated |= this.updateXmlTags(attributeName, froTypeName, ((FroMoRef)xmlTags[i]).getXmlTags(), oldFroTypeId, newFroTypeId);
                    continue block6;
                }
                case 4: {
                    updated |= this.updateXmlTags(attributeName, froTypeName, ((FroStruct)xmlTags[i]).getXmlTags(), oldFroTypeId, newFroTypeId);
                    continue block6;
                }
                case 5: {
                    updated |= this.updateXmlTags(attributeName, froTypeName, ((FroArray)xmlTags[i]).getXmlTags(), oldFroTypeId, newFroTypeId);
                    continue block6;
                }
            }
        }
        return updated;
    }

    private boolean updateNameTypeValue(String attributeName, String froTypeName, Integer oldFroTypeId, Integer newFroTypeId, NameTypeValue nameTypeValue) {
        boolean updated = false;
        String type = nameTypeValue.getType();
        if (type.equalsIgnoreCase("S32")) {
            String name = nameTypeValue.getName();
            String value = nameTypeValue.getValue();
            if (name.equalsIgnoreCase("frotype") && value.equals(oldFroTypeId.toString())) {
                nameTypeValue.setValue(newFroTypeId.toString());
                updated = true;
                logger.traceGeneral(THIS_CLASS, "Attribute, " + AueUtil.doubleQuote(attributeName) + ", updated referencing FRO type id from, " + AueUtil.doubleQuote(oldFroTypeId.toString()) + ", to " + AueUtil.doubleQuote(newFroTypeId.toString()) + ", in " + AueUtil.doubleQuote(froTypeName));
            }
        }
        return updated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

