/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.text.MessageFormat;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CheckAttributeValueRangeAction
extends AbstractConversionAction {
    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        TableData tableData;
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String attr = this.getAndCheckParamMapString("name", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String rangeMin = this.getAndCheckParamMapString("min", this.paramMap, "No attribute to copy to is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String rangeMax = this.getAndCheckParamMapString("max", this.paramMap, "No attribute to copy to is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        int min = Integer.valueOf(rangeMin);
        int max = Integer.valueOf(rangeMax);
        try {
            tableData = tableHandler.getTableData(froTypeName);
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Can not retrieve a TableData for " + froTypeName, e);
        }
        if (tableData.isNotEmpty() && !this.checkAttributeValueRange(attr, min, max, context, tableData)) {
            String errorMsg = "Attribute " + AueUtil.doubleQuote(attr) + " in " + AueUtil.doubleQuote(froTypeName) + " is not within valid range:[" + rangeMin + ".." + rangeMax + "]";
            throw new CrbsAueException(errorMsg);
        }
    }

    private boolean checkAttributeValueRange(String attributeName, int min, int max, AueContext context, TableData tableData) throws CrbsAueException {
        try {
            String[] mess = new String[1];
            boolean check = true;
            Object[] ldnColumnData = tableData.getAttributeValues("ldn");
            Object[] attributeColumnData = tableData.getAttributeValues(attributeName);
            Integer attrData = null;
            for (int moInstanceIndex = 0; moInstanceIndex < ldnColumnData.length; ++moInstanceIndex) {
                try {
                    attrData = Integer.valueOf(attributeColumnData[moInstanceIndex].toString());
                    int attrValue = attrData;
                    if (attrValue >= min && attrValue <= max) continue;
                    Object[] messArgs = new Object[]{ldnColumnData[moInstanceIndex], attributeName, attrData, new Integer(min), new Integer(max)};
                    MessageFormat form = new MessageFormat("Mo \"{0}\" attribute \"{1}\" value {2} is out of valid range [{3}..{4}]. The attribute has to be changed before executing upgrade");
                    mess[0] = form.format(messArgs);
                    check = false;
                    ((CollectorContext)context).getCurrentTrigger().reportProgress(mess);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new CrbsAueException("Cannot interpret value as integer", e);
                }
            }
            return check;
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Cannot interpret value as integer", tde);
        }
    }
}

