/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.io.IOException;
import org.xml.sax.SAXException;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.ComplexXmlHandler;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ConvertAttributesToComplexXmlEncodingAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$ConvertAttributesToComplexXmlEncodingAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$ConvertAttributesToComplexXmlEncodingAction = ConvertAttributesToComplexXmlEncodingAction.class$("se.ericsson.crbs.omf.aue.step1.actions.ConvertAttributesToComplexXmlEncodingAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$ConvertAttributesToComplexXmlEncodingAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$ConvertAttributesToComplexXmlEncodingAction;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData != null && tableData.isNotEmpty()) {
                this.convertAllAttributes(tableData);
            }
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Failed to read table data. " + tde.getMessage(), tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void convertAllAttributes(TableData tableData) throws CrbsAueException {
        String[] attributeNamesArray = tableData.getAttributeNames();
        if (attributeNamesArray != null) {
            for (int attr = 0; attr < attributeNamesArray.length; ++attr) {
                Object[] attrValues = this.getAttributeValues(tableData, attributeNamesArray[attr]);
                if (attrValues == null) continue;
                this.convertAttribute(attrValues, tableData, attributeNamesArray[attr]);
            }
        }
    }

    private Object[] getAttributeValues(TableData tableData, String attributeName) throws CrbsAueException {
        Object[] attributeValues = null;
        try {
            String attributeType = tableData.getMomType(attributeName);
            if ("struct".equalsIgnoreCase(attributeType) || "moref".equalsIgnoreCase(attributeType) || "array".equalsIgnoreCase(attributeType)) {
                attributeValues = tableData.getAttributeValues(attributeName);
            }
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Failed to read attribute " + attributeName + " from table data." + tde.getMessage(), tde);
        }
        return attributeValues;
    }

    private void convertAttribute(Object[] attrValues, TableData tableData, String attributeName) throws CrbsAueException {
        for (int instance = 0; instance < attrValues.length; ++instance) {
            if (attrValues[instance] instanceof String) {
                String attrValue = (String)attrValues[instance];
                try {
                    ComplexXmlHandler xmlHandler = new ComplexXmlHandler(attrValue);
                    String convertedValue = xmlHandler.getEncodedXmlData();
                    tableData.setAttributeValue(instance, attributeName, convertedValue);
                    continue;
                }
                catch (IOException ioe) {
                    throw new CrbsAueException("Failed to convert attibute " + attributeName + " to complex xml encoding.", ioe);
                }
                catch (SAXException saxe) {
                    if ("attributeAlreadyComplex".equals(saxe.getMessage())) {
                        logger.traceDebug(THIS_CLASS, "The attribute is already complex format. No conversion done.");
                        continue;
                    }
                    throw new CrbsAueException("Failed convert attibute " + attributeName + " to complex xml encoding.", saxe);
                }
                catch (TableDataException tde) {
                    throw new CrbsAueException("Failed to set attribute " + attributeName + " on Mo instance " + instance + ".", tde);
                }
            }
            logger.traceAbnormal(THIS_CLASS, "Attribute " + attributeName + " is not a String. No conversion performed.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

