/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.XmlArrayHelper;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class TruncateArrayAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$TruncateArrayAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$TruncateArrayAction = TruncateArrayAction.class$("se.ericsson.crbs.omf.aue.step1.actions.TruncateArrayAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$TruncateArrayAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$TruncateArrayAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type, copy to, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String arrayAttrName = this.getAndCheckParamMapString("name", this.paramMap, "The FRO type, to copy from, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String newlength = this.getAndCheckParamMapString("length", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        int length = Integer.parseInt(newlength);
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        boolean tableExistFromStart = tableHandler.tableExist(froTypeName);
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData.isNotEmpty()) {
                this.performTruncate(arrayAttrName, tableData, length);
                tableHandler.checkAndDropIfNotUpdated(tableExistFromStart, tableData);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not truncate array attribute, " + AueUtil.doubleQuote(arrayAttrName) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", to, new length " + AueUtil.doubleQuote(newlength);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
            throw new CrbsAueException(errorMsg, tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    protected void performTruncate(String arrayAttrName, TableData tableData, int length) throws TableDataException, CrbsAueException {
        Object[] ldnColumnData = tableData.getAttributeValues("ldn");
        Object[] arrayAttrColumnData = tableData.getAttributeValues(arrayAttrName);
        for (int moInstanceIndex = 0; moInstanceIndex < ldnColumnData.length; ++moInstanceIndex) {
            Object arrayData = arrayAttrColumnData[moInstanceIndex];
            String newSequenceData = this.truncateSequence(arrayData.toString(), length);
            tableData.setAttributeValue(moInstanceIndex, arrayAttrName, newSequenceData);
        }
    }

    protected String truncateSequence(String array, int length) {
        XmlArrayHelper xml2list = new XmlArrayHelper(array);
        List valueTypeList = xml2list.getValueTypeList();
        StringBuffer seq = new StringBuffer(70);
        seq.append("<array name=\"" + xml2list.getArrayName() + "\">");
        int noOfElements = 0;
        for (int index = 0; index < valueTypeList.size(); ++index) {
            Object o = valueTypeList.get(index);
            Map valueTypeMap = (Map)o;
            Iterator iterator = valueTypeMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object type = iterator.next();
                Object value = valueTypeMap.get(type);
                seq.append("<attr type=\"" + type + "\" value=\"" + value + "\"/>");
                ++noOfElements;
            }
            if (noOfElements >= length) break;
        }
        seq.append("</array>");
        return seq.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

