/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.DateTimeHelper;
import se.ericsson.crbs.omf.aue.common.RbsAueMetaData;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesTableImpl;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTableImpl;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataImpl;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class TableHandlerImpl
implements TableHandler {
    private static final Class THIS_CLASS = TableHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String RESET_TABLE_SUFFIX = "_reset";
    private final DbWrapper dbWrapper;
    private final FroAttributesTable froAttributesTable;
    private final FroVersionsTable froVersionsTable;
    private final MomInfo fromVersion;
    private final MomInfo toVersion;
    private final RbsAueMetaData rbsAueMetaData;
    private final Map tableDatas;

    public TableHandlerImpl(RbsAueMetaData rbsAueMetaData, MomInfo fromVersion, MomInfo toVersion, String froVersionsTableName, String froAttributesTableName) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "TableHandlerImpl()");
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.rbsAueMetaData = rbsAueMetaData;
        this.tableDatas = new HashMap();
        this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        this.froAttributesTable = new FroAttributesTableImpl(froAttributesTableName, this.dbWrapper);
        this.froVersionsTable = new FroVersionsTableImpl(froVersionsTableName, this.dbWrapper);
        logger.traceReturn(THIS_CLASS, "TableHandlerImpl()");
    }

    public RbsAueMetaData getRbsAueMetaData() {
        return this.rbsAueMetaData;
    }

    public MomInfo getFromVersion() {
        return this.fromVersion;
    }

    public MomInfo getToVersion() {
        return this.toVersion;
    }

    public FroAttributesTable getFroAttributesTable() {
        return this.froAttributesTable;
    }

    public FroVersionsTable getFroVersionsTable() {
        return this.froVersionsTable;
    }

    public boolean isExisting(Integer froTypeId) {
        FroVersionsData[] froVersionsDatas = this.froVersionsTable.getDatas();
        boolean result = false;
        for (int i = 0; i < froVersionsDatas.length; ++i) {
            if (froVersionsDatas[i].froType != froTypeId) continue;
            result = true;
            break;
        }
        return result;
    }

    public TableData[] getAllTableDatas() {
        TableData[] tableDataAsArray = new TableData[this.tableDatas.size()];
        this.tableDatas.values().toArray(tableDataAsArray);
        return tableDataAsArray;
    }

    public void clearTableDatas() {
        this.tableDatas.clear();
    }

    public TableData getTableData(String froTypeName) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "getTableData(" + froTypeName + ")");
        TableDataImpl tableData = (TableDataImpl)this.tableDatas.get(froTypeName);
        if (tableData == null) {
            tableData = new TableDataImpl(this.froAttributesTable, this.froVersionsTable, froTypeName);
            tableData.readTableData();
            this.tableDatas.put(froTypeName, tableData);
            logger.traceGeneral(this.getClass(), "No data for, " + AueUtil.doubleQuote(froTypeName) + ", did not exist. Table data read a new");
        }
        logger.traceReturn(THIS_CLASS, "getTableData(tabelData=\"" + tableData + "\"");
        return tableData;
    }

    public TableData createNewEmptyTableData(Integer froTypeId, String froTypeName) throws TableDataException {
        TableDataImpl tableData = new TableDataImpl(this.froAttributesTable, this.froVersionsTable, this.getRbsAueMetaData().getFroDataPrefix(), froTypeName, froTypeId);
        this.froVersionsTable.insertIntoTable(froTypeId, froTypeName, tableData.getTableName());
        this.tableDatas.put(froTypeName, tableData);
        return tableData;
    }

    public void checkAndDropIfNotUpdated(TableData tableData) {
        this.checkAndDropIfNotUpdated(false, tableData);
    }

    public void checkAndDropIfNotUpdated(boolean keep, TableData tableData) {
        if (!keep && !tableData.isTableDataUpdated()) {
            this.tableDatas.remove(tableData.getFroTypeName());
        }
    }

    public void storeAllTables() throws TableDataException {
        logger.traceEnter(THIS_CLASS, "storeAllTables()");
        logger.info(THIS_CLASS, "Memory usage before database update: " + AueUtil.getUsedMemory() + " bytes of memory");
        TableData currentTable = null;
        String currentTableName = null;
        String newFroDataTableName = null;
        try {
            this.dbWrapper.openConnection();
            TableData[] tableDatasToBeStored = this.getAllTableDatas();
            for (int i = 0; i < tableDatasToBeStored.length; ++i) {
                currentTable = tableDatasToBeStored[i];
                if (currentTable.isTableDataUpdated()) {
                    String currentFroTypeName = currentTable.getFroTypeName();
                    String currentFroDataTableName = currentTable.getTableName();
                    if (currentFroDataTableName != null && currentFroDataTableName.length() > 0) {
                        int index = currentFroDataTableName.indexOf(currentFroTypeName) + currentFroTypeName.length();
                        currentTableName = currentTable.getOriginalTableName();
                        newFroDataTableName = currentFroDataTableName.substring(0, index) + "_" + this.toVersion.toString();
                        if (newFroDataTableName.equalsIgnoreCase(currentTableName)) {
                            newFroDataTableName = newFroDataTableName + RESET_TABLE_SUFFIX;
                        }
                        currentTable.setNewTableName(newFroDataTableName);
                        try {
                            this.froVersionsTable.updateTableName(currentTable.getFroTypeId(), newFroDataTableName);
                        }
                        catch (TableDataException ho84064) {
                            // empty catch block
                        }
                    }
                    if (currentTable.isNotEmpty()) {
                        currentTable.storeTableData();
                    } else {
                        try {
                            this.froAttributesTable.deleteFromTable(currentTable.getFroTypeId());
                        }
                        catch (TableDataException e) {
                            // empty catch block
                        }
                    }
                    this.createCleanUpTableIfNonExisting();
                    this.insertIntoCleanUpTable(this.dbWrapper, currentTable.getOriginalTableName());
                    continue;
                }
                logger.traceGeneral(THIS_CLASS, "Table data for, \"" + tableDatasToBeStored[i].getFroTypeName() + "\", has not been updated and will therefore not be stored to database.");
            }
            this.tableDatas.clear();
            String froVersionsTableName = this.rbsAueMetaData.getFroVersionsTableName() + "_new";
            this.froVersionsTable.storePersistently(froVersionsTableName);
            String froAttributesTableName = this.rbsAueMetaData.getFroAttributesTableName() + "_new";
            this.froAttributesTable.storePersistently(froAttributesTableName);
        }
        catch (SQLException sqle) {
            String errorMsg = "SQL Exception received when creating or update cleanup table, original table name = " + currentTableName + " new table name = " + newFroDataTableName + ", ErrorCode = " + sqle.getErrorCode();
            TableDataException tde = new TableDataException(AueUtil.appendReason(errorMsg, sqle), sqle);
            tde.setStackTrace(sqle.getStackTrace());
            throw tde;
        }
        logger.traceReturn(THIS_CLASS, "storeAllTables()");
    }

    public final void updateDataTableName(String oldFroTypeName, String newFroTypeName, TableData tableData) throws TableDataException {
        this.tableDatas.remove(oldFroTypeName);
        tableData.changeFroTypeName(oldFroTypeName, newFroTypeName);
        this.tableDatas.put(newFroTypeName, tableData);
        logger.traceGeneral(this.getClass(), "Table name changed from, " + AueUtil.doubleQuote(tableData.getOriginalTableName()) + ", to, " + AueUtil.doubleQuote(tableData.getTableName()) + ", in " + AueUtil.doubleQuote(oldFroTypeName));
    }

    public boolean tableExist(String froTypeName) {
        TableData tableData = (TableData)this.tableDatas.get(froTypeName);
        return tableData != null;
    }

    public void storeInAuePersistency(String ldn, String attributeName, String attributeValue) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "storeInAuePersistency()");
        String name = ldn + attributeName;
        try {
            this.dbWrapper.openConnection();
            Sql.Select nameExists = new Sql.Select(this.rbsAueMetaData.getAuePersistencyTableName(), new Sql.Select.ColumnValue("name", name));
            ResultSet existsRs = this.dbWrapper.executeQuery(nameExists);
            Sql.Modification modification = null;
            modification = existsRs.next() ? new Sql.UpdateRow(this.rbsAueMetaData.getAuePersistencyTableName(), new Sql.UpdateRow.ColumnValue[]{new Sql.UpdateRow.ColumnValue("value", attributeValue)}, new Sql.UpdateRow.ColumnValue("name", name)) : new Sql.InsertRow(this.rbsAueMetaData.getAuePersistencyTableName(), new Sql.InsertRow.ColumnValue[]{new Sql.InsertRow.ColumnValue("name", name), new Sql.InsertRow.ColumnValue("value", attributeValue)});
            this.dbWrapper.executeUpdate(modification);
        }
        catch (Exception e) {
            String errorMsg = "Failed to store, LDN: " + AueUtil.doubleQuote(ldn) + ", Attr: " + AueUtil.doubleQuote(attributeName) + ", Value: " + AueUtil.doubleQuote(attributeValue) + " in AUE persistency table: " + AueUtil.doubleQuote(this.rbsAueMetaData.getAuePersistencyTableName());
            logger.traceAbnormal(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            throw new TableDataException(AueUtil.appendReason(errorMsg, e), e);
        }
        logger.traceReturn(THIS_CLASS, "storeInAuePersistency()");
    }

    public String retrieveFromAuePersistency(String ldn, String attributeName) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "retrieveFromAuePersistency()");
        String value = "";
        ResultSet resultSet = null;
        String name = ldn + attributeName;
        try {
            this.dbWrapper.openConnection();
            resultSet = this.dbWrapper.executeQuery("SELECT value FROM " + this.rbsAueMetaData.getAuePersistencyTableName() + " WHERE name = " + AueUtil.quote(name));
            if (resultSet.next()) {
                value = resultSet.getString(1);
            }
        }
        catch (Exception e) {
            throw new CrbsAueException(e.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sqle) {
                    throw new CrbsAueException(sqle.getMessage());
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "retrieveFromAuePersistency()");
        return value;
    }

    public void storePerformedUpgradeSequence(long startTime, long finishedTime, int memoryAtStart, int memoryAtFinish, CollectorContext collectorContext) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "storePerformedUpgradeSequence()");
        String aueName = this.rbsAueMetaData.getAueName();
        String fromVersionStr = this.fromVersion.toString();
        String toVersionStr = this.toVersion.toString();
        String timeStamp = DateTimeHelper.dateToString(startTime, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        int timeConsumption = (int)((finishedTime - startTime) / 1000L);
        int memoryConsumption = memoryAtFinish - memoryAtStart;
        try {
            AueUtil.FromAndToUpHolder fromAndToUpHolder = AueUtil.getFromAndToUp(collectorContext);
            AueUtil.storePerformedUpgradeSequence(true, aueName, fromVersionStr, fromAndToUpHolder.fromUp, toVersionStr, fromAndToUpHolder.toUp, timeStamp, timeConsumption, memoryConsumption);
            this.storeInAuePersistency("performedUpgrades", "fromUp", fromAndToUpHolder.fromUp);
            this.storeInAuePersistency("performedUpgrades", "toUp", fromAndToUpHolder.toUp);
        }
        catch (Exception e) {
            String errorMsg = "Failed to store upgrade information for AUE, \"" + aueName + "\"";
            throw new TableDataException(AueUtil.appendReason(errorMsg, e), e);
        }
        logger.traceReturn(THIS_CLASS, "storePerformedUpgradeSequence()");
    }

    public String getToVersionFromPreviousUpgrade(String aueName) {
        return AueUtil.getToVersionFromPreviousUpgrade(aueName);
    }

    public static void replaceTable(String replacedTableName, String replacingTableName, DbWrapper dbWrapper) throws TableDataException {
        try {
            if (!dbWrapper.doTableExist(replacedTableName)) {
                logger.info(THIS_CLASS, "The table that is to be replaced does not exist: " + replacedTableName);
            } else {
                Sql.DropTable dropReplacedTable = new Sql.DropTable(replacedTableName);
                dbWrapper.executeUpdate(dropReplacedTable);
                Sql.RenameTable renameTable = new Sql.RenameTable(replacingTableName, replacedTableName);
                dbWrapper.executeUpdate(renameTable);
            }
        }
        catch (SQLException sqle) {
            String errorMsg = "Failed to rename table " + AueUtil.doubleQuote(replacingTableName) + " to " + AueUtil.doubleQuote(replacedTableName);
            TableDataException tde = new TableDataException(AueUtil.appendReason(errorMsg, sqle), sqle);
            tde.setStackTrace(sqle.getStackTrace());
            throw tde;
        }
    }

    private void createCleanUpTableIfNonExisting() throws SQLException {
        block3: {
            logger.traceEnter(THIS_CLASS, "createCleanUpTableIfNonExisting()");
            if (!this.dbWrapper.doTableExist("cleanup_table_for_rbs_aue")) {
                try {
                    Sql.CreateTable createCleanUpTable = new Sql.CreateTable("cleanup_table_for_rbs_aue", new Sql.CreateTable.ColumnSpec[]{new Sql.CreateTable.ColumnSpec("tables_to_be_removed", Sql.MomDataType.MOM_STRING, 0, null, true)});
                    logger.traceDebug(THIS_CLASS, "createCleanUpTableIfNonExisting: " + createCleanUpTable.toString());
                    this.dbWrapper.executeUpdate(createCleanUpTable);
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 2) break block3;
                    String msg = "createCleanUpTableIfNonExisting: Unable to create: " + AueUtil.doubleQuote("cleanup_table_for_rbs_aue");
                    logger.traceAbnormal(THIS_CLASS, AueUtil.appendReason(msg, sqle));
                    throw sqle;
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createCleanUpTableIfNonExisting()");
    }

    private void insertIntoCleanUpTable(DbWrapper inputDbWrapper, String name) throws SQLException {
        logger.traceEnter(THIS_CLASS, "insertIntoCleanUpTable(" + name + ")");
        Sql.InsertRow insertIntoCleanup = new Sql.InsertRow("cleanup_table_for_rbs_aue", new Sql.InsertRow.ColumnValue[]{new Sql.InsertRow.ColumnValue("tables_to_be_removed", name)});
        logger.traceDebug(THIS_CLASS, "updateCleanUpTable: " + insertIntoCleanup);
        try {
            inputDbWrapper.executeUpdate(insertIntoCleanup);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 368) {
                String msg = "updateCleanUpTable: Unable to add table name: " + name + " into " + AueUtil.doubleQuote("cleanup_table_for_rbs_aue");
                logger.traceAbnormal(THIS_CLASS, AueUtil.appendReason(msg, e));
            }
            throw e;
        }
        logger.traceReturn(THIS_CLASS, "insertIntoCleanUpTable(" + name + ")");
    }
}

