/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroXmlHelper;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;

abstract class AbstractFroXmlHelperImpl
extends DefaultHandler
implements FroXmlHelper {
    protected final Class thisClass;
    protected final AbstractLogger logger;
    protected static final Integer BOOLEAN_FALSE = new Integer(0);
    protected static final Integer BOOLEAN_TRUE = new Integer(1);
    protected static final String STRUCT = "struct";
    protected static final String ARRAY = "array";
    protected final List xmlTagsList = new ArrayList();
    protected String name = "";

    public AbstractFroXmlHelperImpl(Class extendingClass) {
        this.thisClass = extendingClass;
        this.logger = LoggingService.getLogger(this.thisClass.getName());
    }

    public String getName() {
        return this.name;
    }

    public abstract String getXmlTagName();

    public abstract int getTagType();

    public abstract void parse(String var1) throws ParseException;

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public final String[] toXmlStrings() {
        ArrayList<String> xmlStringsList = new ArrayList<String>();
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<").append(this.getXmlTagName());
        if (this.name != null && !"".equals(this.name)) {
            xmlString.append(" ").append("name").append("=").append(AueUtil.doubleQuote(this.name));
        }
        xmlString.append(">");
        xmlStringsList.add(xmlString.toString());
        block7: for (int i = 0; i < this.xmlTagsList.size(); ++i) {
            XmlTag xmlTag = (XmlTag)this.xmlTagsList.get(i);
            int tagType = xmlTag.getTagType();
            switch (tagType) {
                case 2: {
                    TypeValue typeValue = (TypeValue)xmlTag;
                    this.addTypeValueXmls(xmlStringsList, typeValue);
                    continue block7;
                }
                case 1: {
                    NameTypeValue nameTypeValue = (NameTypeValue)xmlTag;
                    this.addNameTypeValueXmls(xmlStringsList, nameTypeValue);
                    continue block7;
                }
                case 4: {
                    FroStruct froStruct = (FroStruct)xmlTag;
                    this.addFroStructXmls(xmlStringsList, froStruct);
                    continue block7;
                }
                case 5: {
                    FroArray froArray = (FroArray)xmlTag;
                    this.addFroArrayXmls(xmlStringsList, froArray);
                    continue block7;
                }
                case 3: {
                    FroMoRef froMoref = (FroMoRef)xmlTag;
                    this.addFroMoRefXmls(xmlStringsList, froMoref);
                    continue block7;
                }
            }
        }
        xmlString.setLength(0);
        xmlString.append("</").append(this.getXmlTagName()).append(">");
        xmlStringsList.add(xmlString.toString());
        String[] xmlStrings = new String[xmlStringsList.size()];
        xmlStringsList.toArray(xmlStrings);
        this.logger.traceDebug(this.thisClass, "toXmlStrings(" + xmlStringsList + ")");
        return xmlStrings;
    }

    public final String toXmlString() {
        String[] xmlStrings = this.toXmlStrings();
        StringBuffer xmlStringBuf = new StringBuffer();
        for (int i = 0; i < xmlStrings.length; ++i) {
            xmlStringBuf.append(xmlStrings[i]);
            if (i >= xmlStrings.length - 1) continue;
            xmlStringBuf.append("\n");
        }
        this.logger.traceDebug(this.thisClass, "toXmlString(" + xmlStringBuf + ")");
        return xmlStringBuf.toString();
    }

    public final XmlTag[] getXmlTags() {
        XmlTag[] xmlTags = new XmlTag[this.xmlTagsList.size()];
        this.xmlTagsList.toArray(xmlTags);
        this.logger.traceDebug(this.thisClass, "getXmlTags(" + this.xmlTagsList + ")");
        return xmlTags;
    }

    public final void setXmlTags(XmlTag[] xmlTags) {
        this.xmlTagsList.clear();
        this.xmlTagsList.addAll(Arrays.asList(xmlTags));
    }

    private void addTypeValueXmls(List localXmlTagList, TypeValue typeValue) {
        StringBuffer xmlString = new StringBuffer();
        String[] xmlStrings = typeValue.toXmlStrings();
        for (int i = 0; i < xmlStrings.length; ++i) {
            xmlString.setLength(0);
            xmlString.append("  ").append(xmlStrings[i]);
            localXmlTagList.add(xmlString.toString());
        }
    }

    private void addNameTypeValueXmls(List localXmlTagList, NameTypeValue nameTypeValue) {
        StringBuffer xmlString = new StringBuffer();
        String[] xmlStrings = nameTypeValue.toXmlStrings();
        for (int i = 0; i < xmlStrings.length; ++i) {
            xmlString.setLength(0);
            xmlString.append("  ").append(xmlStrings[i]);
            localXmlTagList.add(xmlString.toString());
        }
    }

    private void addFroStructXmls(List localXmlTagList, FroStruct froStruct) {
        StringBuffer xmlString = new StringBuffer();
        String[] xmlStrings = froStruct.toXmlStrings();
        for (int i = 0; i < xmlStrings.length; ++i) {
            xmlString.setLength(0);
            xmlString.append("  ").append(xmlStrings[i]);
            localXmlTagList.add(xmlString.toString());
        }
    }

    private void addFroArrayXmls(List localXmlTagList, FroArray froArray) {
        StringBuffer xmlString = new StringBuffer();
        String[] xmlStrings = froArray.toXmlStrings();
        for (int i = 0; i < xmlStrings.length; ++i) {
            xmlString.setLength(0);
            xmlString.append("  ").append(xmlStrings[i]);
            localXmlTagList.add(xmlString.toString());
        }
    }

    private void addFroMoRefXmls(List localXmlTagList, FroMoRef froMoRef) {
        StringBuffer xmlString = new StringBuffer();
        String[] xmlStrings = froMoRef.toXmlStrings();
        for (int i = 0; i < xmlStrings.length; ++i) {
            xmlString.setLength(0);
            xmlString.append("  ").append(xmlStrings[i]);
            localXmlTagList.add(xmlString.toString());
        }
    }
}

