/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.notification;

import java.util.Enumeration;
import java.util.Vector;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.threegppsa5.NotificationIRPSystem.Attach;
import se.ericsson.cello.notification.Filter;
import se.ericsson.cello.notification.NotificationCommunicator;
import se.ericsson.cello.notification.NotificationIRPImpl;
import se.ericsson.cello.support.debug.MessageLog;

class SubscriptionList {
    private Vector mySubscriptions = new Vector();
    static int MAX_NO_OF_SUBSCRIPTIONS = 25;

    SubscriptionList() {
    }

    synchronized void addSubscription(NotificationCommunicator notificationCommunicator, SequencePushConsumer sequencePushConsumer, long l, int n, Filter filter) throws Attach {
        SubscriptionData subscriptionData = new SubscriptionData(notificationCommunicator, sequencePushConsumer, l, n, filter);
        if (this.mySubscriptions.size() >= MAX_NO_OF_SUBSCRIPTIONS) {
            this.stopAllSubscriptions();
            this.mySubscriptions.removeAllElements();
            NotificationIRPImpl.instance().removeAllStoredSubscriptions();
            MessageLog.info((Class)SubscriptionList.class, (String)"Maximum number of subscriptions reached, deleting all existing subscriptions.");
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (NotificationCommunicator.getNumberOfActiveCommunicators() >= MAX_NO_OF_SUBSCRIPTIONS) {
            MessageLog.info((Class)SubscriptionList.class, (String)"Maximum alarm/event notification thread limit reached - subscription can not be created.");
            throw new Attach("Maximum alarm/event notification thread limit reached - subscription can not be created.");
        }
        this.mySubscriptions.addElement(subscriptionData);
    }

    private void stopAllSubscriptions() {
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ((SubscriptionData)e).notCom.stopSubscription();
        }
    }

    synchronized void removeSubscription(SequencePushConsumer sequencePushConsumer, long l) {
        boolean bl = false;
        if (l == 0L) {
            Enumeration enumeration = this.mySubscriptions.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!sequencePushConsumer._is_equivalent(((SubscriptionData)e).consumer)) continue;
                this.mySubscriptions.removeElement(e);
                ((SubscriptionData)e).notCom.stopSubscription();
            }
        } else {
            Enumeration enumeration = this.mySubscriptions.elements();
            while (enumeration.hasMoreElements() && !bl) {
                Object e = enumeration.nextElement();
                if (l != ((SubscriptionData)e).subscriptionId) continue;
                this.mySubscriptions.removeElement(e);
                ((SubscriptionData)e).notCom.stopSubscription();
                bl = true;
            }
        }
    }

    synchronized boolean isSubscriptionRegistered(long l) {
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (l != ((SubscriptionData)e).subscriptionId) continue;
            return true;
        }
        return false;
    }

    synchronized boolean updateSubscription(long l, Filter filter) {
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (l != ((SubscriptionData)e).subscriptionId) continue;
            ((SubscriptionData)e).filter = filter;
            return true;
        }
        return false;
    }

    synchronized boolean isSubscriptionRegistered(SequencePushConsumer sequencePushConsumer) {
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!sequencePushConsumer._is_equivalent(((SubscriptionData)e).consumer)) continue;
            return true;
        }
        return false;
    }

    synchronized NotificationCommunicator getNotCom(long l) {
        boolean bl = false;
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Object e = enumeration.nextElement();
            if (l != ((SubscriptionData)e).subscriptionId) continue;
            return ((SubscriptionData)e).notCom;
        }
        return null;
    }

    synchronized Enumeration getAllNotCom() {
        Vector<NotificationCommunicator> vector = new Vector<NotificationCommunicator>();
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((SubscriptionData)enumeration.nextElement()).notCom);
        }
        return vector.elements();
    }

    synchronized Enumeration getAllNotCom(short s, String string, String string2) {
        Vector<NotificationCommunicator> vector = new Vector<NotificationCommunicator>();
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (((SubscriptionData)e).filter != null) {
                if (((SubscriptionData)e).filter.match(s, string, string2)) continue;
                vector.addElement(((SubscriptionData)e).notCom);
                continue;
            }
            vector.addElement(((SubscriptionData)e).notCom);
        }
        return vector.elements();
    }

    synchronized int getTimetick(long l) {
        boolean bl = false;
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Object e = enumeration.nextElement();
            if (l != ((SubscriptionData)e).subscriptionId) continue;
            return ((SubscriptionData)e).timetick;
        }
        return 0;
    }

    synchronized Filter getFilter(long l) {
        Enumeration enumeration = this.mySubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (l != ((SubscriptionData)e).subscriptionId) continue;
            return ((SubscriptionData)e).filter;
        }
        return null;
    }

    private class SubscriptionData {
        NotificationCommunicator notCom;
        SequencePushConsumer consumer;
        long subscriptionId;
        int timetick;
        Filter filter;

        SubscriptionData(NotificationCommunicator notificationCommunicator, SequencePushConsumer sequencePushConsumer, long l, int n, Filter filter) {
            this.notCom = notificationCommunicator;
            this.consumer = sequencePushConsumer;
            this.subscriptionId = l;
            this.timetick = n;
            this.filter = filter;
        }
    }
}

