/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.event;

import java.util.Hashtable;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

class EventAttribute {
    private static Hashtable idTable = new Hashtable();
    private static Hashtable instanceTable = new Hashtable();
    private static long nrOfIds = 0L;
    private String moDName;
    private String moAttribute;
    private long id;
    private int nrOfActiveSubscriptions = 0;
    private int nrOfSubscriptions = 0;
    private boolean debugOn = false;

    static EventAttribute create(String string, String string2) {
        EventAttribute eventAttribute = null;
        String string3 = string + string2;
        if (idTable.containsKey(string3)) {
            eventAttribute = (EventAttribute)instanceTable.get((Long)idTable.get(string3));
        } else {
            eventAttribute = new EventAttribute(string, string2, ++nrOfIds);
            instanceTable.put(new Long(nrOfIds), eventAttribute);
            idTable.put(string3, new Long(nrOfIds));
        }
        eventAttribute.incNrOfSubscriptions();
        return eventAttribute;
    }

    static void remove(EventAttribute eventAttribute) {
        eventAttribute.decNrOfSubscriptions();
        if (eventAttribute.getNrOfSubscriptions() == 0) {
            idTable.remove(eventAttribute.getMoDName() + eventAttribute.getMoAttribute());
            instanceTable.remove(new Long(eventAttribute.getId()));
        }
    }

    static EventAttribute lookup(long l) {
        return (EventAttribute)instanceTable.get(new Long(l));
    }

    void setOn(Coordinator coordinator) {
        ++this.nrOfActiveSubscriptions;
        if (this.debugOn) {
            System.out.println("Class EventAttribute: No of subscriptions the attribute " + this.moAttribute + "(id=" + this.id + ") is involved in is " + this.nrOfActiveSubscriptions);
        }
        if (this.nrOfActiveSubscriptions == 1) {
            ManagedObject managedObject = MoRepository.instance().lookup(this.moDName);
            if (managedObject != null) {
                try {
                    managedObject.setAttribute(this.moAttribute, new Long(this.id), coordinator);
                }
                catch (MoAccessException moAccessException) {
                    MessageLog.traceError(this.getClass(), (String)"Error when setting event attribute", (Throwable)moAccessException);
                }
            } else {
                MessageLog.traceError(this.getClass(), (String)("Error when setting event attribute. No existing instance: " + this.moDName));
            }
        }
    }

    void setOff(Coordinator coordinator) {
        ManagedObject managedObject;
        --this.nrOfActiveSubscriptions;
        if (this.debugOn) {
            System.out.println("Class EventAttribute: No of subscriptions the attribute " + this.moAttribute + "(id=" + this.id + ") is involved in is " + this.nrOfActiveSubscriptions);
        }
        if (this.nrOfActiveSubscriptions == 0 && (managedObject = MoRepository.instance().lookup(this.moDName)) != null) {
            try {
                managedObject.setAttribute(this.moAttribute, new Long(-1L), coordinator);
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
        }
    }

    long getId() {
        return this.id;
    }

    private EventAttribute(String string, String string2, long l) {
        this.moDName = string;
        this.moAttribute = string2;
        this.id = l;
        if (System.getProperty("PMDEBUG") != null) {
            this.debugOn = true;
        }
    }

    private String getMoDName() {
        return this.moDName;
    }

    private String getMoAttribute() {
        return this.moAttribute;
    }

    private void incNrOfSubscriptions() {
        ++this.nrOfSubscriptions;
    }

    private void decNrOfSubscriptions() {
        --this.nrOfSubscriptions;
    }

    private int getNrOfSubscriptions() {
        return this.nrOfSubscriptions;
    }
}

