/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.Serializable;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;

public final class GranularityPeriod
implements Serializable {
    private static final int _SECONDS_15 = 0;
    private static final int _MINUTES_5 = 1;
    private static final int _MINUTES_15 = 2;
    private static final int _HOURS_1 = 3;
    public static final GranularityPeriod SECONDS_15 = new GranularityPeriod(0, 15);
    public static final GranularityPeriod MINUTES_5 = new GranularityPeriod(1, 300);
    public static final GranularityPeriod MINUTES_15 = new GranularityPeriod(2, 900);
    public static final GranularityPeriod HOURS_1 = new GranularityPeriod(3, 3600);
    private static GranularityPeriod[] periods = new GranularityPeriod[]{SECONDS_15, MINUTES_5, MINUTES_15, HOURS_1};
    private int value;
    private int inSeconds;

    public static GranularityPeriod convertFromSeconds(int n) throws InvalidGranularityPeriodException {
        for (int i = 0; i < periods.length; ++i) {
            if (periods[i].inSeconds() != n) continue;
            if (periods[i].equals(SECONDS_15) && System.getProperty("TEST") == null) {
                throw new InvalidGranularityPeriodException();
            }
            return periods[i];
        }
        throw new InvalidGranularityPeriodException();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        return ((GranularityPeriod)object).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    private GranularityPeriod(int n, int n2) {
        this.value = n;
        this.inSeconds = n2;
    }

    public int inSeconds() {
        return this.inSeconds;
    }
}

