/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import se.ericsson.cello.productinventory.BasedOnData;
import se.ericsson.cello.productinventory.FileGarbageCollector;
import se.ericsson.cello.productinventory.LicenseCapacityData;
import se.ericsson.cello.productinventory.LicenseFeatureData;
import se.ericsson.cello.productinventory.SwltData;
import se.ericsson.cello.productinventory.UpSwData;
import se.ericsson.cello.productinventory.UpgradePackageProductData;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.XmlHelper;

class XmlFormatter {
    private File file = null;
    private BufferedWriter bufferedWriter = null;

    XmlFormatter(int n) throws IOException {
        String string = this.getFileName(n);
        String string2 = this.getPath();
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileGarbageCollector.instance().clean(string2);
        this.file = new File(string2 + string);
        this.bufferedWriter = new BufferedWriter(new FileWriter(this.file));
        this.fileTitlePrinter();
    }

    String closeXmlFile() throws IOException {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.write("</ProductInventory>\n");
            this.bufferedWriter.flush();
            this.bufferedWriter.close();
            this.bufferedWriter = null;
        }
        return this.file.getPath();
    }

    void removeXmlFile() throws IOException {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.flush();
            this.bufferedWriter.close();
            this.bufferedWriter = null;
        }
        this.file.delete();
    }

    void storeNode(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (string4.equals("")) {
            string4 = " ";
        }
        if (string5.equals("")) {
            string5 = " ";
        }
        this.bufferedWriter.write("  <Node>\n");
        this.bufferedWriter.write("    <LogicalNodeName> " + XmlHelper.encodeXml(string2) + " </LogicalNodeName>\n");
        this.bufferedWriter.write("    <ProdName> " + XmlHelper.encodeXml(string3) + " </ProdName>\n");
        this.bufferedWriter.write("    <ProdId ProdNo=\"" + XmlHelper.encodeXml(string4) + "\" ProdRev=\"" + XmlHelper.encodeXml(string5) + "\"/>\n");
        this.bufferedWriter.write("    <Site> " + XmlHelper.encodeXml(string) + " </Site>\n");
        this.bufferedWriter.write("  </Node>\n");
    }

    void storeHardware(String string, String string2, String string3, String string4, String string5, String string6, int n) throws IOException {
        if (string2.equals("")) {
            string2 = " ";
        }
        if (string3.equals("")) {
            string3 = " ";
        }
        if (string6.equals("")) {
            string6 = " ";
        }
        this.bufferedWriter.write("  <HW>\n");
        this.bufferedWriter.write("    <ProdName> " + XmlHelper.encodeXml(string) + " </ProdName>\n");
        this.bufferedWriter.write("    <ProdId ProdNo=\"" + XmlHelper.encodeXml(string2) + "\" ProdRev=\"" + XmlHelper.encodeXml(string3) + "\"/>\n");
        this.bufferedWriter.write("    <Date Year=\"" + this.getYear(string4) + "\" Month=\"" + this.getMonth(string4) + "\" Day=\"" + this.getDay(string4) + "\"/>\n");
        this.bufferedWriter.write("    <SerialNo> " + XmlHelper.encodeXml(string5) + " </SerialNo>\n");
        this.bufferedWriter.write("    <HWPos SubrackId=\"" + XmlHelper.encodeXml(string6) + "\" SlotNo=\"" + n + "\"/>\n");
        this.bufferedWriter.write("  </HW>\n");
    }

    void storeSoftware(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (string2.equals("")) {
            string2 = " ";
        }
        if (string3.equals("")) {
            string3 = " ";
        }
        if (string5.equals("")) {
            string5 = " ";
        }
        this.bufferedWriter.write("  <SW>\n");
        this.bufferedWriter.write("    <ProdName> " + XmlHelper.encodeXml(string) + " </ProdName>\n");
        this.bufferedWriter.write("    <ProdId ProdNo=\"" + XmlHelper.encodeXml(string2) + "\" ProdRev=\"" + XmlHelper.encodeXml(string3) + "\"/>\n");
        this.bufferedWriter.write("    <Date Year=\"" + this.getYear(string4) + "\" Month=\"" + this.getMonth(string4) + "\" Day=\"" + this.getDay(string4) + "\"/>\n");
        this.bufferedWriter.write("    <FilePos FilePath=\"" + XmlHelper.encodeXml(string5) + "\"/>\n");
        this.bufferedWriter.write("  </SW>\n");
    }

    void storeUpSwList(String string, String string2, UpSwData[] upSwDataArray) throws IOException {
        if (string.equals("")) {
            string = " ";
        }
        if (string2.equals("")) {
            string2 = " ";
        }
        this.bufferedWriter.write("  <UpSwList>\n");
        this.bufferedWriter.write("    <DocId DocNo=\"" + XmlHelper.encodeXml(string) + "\" DocRev=\"" + XmlHelper.encodeXml(string2) + "\"/>\n");
        for (int i = 0; i < upSwDataArray.length; ++i) {
            this.bufferedWriter.write("    <ProdId ProdNo=\"" + XmlHelper.encodeXml(upSwDataArray[i].productNumber) + "\" ProdRev=\"" + XmlHelper.encodeXml(upSwDataArray[i].revision) + "\"/>\n");
        }
        this.bufferedWriter.write("  </UpSwList>\n");
    }

    void storeFirmware(String string, String string2, String string3, String string4, String string5, int n) throws IOException {
        if (string2.equals("")) {
            string2 = " ";
        }
        if (string3.equals("")) {
            string3 = " ";
        }
        if (string5.equals("")) {
            string5 = " ";
        }
        this.bufferedWriter.write("  <FW>\n");
        this.bufferedWriter.write("    <ProdName> " + XmlHelper.encodeXml(string) + " </ProdName>\n");
        this.bufferedWriter.write("    <ProdId ProdNo=\"" + XmlHelper.encodeXml(string2) + "\" ProdRev=\"" + XmlHelper.encodeXml(string3) + "\"/>\n");
        this.bufferedWriter.write("    <Date Year=\"" + this.getYear(string4) + "\" Month=\"" + this.getMonth(string4) + "\" Day=\"" + this.getDay(string4) + "\"/>\n");
        this.bufferedWriter.write("    <HWPos SubrackId=\"" + XmlHelper.encodeXml(string5) + "\" SlotNo=\"" + n + "\"/>\n");
        this.bufferedWriter.write("  </FW>\n");
    }

    void storeCustomerProductInfo(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (string2.equals("")) {
            string2 = " ";
        }
        if (string3.equals("")) {
            string3 = " ";
        }
        if (string5.equals("")) {
            string5 = " ";
        }
        this.bufferedWriter.write("  <CPI>\n");
        this.bufferedWriter.write("    <ProdName> " + XmlHelper.encodeXml(string) + " </ProdName>\n");
        this.bufferedWriter.write("    <ProdId ProdNo=\"" + XmlHelper.encodeXml(string2) + "\" ProdRev=\"" + XmlHelper.encodeXml(string3) + "\"/>\n");
        this.bufferedWriter.write("    <Date Year=\"" + this.getYear(string4) + "\" Month=\"" + this.getMonth(string4) + "\" Day=\"" + this.getDay(string4) + "\"/>\n");
        this.bufferedWriter.write("    <FilePos FilePath=\"" + XmlHelper.encodeXml(string5) + "\"/>\n");
        this.bufferedWriter.write("  </CPI>\n");
    }

    void storeUpgradePackage(String string, String string2, String string3, String string4, UpgradePackageProductData.UpStatus upStatus, BasedOnData basedOnData) throws IOException {
        if (string.equals("")) {
            string = " ";
        }
        if (string2.equals("")) {
            string2 = " ";
        }
        if (string4.equals("")) {
            string4 = " ";
        }
        this.bufferedWriter.write("  <UP>\n");
        this.bufferedWriter.write("    <DocId DocNo=\"" + XmlHelper.encodeXml(string) + "\" DocRev=\"" + XmlHelper.encodeXml(string2) + "\"/>\n");
        this.bufferedWriter.write("    <Date Year=\"" + this.getYear(string3) + "\" Month=\"" + this.getMonth(string3) + "\" Day=\"" + this.getDay(string3) + "\"/>\n");
        this.bufferedWriter.write("    <FilePos FilePath=\"" + XmlHelper.encodeXml(string4) + "\"/>\n");
        this.bufferedWriter.write("    <UpStatus Status=\"" + upStatus + "\"/>\n");
        if (basedOnData != null && !basedOnData.documentNumber.equals("")) {
            this.bufferedWriter.write("    <BasedOn DocNo=\"" + XmlHelper.encodeXml(basedOnData.documentNumber) + "\" DocRev=\"" + XmlHelper.encodeXml(basedOnData.revision) + "\"/>\n");
        }
        this.bufferedWriter.write("  </UP>\n");
    }

    void storeLicense(SwltData swltData, String string, String string2, String string3, LicenseFeatureData[] licenseFeatureDataArray, LicenseCapacityData[] licenseCapacityDataArray) throws IOException {
        try {
            int n;
            if (string.equals("")) {
                string = " ";
            }
            if (string2.equals("")) {
                string2 = " ";
            }
            if (string3.equals("")) {
                string3 = " ";
            }
            this.bufferedWriter.write("  <License Fingerprint=\"" + XmlHelper.encodeXml(string) + "\">\n");
            if (swltData.formatVersion.equals("1.0")) {
                this.bufferedWriter.write("    <ELSN ElsnId=\"" + XmlHelper.encodeXml(swltData.elsn) + "\" ProductType=\"" + XmlHelper.encodeXml(swltData.productType) + "\" CustomerId=\"" + XmlHelper.encodeXml(swltData.customerId) + "\"/>\n");
            } else {
                this.bufferedWriter.write("    <SWLT SwltId=\"" + XmlHelper.encodeXml(swltData.swlt) + "\" ProductType=\"" + XmlHelper.encodeXml(swltData.productType) + "\" CustomerId=\"" + XmlHelper.encodeXml(swltData.customerId) + "\"/>\n");
            }
            this.bufferedWriter.write("    <Installation SeqNumber=\"" + XmlHelper.encodeXml(string2) + "\">\n");
            this.bufferedWriter.write("      <DateTime>\n");
            this.bufferedWriter.write("        <Date Year=\"" + this.getYear(string3) + "\" Month=\"" + this.getMonth(string3) + "\" Day=\"" + this.getDay(string3) + "\"/>\n");
            this.bufferedWriter.write("        <Time Second=\"" + this.getSeconds(string3) + "\" Minute=\"" + this.getMinutes(string3) + "\" Hour=\"" + this.getHours(string3) + "\"/>\n");
            this.bufferedWriter.write("      </DateTime>\n");
            this.bufferedWriter.write("    </Installation>\n");
            for (n = 0; n < licenseFeatureDataArray.length; ++n) {
                if (licenseFeatureDataArray[n].stopDate.equals("")) {
                    licenseFeatureDataArray[n].stopDate = "99991231";
                }
                this.bufferedWriter.write("    <FeatureKey Id=\"" + XmlHelper.encodeXml(licenseFeatureDataArray[n].featureId) + "\">\n");
                this.bufferedWriter.write("      <Description>" + XmlHelper.encodeXml(licenseFeatureDataArray[n].description) + "</Description>\n");
                this.bufferedWriter.write("      <StartDate Year=\"" + this.getYear(licenseFeatureDataArray[n].startDate) + "\" Month=\"" + this.getMonth(licenseFeatureDataArray[n].startDate) + "\" Day=\"" + this.getDay(licenseFeatureDataArray[n].startDate) + "\"/>\n");
                this.bufferedWriter.write("      <StopDate Year=\"" + this.getYear(licenseFeatureDataArray[n].stopDate) + "\" Month=\"" + this.getMonth(licenseFeatureDataArray[n].stopDate) + "\" Day=\"" + this.getDay(licenseFeatureDataArray[n].stopDate) + "\"/>\n");
                this.bufferedWriter.write("    </FeatureKey>\n");
            }
            for (n = 0; n < licenseCapacityDataArray.length; ++n) {
                if (licenseCapacityDataArray[n].stopDate.equals("")) {
                    licenseCapacityDataArray[n].stopDate = "99991231";
                }
                this.bufferedWriter.write("    <CapacityKey Id=\"" + XmlHelper.encodeXml(licenseCapacityDataArray[n].capacityKeyId) + "\">\n");
                this.bufferedWriter.write("      <Description>" + XmlHelper.encodeXml(licenseCapacityDataArray[n].description) + "</Description>\n");
                this.bufferedWriter.write("      <StartDate Year=\"" + this.getYear(licenseCapacityDataArray[n].startDate) + "\" Month=\"" + this.getMonth(licenseCapacityDataArray[n].startDate) + "\" Day=\"" + this.getDay(licenseCapacityDataArray[n].startDate) + "\"/>\n");
                this.bufferedWriter.write("      <StopDate Year=\"" + this.getYear(licenseCapacityDataArray[n].stopDate) + "\" Month=\"" + this.getMonth(licenseCapacityDataArray[n].stopDate) + "\" Day=\"" + this.getDay(licenseCapacityDataArray[n].stopDate) + "\"/>\n");
                this.bufferedWriter.write("      <Capacity>" + XmlHelper.encodeXml(licenseCapacityDataArray[n].capacity) + "</Capacity>\n");
                this.bufferedWriter.write("      <HardLimit>" + XmlHelper.encodeXml(licenseCapacityDataArray[n].hardLimit) + "</HardLimit>\n");
                this.bufferedWriter.write("    </CapacityKey>\n");
            }
            this.bufferedWriter.write("  </License>\n");
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)XmlFormatter.class, (String)"storeLicense failed.", (Throwable)exception);
        }
    }

    String getPath() {
        if (System.getProperty("SIM") == null && System.getProperty("JAVASIM") == null) {
            return "/c/pi_data/";
        }
        return System.getProperty("user.dir") + "pi_data" + System.getProperty("file.separator");
    }

    private String getFileName(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        return "PI" + string + "_" + n + ".xml";
    }

    private void fileTitlePrinter() throws IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.bufferedWriter.write("<!DOCTYPE ProductInventory SYSTEM \"ProductInventory.dtd\">\n");
        this.bufferedWriter.write("<ProductInventory>\n");
        this.bufferedWriter.write("  <DateTime>\n");
        this.bufferedWriter.write("    <Date Year=\"" + gregorianCalendar.get(1) + "\" Month=\"" + (gregorianCalendar.get(2) + 1) + "\" Day=\"" + gregorianCalendar.get(5) + "\"/>\n");
        this.bufferedWriter.write("    <Time Hour=\"" + gregorianCalendar.get(11) + "\" Minute=\"" + gregorianCalendar.get(12) + "\" Second=\"" + gregorianCalendar.get(13) + "\"/>\n");
        this.bufferedWriter.write("  </DateTime>\n");
    }

    private String getSeconds(String string) {
        return string.substring(12, 14);
    }

    private String getMinutes(String string) {
        return string.substring(10, 12);
    }

    private String getHours(String string) {
        return string.substring(8, 10);
    }

    private String getDay(String string) {
        return string.substring(6, 8);
    }

    private String getMonth(String string) {
        return string.substring(4, 6);
    }

    private String getYear(String string) {
        return string.substring(0, 4);
    }
}

