/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.support.corba.RequestItem;
import se.ericsson.cello.support.corba.RequestItemStorage;
import se.ericsson.cello.support.debug.MessageLog;

public class RequestItemHandler
implements RequestItemStorage {
    private static RequestItemHandler instance = null;
    private static final int MAX_REQUEST_SIZE = 100;
    Map requests = new HashMap();

    private RequestItemHandler() {
    }

    public static synchronized RequestItemStorage instance() {
        if (instance == null) {
            instance = new RequestItemHandler();
        }
        return instance;
    }

    public synchronized void clear() {
        this.requests.clear();
    }

    public synchronized RequestItem lookupItem(String string) {
        return (RequestItem)this.requests.get(string);
    }

    public synchronized void storeItem(RequestItem requestItem) {
        MessageLog.trace((int)5, this.getClass(), (String)("Storing Request " + requestItem.toString()));
        if (this.requests.size() > 100) {
            MessageLog.info(this.getClass(), (String)"Maximum stored requests exceeded. Clearing buffer");
            this.requests.clear();
        }
        this.requests.put(requestItem.getRequestThread(), requestItem);
    }

    public synchronized void removeItem(RequestItem requestItem) {
        RequestItem requestItem2 = (RequestItem)this.requests.get(requestItem.getRequestThread());
        if (requestItem2 != null) {
            if (requestItem2.equals(requestItem)) {
                this.requests.remove(requestItem.getRequestThread());
                MessageLog.trace((int)5, this.getClass(), (String)("Removing Request " + requestItem.toString()));
            } else {
                MessageLog.trace((int)5, this.getClass(), (String)("Conflicting operation found for " + requestItem));
            }
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)("No stored request found for " + requestItem));
        }
    }
}

