/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class LdnHelper {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$common$LdnHelper == null ? (class$se$ericsson$crbs$common$LdnHelper = LdnHelper.class$("se.ericsson.crbs.common.LdnHelper")) : class$se$ericsson$crbs$common$LdnHelper;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$common$LdnHelper;

    public static String replaceInLdn(String ldn, String oldValue, String newValue) {
        ArrayList<String> changedLdnElementsList = new ArrayList<String>();
        String correctedLdn = StringHelper.replaceInString(ldn, " ", "");
        String manipulatedOldValue = oldValue + "=";
        String manipulatedNewValue = newValue + "=";
        StringTokenizer tokenizer = new StringTokenizer(correctedLdn, ",");
        while (tokenizer.hasMoreElements()) {
            String ldnElement = (String)tokenizer.nextElement();
            if (ldnElement.startsWith(manipulatedOldValue)) {
                String correctedValue = StringHelper.replaceInString(ldnElement, manipulatedOldValue, manipulatedNewValue);
                changedLdnElementsList.add(correctedValue);
                continue;
            }
            changedLdnElementsList.add(ldnElement);
        }
        StringBuffer newLdnBuffer = new StringBuffer();
        for (int i = 0; i < changedLdnElementsList.size(); ++i) {
            newLdnBuffer.append(changedLdnElementsList.get(i));
            if (i >= changedLdnElementsList.size() - 1) continue;
            newLdnBuffer.append(",");
        }
        return newLdnBuffer.toString();
    }

    public static String getLastLdnElement(String ldn) {
        String lastLdnElement = "";
        if (LdnHelper.isLdn(ldn)) {
            String correctedLdn = StringHelper.replaceInString(ldn, " ", "");
            StringTokenizer commaTokenizer = new StringTokenizer(correctedLdn, ",");
            while (commaTokenizer.hasMoreElements()) {
                lastLdnElement = (String)commaTokenizer.nextElement();
            }
            StringTokenizer equalsTokenizer = new StringTokenizer(lastLdnElement, "=");
            lastLdnElement = equalsTokenizer.hasMoreElements() ? (String)equalsTokenizer.nextElement() : "";
        } else {
            lastLdnElement = "";
        }
        return lastLdnElement;
    }

    public static String getRdnElement(String ldn) {
        String rdn = "";
        if (LdnHelper.isLdn(ldn)) {
            String correctedLdn = StringHelper.replaceInString(ldn, " ", "");
            rdn = correctedLdn.substring(correctedLdn.lastIndexOf(44) + 1);
        }
        return rdn;
    }

    public static String getRdnAttributeValue(String ldn) {
        logger.traceEnter(THIS_CLASS, "getRdnAttributeValue() " + ldn);
        String rdnElement = "";
        if (LdnHelper.isLdn(ldn)) {
            rdnElement = LdnHelper.getRdnElement(ldn);
            rdnElement = rdnElement.substring(rdnElement.lastIndexOf(61) + 1);
        }
        logger.traceReturn(THIS_CLASS, "getRdnAttributeValue() " + rdnElement);
        return rdnElement;
    }

    public static boolean isLdn(String stringToBeCkecked) {
        boolean stringIsLdn = true;
        try {
            String correctedString = StringHelper.replaceInString(stringToBeCkecked, " ", "");
            StringTokenizer commaTokenizer = new StringTokenizer(correctedString, ",");
            int numberOfCommas = commaTokenizer.countTokens();
            while (commaTokenizer.hasMoreElements()) {
                String possibleLdnElement = (String)commaTokenizer.nextElement();
                int index = possibleLdnElement.indexOf("=");
                stringIsLdn = stringIsLdn && index > 0 && index < possibleLdnElement.length() - 1;
            }
            StringTokenizer equalsTokenizer = new StringTokenizer(correctedString, "=");
            stringIsLdn = stringIsLdn && equalsTokenizer.countTokens() == numberOfCommas + 1;
        }
        catch (Exception e) {
            logger.traceGeneral(THIS_CLASS, "The String " + StringHelper.doubleQuote(stringToBeCkecked) + " is not a valid LDN.");
            stringIsLdn = false;
        }
        return stringIsLdn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

