/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.FindMoDataByParentLDNFilter;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class AbstractDeleteMoAction
implements MoDataAction {
    private final Class loggerClass;
    private final AbstractLogger logger;

    public AbstractDeleteMoAction(Class loggerClass) {
        this.loggerClass = loggerClass;
        this.logger = LoggingService.getLogger(loggerClass.getName());
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        String moTypeName = moDataWrapper.getMoTypeName();
        this.logger.traceEnter(this.loggerClass, "perform(" + moTypeName + ")");
        try {
            this.deleteChildren(moDataWrapper.getLocalDistinguishedName(), converterContext, coordinator);
            this.logger.traceGeneral(this.loggerClass, "Trying to delete, " + moTypeName + ", using Coordinator: " + coordinator);
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            try {
                moDataAccessor.delete(moDataWrapper, coordinator);
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
            if (moDataWrapper.isDeleted()) {
                this.logger.traceGeneral(this.loggerClass, moTypeName + " successfully deleted!");
            } else {
                this.logger.traceError(this.loggerClass, moTypeName + " NOT deleted !");
            }
        }
        catch (CrbsAueException auee) {
            this.logger.traceError(this.loggerClass, auee.getMessage(), (Throwable)((Object)auee));
            throw auee;
        }
        this.logger.traceReturn(this.loggerClass, "perform(" + moTypeName + ")");
    }

    private void deleteChildren(String parentLdn, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        this.logger.traceEnter(this.loggerClass, "deleteChildren(" + parentLdn + ")");
        try {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(parentLdn));
            this.logger.traceGeneral(this.loggerClass, "deleteChildren childrens: " + children.size());
            if (children != null) {
                Iterator childIter = children.iterator();
                while (childIter.hasNext()) {
                    MoDataWrapper moDataWrapper = (MoDataWrapper)childIter.next();
                    String childLdn = moDataWrapper.getLocalDistinguishedName();
                    this.logger.traceGeneral(this.loggerClass, "Got child " + childLdn);
                    moDataAccessor.delete(moDataWrapper, coordinator);
                    if (moDataWrapper.isDeleted()) {
                        this.logger.traceGeneral(this.loggerClass, childLdn + " successfully deleted!");
                        continue;
                    }
                    this.logger.traceAbnormal(this.loggerClass, childLdn + " NOT deleted!");
                }
            }
        }
        catch (CrbsAueException cae) {
            throw cae;
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
        this.logger.traceReturn(this.loggerClass, "deleteChildren(" + parentLdn + ")");
    }
}

