/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.io.StringReader;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step2.actions.ChildInstanceAttributesHandler;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Util;

public class CreateChildInstanceAction
implements MoDataAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step2$actions$CreateChildInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step2$actions$CreateChildInstanceAction = CreateChildInstanceAction.class$("se.ericsson.crbs.omf.aue.step2.actions.CreateChildInstanceAction")) : class$se$ericsson$crbs$omf$aue$step2$actions$CreateChildInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final Map paramMap = new HashMap();
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step2$actions$CreateChildInstanceAction;

    public CreateChildInstanceAction(Map argMap) {
        this.paramMap.putAll(argMap);
    }

    public void perform(MoDataWrapper modatawrapper, ConverterContext convertercontext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        String rdnValue = this.getAndCheckParamMapString("childRdnValue", this.paramMap, "The child RDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String childType = this.getAndCheckParamMapString("childType", this.paramMap, "The child type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String childAttributes = (String)this.paramMap.get("childAttributes");
        AbstractList attributeDataList = null;
        if (childAttributes != null && !childAttributes.equals("")) {
            attributeDataList = this.parseChildAttributes(childAttributes);
        }
        MoDataAccessor moDataAccessor = convertercontext.getMoDataAccessor();
        String parentLdn = modatawrapper.getLocalDistinguishedName();
        String childLdn = parentLdn + "," + childType + "=" + rdnValue;
        try {
            Collection mos = moDataAccessor.find((MoDataFilter)new FindMoDataByLDNFilter(childLdn));
            if (mos.size() == 0) {
                MoDataWrapper newMo = Step2Util.createMo(moDataAccessor, childLdn, coordinator, convertercontext);
                if (attributeDataList != null) {
                    for (int i = 0; i < attributeDataList.size(); ++i) {
                        newMo.registerPersistentAttr((Attribute)attributeDataList.get(i));
                        logger.traceDebug(THIS_CLASS, "Registering attribute");
                    }
                }
                logger.traceGeneral(THIS_CLASS, "created " + newMo.getLocalDistinguishedName());
                logger.traceReturn(THIS_CLASS, "perform");
            }
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
    }

    protected String getAndCheckParamMapString(String key, Map localParamMap, String errorMsg) throws CrbsAueException {
        String keyValue = (String)localParamMap.get(key);
        if (keyValue == null || keyValue.equals("")) {
            throw new CrbsAueException(errorMsg);
        }
        return keyValue;
    }

    private AbstractList parseChildAttributes(String childAttributes) throws CrbsAueException {
        try {
            String correctedXml = this.replaceInnerXmlTags(childAttributes);
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            StringReader reader = new StringReader(correctedXml);
            InputSource inputSource = new InputSource(reader);
            ChildInstanceAttributesHandler handler = new ChildInstanceAttributesHandler();
            parser.setContentHandler(handler);
            parser.parse(inputSource);
            AbstractList attributeDataList = handler.getAttributeList();
            if (attributeDataList == null) {
                throw new CrbsAueException("No attribute list recieved from the ChildInstanceAttributeHandler");
            }
            return attributeDataList;
        }
        catch (Exception e) {
            throw new CrbsAueException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceInnerXmlTags(String xmlString) {
        CreateChildInstanceAction createChildInstanceAction = this;
        synchronized (createChildInstanceAction) {
            int nestedLevel = 0;
            logger.traceGeneral(THIS_CLASS, xmlString);
            String correctedXml = xmlString;
            for (int i = 0; i < correctedXml.length(); ++i) {
                char currentChar = correctedXml.charAt(i);
                if (currentChar == '<') {
                    if (++nestedLevel <= 1) continue;
                    correctedXml = correctedXml.substring(0, i) + "&lt;" + correctedXml.substring(i + 1, correctedXml.length());
                    continue;
                }
                if (currentChar == '>') {
                    if (nestedLevel > 1) {
                        correctedXml = correctedXml.substring(0, i) + "&gt;" + correctedXml.substring(i + 1, correctedXml.length());
                    }
                    --nestedLevel;
                    continue;
                }
                if (currentChar != '\"' || nestedLevel <= 1) continue;
                correctedXml = correctedXml.substring(0, i) + "&quot;" + correctedXml.substring(i + 1, correctedXml.length());
            }
            logger.traceGeneral(THIS_CLASS, correctedXml);
            return correctedXml;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

