/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions.util;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.RbsAueMetaData;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2HandlerHelper;

public class Step2HandlerHelperImpl
implements Step2HandlerHelper {
    private static final Class THIS_CLASS = Step2HandlerHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final RbsAueMetaData rbsAueMetaData;
    private final DbWrapper dbWrapper;

    public Step2HandlerHelperImpl(RbsAueMetaData rbsAueMetaData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "Step2Handler() - constructor");
        this.rbsAueMetaData = rbsAueMetaData;
        this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        logger.traceReturn(THIS_CLASS, "Step2Handler() - constructor");
    }

    public String retrieveFromAuePersistency(String ldn, String attributeName) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "retrieveFromAuePersistency()");
        String value = "";
        ResultSet resultSet = null;
        String name = ldn + attributeName;
        try {
            this.dbWrapper.openConnection();
            resultSet = this.dbWrapper.executeQuery("SELECT value FROM " + this.rbsAueMetaData.getAuePersistencyTableName() + " WHERE name = " + AueUtil.quote(name));
            if (resultSet.next()) {
                value = resultSet.getString(1);
            }
        }
        catch (Exception e) {
            throw new CrbsAueException(e.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sqle) {
                    throw new CrbsAueException(sqle.getMessage());
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "retrieveFromAuePersistency()");
        return value;
    }

    public RbsAueMetaData getRbsAueMetaData() {
        return this.rbsAueMetaData;
    }
}

