/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class CreateMaoClimateForCabinetsAction
implements MoDataAction {
    private static final Class THIS_CLASS = CreateMaoClimateForCabinetsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String RESERVED_BY_ATTRIBUTE_NAME = "reservedBy";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String CONTROL_DOMAIN_REF_ATTRIBUTE_NAME = "controlDomainRef";
    private static final String STEP2_CLIMATE_CREATED = "climateCreated";
    private static final String STEP2_CLIMATE_CTRLDOMAINREF_TAG = "ctrlDomainRef";
    private static final String STEP2_CLIMATE_FROID_TAG = "climateFroId";
    private static final String STEP2_CLIMATES_LIST_TAG = "climateList";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        if (step2Handler.retrieveFromAuePersistency("", STEP2_CLIMATE_CREATED).equalsIgnoreCase("true")) {
            String[] stringArray = this.getLdnsOfCreatedClimates(converterContext);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = step2Handler.retrieveFromAuePersistency(stringArray[i], STEP2_CLIMATE_FROID_TAG);
                String string2 = step2Handler.retrieveFromAuePersistency(stringArray[i], STEP2_CLIMATE_CTRLDOMAINREF_TAG);
                this.createClimateMo(converterContext, stringArray[i], Integer.parseInt(string), string2, coordinator);
                MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
                Collection collection = moDataAccessor.getByType(CABINET_MO_TYPE);
                MoDataWrapper moDataWrapper2 = null;
                if (collection == null) continue;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    moDataWrapper2 = (MoDataWrapper)iterator.next();
                    String string3 = moDataWrapper2.getLocalDistinguishedName();
                    if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
                    this.updateReservedBy(moDataWrapper2, stringArray[i], coordinator);
                }
            }
        }
    }

    private void createClimateMo(ConverterContext converterContext, String string, int n, String string2, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            MoDataWrapper moDataWrapper = moDataAccessor.create(string, coordinator);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(moDataWrapper, n);
            this.addReferenceAttribute(moDataWrapper, CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, string2);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "createMo()");
    }

    private String[] getLdnsOfCreatedClimates(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnsOfCreatedClimates()");
        String[] stringArray = new String[]{};
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", STEP2_CLIMATES_LIST_TAG);
        if (string == null || string.length() == 0) {
            logger.traceDebug(THIS_CLASS, "No Climates to create.");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            stringArray = arrayList.toArray(stringArray);
        }
        logger.traceReturn(THIS_CLASS, "getLdnsOfCreatedClimates()");
        return stringArray;
    }

    private void updateReservedBy(MoDataWrapper moDataWrapper, String string, Coordinator coordinator) throws CrbsAueException {
        String string2 = moDataWrapper.getLocalDistinguishedName();
        logger.traceEnter(THIS_CLASS, "updateReservedBy() for " + string2);
        logger.traceGeneral(THIS_CLASS, "Updating ReservedBy attribute for " + string2);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(RESERVED_BY_ATTRIBUTE_NAME);
        if (sequenceAttribute == null) {
            sequenceAttribute = new SequenceAttribute(RESERVED_BY_ATTRIBUTE_NAME, true);
        }
        try {
            boolean bl = false;
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
                String string3 = referenceAttribute.getReferenceAsLDN();
                if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
                logger.traceGeneral(THIS_CLASS, "ReservedBy attribute for " + string2 + " already contains " + string);
                bl = true;
            }
            if (!bl) {
                sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string, true));
            }
            moDataWrapper.deregisterAttribute(RESERVED_BY_ATTRIBUTE_NAME);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "updateReservedBy()");
    }

    private void addFroIdAttribute(MoDataWrapper moDataWrapper, int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute integerAttribute = new IntegerAttribute("froId", false, n);
        moDataWrapper.registerPersistentAttr((Attribute)integerAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute()");
    }

    private void addReferenceAttribute(MoDataWrapper moDataWrapper, String string, String string2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addReferenceAttribute()");
        SequenceAttribute sequenceAttribute = new SequenceAttribute(string, false);
        sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string2, true));
        moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
        logger.traceReturn(THIS_CLASS, "addReferenceAttribute()");
    }
}

