/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class FixClimateSystemAttrAction
implements MoDataAction {
    private static final Class THIS_CLASS = FixClimateSystemAttrAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String AUE_PERSISTENCY_KEY = "FixClimateSystemAttrData";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        String[] stringArray = this.getLdnPlusClimateSystemListFromStep1(converterContext);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            logger.traceDebug(THIS_CLASS, "ldnPlusClimateSystem: {" + string + "}");
            String[] stringArray2 = this.split(string, ";");
            logger.traceDebug(THIS_CLASS, "a[0] = {" + stringArray2[0] + "}");
            logger.traceDebug(THIS_CLASS, "a[1] = {" + stringArray2[1] + "}");
            String string2 = stringArray2[0];
            int n = new Integer(stringArray2[1]);
            try {
                MoDataWrapper moDataWrapper2 = moDataAccessor.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string2));
                Attribute attribute = moDataWrapper2.getAttribute("climateSystem");
                if (attribute != null) {
                    if (attribute instanceof IntegerAttribute) {
                        ((IntegerAttribute)attribute).setValue(n);
                        continue;
                    }
                    logger.traceDebug(THIS_CLASS, "climateSystem is not an integer attribute.");
                    continue;
                }
                attribute = new IntegerAttribute("climateSystem", false, n);
                moDataWrapper2.registerPersistentAttr(attribute);
                logger.traceDebug(THIS_CLASS, "climateSystem did not exist in MAO, now created.");
                continue;
            }
            catch (AueException aueException) {
                logger.traceDebug(THIS_CLASS, "Cabinet was not found: " + string2);
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String[] getLdnPlusClimateSystemListFromStep1(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnPlusClimateSystemListFromStep1");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", AUE_PERSISTENCY_KEY);
        logger.traceDebug(THIS_CLASS, "PersistencyString: {" + string + "}");
        logger.traceReturn(THIS_CLASS, "getLdnPlusClimateSystemListFromStep1");
        return this.split(string, ":");
    }

    private String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        try {
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.traceDebug(THIS_CLASS, "NoSuchElementException\n");
        }
        return stringArray;
    }
}

