/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final BlockingQueue completionQueue;

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue blockingQueue) {
        if (executor == null || blockingQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = blockingQueue;
    }

    public Future submit(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        QueueingFuture queueingFuture = new QueueingFuture(callable);
        this.executor.execute(queueingFuture);
        return queueingFuture;
    }

    public Future submit(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        QueueingFuture queueingFuture = new QueueingFuture(runnable, object);
        this.executor.execute(queueingFuture);
        return queueingFuture;
    }

    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        return (Future)this.completionQueue.poll(l2, timeUnit);
    }

    private class QueueingFuture
    extends FutureTask {
        QueueingFuture(Callable callable) {
            super(callable);
        }

        QueueingFuture(Runnable runnable, Object object) {
            super(runnable, object);
        }

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this);
        }
    }
}

