/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    transient int activeReaders_ = 0;
    transient Thread activeWriter_ = null;
    transient int waitingReaders_ = 0;
    transient int waitingWriters_ = 0;
    final ReaderLock readerLock_ = new ReaderLock();
    final WriterLock writerLock_ = new WriterLock();
    transient int writeHolds_ = 0;
    transient HashMap readers_ = new HashMap();
    static final Integer IONE = new Integer(1);

    public Lock writeLock() {
        return this.writerLock_;
    }

    public Lock readLock() {
        return this.readerLock_;
    }

    synchronized boolean startReadFromNewReader() {
        boolean bl = this.startRead();
        if (!bl) {
            ++this.waitingReaders_;
        }
        return bl;
    }

    synchronized boolean startWriteFromNewWriter() {
        boolean bl = this.startWrite();
        if (!bl) {
            ++this.waitingWriters_;
        }
        return bl;
    }

    synchronized boolean startReadFromWaitingReader() {
        boolean bl = this.startRead();
        if (bl) {
            --this.waitingReaders_;
        }
        return bl;
    }

    synchronized boolean startWriteFromWaitingWriter() {
        boolean bl = this.startWrite();
        if (bl) {
            --this.waitingWriters_;
        }
        return bl;
    }

    synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    synchronized void cancelledWaitingWriter() {
        --this.waitingWriters_;
    }

    boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == 0 || this.activeWriter_ == Thread.currentThread();
    }

    synchronized boolean startRead() {
        Thread thread = Thread.currentThread();
        Object v = this.readers_.get(thread);
        if (v != null) {
            this.readers_.put(thread, new Integer((Integer)v + 1));
            ++this.activeReaders_;
            return true;
        }
        if (this.allowReader()) {
            this.readers_.put(thread, IONE);
            ++this.activeReaders_;
            return true;
        }
        return false;
    }

    synchronized boolean startWrite() {
        if (this.activeWriter_ == Thread.currentThread()) {
            ++this.writeHolds_;
            return true;
        }
        if (this.writeHolds_ == 0) {
            if (this.activeReaders_ == 0 || this.readers_.size() == 1 && this.readers_.get(Thread.currentThread()) != null) {
                this.activeWriter_ = Thread.currentThread();
                this.writeHolds_ = 1;
                return true;
            }
            return false;
        }
        return false;
    }

    synchronized Signaller endRead() {
        Thread thread = Thread.currentThread();
        Object v = this.readers_.get(thread);
        if (v == null) {
            throw new IllegalThreadStateException();
        }
        --this.activeReaders_;
        if (v != IONE) {
            int n2 = (Integer)v - 1;
            Integer n3 = n2 == 1 ? IONE : new Integer(n2);
            this.readers_.put(thread, n3);
            return null;
        }
        this.readers_.remove(thread);
        if (this.writeHolds_ > 0) {
            return null;
        }
        if (this.activeReaders_ == 0 && this.waitingWriters_ > 0) {
            return this.writerLock_;
        }
        return null;
    }

    synchronized Signaller endWrite() {
        if (this.activeWriter_ != Thread.currentThread()) {
            throw new IllegalMonitorStateException();
        }
        --this.writeHolds_;
        if (this.writeHolds_ > 0) {
            return null;
        }
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0 && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0) {
            return this.writerLock_;
        }
        return null;
    }

    public final boolean isFair() {
        return false;
    }

    protected synchronized Thread getOwner() {
        return this.activeWriter_;
    }

    public synchronized int getReadLockCount() {
        return this.activeReaders_;
    }

    public synchronized boolean isWriteLocked() {
        return this.activeWriter_ != null;
    }

    public synchronized boolean isWriteLockedByCurrentThread() {
        return this.activeWriter_ == Thread.currentThread();
    }

    public synchronized int getWriteHoldCount() {
        return this.isWriteLockedByCurrentThread() ? this.writeHolds_ : 0;
    }

    public final synchronized int getQueueLength() {
        return this.waitingWriters_ + this.waitingReaders_;
    }

    public synchronized String toString() {
        return super.toString() + "[Write locks = " + this.getWriteHoldCount() + ", Read locks = " + this.getReadLockCount() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            this.readers_ = new HashMap();
        }
    }

    class WriterLock
    implements Signaller,
    Lock,
    Serializable,
    CondVar.ExclusiveLock {
        WriterLock() {
        }

        public void lock() {
            boolean bl = false;
            while (true) {
                try {
                    this.lockInterruptibly();
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException interruptedException = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                if (!ReentrantReadWriteLock.this.startWriteFromNewWriter()) {
                    try {
                        do {
                            this.wait();
                        } while (!ReentrantReadWriteLock.this.startWriteFromWaitingWriter());
                        return;
                    }
                    catch (InterruptedException interruptedException2) {
                        ReentrantReadWriteLock.this.cancelledWaitingWriter();
                        this.notify();
                        interruptedException = interruptedException2;
                    }
                }
            }
            if (interruptedException != null) {
                ReentrantReadWriteLock.this.readerLock_.signalWaiters();
                throw interruptedException;
            }
        }

        public void unlock() {
            Signaller signaller = ReentrantReadWriteLock.this.endWrite();
            if (signaller != null) {
                signaller.signalWaiters();
            }
        }

        public synchronized void signalWaiters() {
            this.notify();
        }

        public boolean tryLock() {
            return ReentrantReadWriteLock.this.startWrite();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException interruptedException = null;
            long l3 = timeUnit.toNanos(l2);
            WriterLock writerLock = this;
            synchronized (writerLock) {
                block10: {
                    if (l3 <= 0L) {
                        return ReentrantReadWriteLock.this.startWrite();
                    }
                    if (ReentrantReadWriteLock.this.startWriteFromNewWriter()) {
                        return true;
                    }
                    long l4 = Utils.nanoTime() + l3;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, l3);
                        }
                        catch (InterruptedException interruptedException2) {
                            ReentrantReadWriteLock.this.cancelledWaitingWriter();
                            this.notify();
                            interruptedException = interruptedException2;
                            break block10;
                        }
                        if (!ReentrantReadWriteLock.this.startWriteFromWaitingWriter()) continue;
                        return true;
                    } while ((l3 = l4 - Utils.nanoTime()) > 0L);
                    ReentrantReadWriteLock.this.cancelledWaitingWriter();
                    this.notify();
                }
            }
            ReentrantReadWriteLock.this.readerLock_.signalWaiters();
            if (interruptedException != null) {
                throw interruptedException;
            }
            return false;
        }

        public Condition newCondition() {
            return new CondVar(this);
        }

        public String toString() {
            Thread thread = ReentrantReadWriteLock.this.getOwner();
            return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
        }

        public boolean isHeldByCurrentThread() {
            return ReentrantReadWriteLock.this.isWriteLockedByCurrentThread();
        }

        public int getHoldCount() {
            return ReentrantReadWriteLock.this.getWriteHoldCount();
        }
    }

    class ReaderLock
    implements Signaller,
    Lock,
    Serializable {
        ReaderLock() {
        }

        public void lock() {
            boolean bl = false;
            while (true) {
                try {
                    this.lockInterruptibly();
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException interruptedException = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                if (!ReentrantReadWriteLock.this.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!ReentrantReadWriteLock.this.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException interruptedException2) {
                        ReentrantReadWriteLock.this.cancelledWaitingReader();
                        interruptedException = interruptedException2;
                    }
                }
            }
            if (interruptedException != null) {
                ReentrantReadWriteLock.this.writerLock_.signalWaiters();
                throw interruptedException;
            }
        }

        public void unlock() {
            Signaller signaller = ReentrantReadWriteLock.this.endRead();
            if (signaller != null) {
                signaller.signalWaiters();
            }
        }

        public synchronized void signalWaiters() {
            this.notifyAll();
        }

        public boolean tryLock() {
            return ReentrantReadWriteLock.this.startRead();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException interruptedException = null;
            long l3 = timeUnit.toNanos(l2);
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block10: {
                    if (l3 <= 0L) {
                        return ReentrantReadWriteLock.this.startRead();
                    }
                    if (ReentrantReadWriteLock.this.startReadFromNewReader()) {
                        return true;
                    }
                    long l4 = Utils.nanoTime() + l3;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, l3);
                        }
                        catch (InterruptedException interruptedException2) {
                            ReentrantReadWriteLock.this.cancelledWaitingReader();
                            interruptedException = interruptedException2;
                            break block10;
                        }
                        if (!ReentrantReadWriteLock.this.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((l3 = l4 - Utils.nanoTime()) > 0L);
                    ReentrantReadWriteLock.this.cancelledWaitingReader();
                }
            }
            ReentrantReadWriteLock.this.writerLock_.signalWaiters();
            if (interruptedException != null) {
                throw interruptedException;
            }
            return false;
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int n2 = ReentrantReadWriteLock.this.getReadLockCount();
            return super.toString() + "[Read locks = " + n2 + "]";
        }
    }

    static interface Signaller {
        public void signalWaiters();
    }
}

