/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.imrutility.imr.ActivationMode;
import org.jacorb.imrutility.imr.Activator;
import org.jacorb.imrutility.imr.ActivatorHelper;
import org.jacorb.imrutility.imr.AlreadyRegistered;
import org.jacorb.imrutility.imr.ImplActive;
import org.jacorb.imrutility.imr.ImplInfo;
import org.jacorb.imrutility.imr.LoadBalancingPolicy;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.POAInfo;
import org.jacorb.imrutility.imr.RepositoryAdmin;
import org.jacorb.imrutility.imr.RepositoryAdminHelper;
import org.jacorb.imrutility.imr.ServerInfo;
import org.jacorb.imrutility.imr.ServerName;
import org.omg.CORBA.ORB;

public class IMRManager {
    private static ORB orb;
    private static final String[] states;
    private static final String[] policies;
    private static final String[] modes;
    private static RepositoryAdmin rep;
    private static final char[] oks;
    private static final String OBJECT_KEY_SEPARATOR;
    private static final String in_name = "--name";
    private static final String in_poa = "--poa";

    private IMRManager() {
    }

    public static void main(String[] args) {
        System.setProperty("jacorb.implname", "ImRManager");
        orb = ORB.init(args, null);
        if (args.length > 0) {
            if (args[0].equals("-h") || args[0].equals("--help")) {
                IMRManager.usage();
            } else {
                IMRManager.getAdmin();
                for (int i2 = 0; i2 < args.length; ++i2) {
                    if (args[i2].equals("-l") || args[i2].equals("--list")) {
                        IMRManager.list(args);
                    } else if (args[i2].equals("-a") || args[i2].equals("--add")) {
                        IMRManager.addImplementation(args);
                    } else if (args[i2].equals("-r") || args[i2].equals("--remove")) {
                        IMRManager.removeImplementation(args);
                    } else if (args[i2].equals("-d") || args[i2].equals("--deactivate")) {
                        IMRManager.deactivate(args);
                    } else {
                        if (!args[i2].equals("-k") && !args[i2].equals("--shutdown")) continue;
                        IMRManager.shutdown(args);
                    }
                    break;
                }
            }
        } else {
            IMRManager.usage();
        }
    }

    private static void list(String[] args) {
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("-v") || args[i2].equals("--activators")) {
                    try {
                        IMRManager.listActivators(rep.listActivators());
                    }
                    catch (Exception ex) {
                        System.out.println("List activators not yet implemented");
                    }
                    System.exit(0);
                }
                if (args[i2].equals("-s") || args[i2].equals("--server")) {
                    if (i2 < args.length - 1) {
                        try {
                            IMRManager.listPOAs(rep.listPOAs(Long.parseLong(args[++i2])));
                        }
                        catch (NumberFormatException nfe) {
                            System.out.println("Invalid server id - must be numeric");
                        }
                    } else {
                        System.out.println("You must provide the server ID");
                    }
                    System.exit(0);
                    continue;
                }
                if (args[i2].equals("-n") || args[i2].equals(in_name)) {
                    if (i2 < args.length - 1) {
                        ServerName sname = new ServerName();
                        sname.impl(args[++i2]);
                        IMRManager.listServers(rep.listServers(sname));
                    } else {
                        System.out.println("You must provide the server name");
                    }
                    System.exit(0);
                    continue;
                }
                if (!args[i2].equals("-p") && !args[i2].equals(in_poa)) continue;
                System.out.println("This option is not yet implemented");
                System.exit(0);
            }
            IMRManager.listImpls(rep.listAllImpls());
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("Caught an exception trying to perform request");
            ex.printStackTrace();
        }
    }

    private static void listImpls(ImplInfo[] impls) {
        if (impls.length == 0) {
            System.out.println("\nNo implementations recorded");
        } else {
            System.out.println("\nImplementations\n");
            for (int i2 = 0; i2 < impls.length; ++i2) {
                ImplInfo iinfo = impls[i2];
                System.out.println(i2 + 1 + ". " + "Name                : " + IMRManager.getName(iinfo.name));
                System.out.println("   Multiples allowed   : " + IMRManager.getStringValue(iinfo.multiples));
                System.out.println("   LoadBalancingPolicy : " + policies[iinfo.lbPolicy.value()]);
                System.out.println("   Activation Mode     : " + modes[iinfo.activation.value()]);
                System.out.println("\n\n");
            }
        }
    }

    private static void listPOAs(POAInfo[] poas) {
        if (poas.length == 0) {
            System.out.println("\nNo poas recorded");
        } else {
            System.out.println("\nPOAs\n");
            for (int i2 = 0; i2 < poas.length; ++i2) {
                POAInfo pinfo = poas[i2];
                System.out.println(i2 + 1 + ". " + "Name                : " + pinfo.name);
                System.out.println("   LoadBalancingPolicy : " + policies[pinfo.lbPolicy.value()]);
                System.out.println("\n\n");
            }
        }
    }

    private static void listServers(ServerInfo[] servers) {
        if (servers == null || servers.length == 0) {
            System.out.println("\nNo servers recorded");
        } else {
            System.out.println("\nServers\n");
            for (int i2 = 0; i2 < servers.length; ++i2) {
                ServerInfo sinfo = servers[i2];
                String status = states[sinfo.state.value()];
                String loc = orb.object_to_string(sinfo.srv);
                System.out.println("   ID       : " + sinfo.id);
                System.out.println("   Status   : " + status);
                System.out.println("   Location : " + loc);
                System.out.println("\n\n");
            }
        }
    }

    private static void listActivators(ServerInfo[] activators) {
        if (activators != null && activators.length == 0) {
            System.out.println("\nNo activators recorded");
        } else {
            System.out.println("\nActivators\n");
            for (int i2 = 0; i2 < activators.length; ++i2) {
                ServerInfo act = activators[i2];
                String loc = orb.object_to_string(act.srv);
                System.out.println(" ID       : " + act.id);
                System.out.println(" State    : " + states[act.state.value()]);
                System.out.println(" Location : " + loc);
                System.out.println("\n");
            }
        }
    }

    private static void addImplementation(String[] args) {
        String name = null;
        boolean multiple = false;
        LoadBalancingPolicy policy = null;
        Activator act = null;
        String act_ior = null;
        ServerName sname = null;
        ActivationMode mode = null;
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("-n") || args[i2].equals(in_name)) {
                    if (i2 >= args.length - 1) continue;
                    name = args[++i2];
                    continue;
                }
                if (args[i2].equals("-p") || args[i2].equals(in_poa)) {
                    System.out.println("Addition of poa is not yet implemented");
                    System.exit(0);
                    continue;
                }
                if (args[i2].equals("-m") || args[i2].equals("--multiples")) {
                    if (i2 >= args.length - 1 || !args[++i2].equalsIgnoreCase("on")) continue;
                    multiple = true;
                    continue;
                }
                if (args[i2].equals("-l") || args[i2].equals("--lb_policy")) {
                    if (i2 >= args.length - 1) continue;
                    policy = LoadBalancingPolicy.from_int(Integer.parseInt(args[++i2]));
                    continue;
                }
                if (args[i2].equals("-v") || args[i2].equals("--activator")) {
                    if (i2 >= args.length - 1) continue;
                    act_ior = args[++i2];
                    continue;
                }
                if (!args[i2].equals("-e") && !args[i2].equals("--mode") || i2 >= args.length - 1) continue;
                mode = ActivationMode.from_int(Integer.parseInt(args[++i2]));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            IMRManager.usage();
        }
        if (name == null) {
            System.out.println("\nYou must provide a server name\n");
            IMRManager.usage();
        }
        if (policy == null) {
            policy = LoadBalancingPolicy.from_int(0);
        }
        if (mode == null) {
            mode = ActivationMode.from_int(0);
        }
        try {
            sname = IMRManager.getServerName(name);
            if (act_ior != null) {
                act = ActivatorHelper.narrow(orb.string_to_object(act_ior));
            }
            rep.addImpl(new ImplInfo(sname, multiple, policy, mode), act);
            System.out.println(name + " added");
        }
        catch (AlreadyRegistered aa) {
            System.out.println("The implemenation is already registered :: " + aa.name);
        }
        catch (Exception ex) {
            System.out.println("An exception occurred adding " + sname + " :: " + ex.getMessage());
        }
    }

    private static void removeImplementation(String[] args) {
        ServerName sname = null;
        String act_ior = null;
        Activator act = null;
        String name = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-n") || args[i2].equals(in_name)) {
                if (i2 >= args.length - 1) continue;
                name = args[++i2];
                sname = IMRManager.getServerName(name);
                continue;
            }
            if (args[i2].equals("-p") || args[i2].equals(in_poa)) {
                System.out.println("Removal of POA is not yet implemented");
                System.exit(0);
                continue;
            }
            if (!args[i2].equals("-v") && !args[i2].equals("--activator") || i2 >= args.length - 1) continue;
            act_ior = args[++i2];
        }
        if (sname == null) {
            IMRManager.usage();
        }
        try {
            if (act_ior != null) {
                act = ActivatorHelper.narrow(orb.string_to_object(act_ior));
            }
            rep.removeImpl(sname, act);
            System.out.println(name + " removed");
        }
        catch (ImplActive ia) {
            System.out.println("\nYou cannot remove this implementation - it is still active");
        }
        catch (NotFound nf) {
            System.out.println("\nImplemenation not found");
        }
    }

    private static void deactivate(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!args[i2].equals("-s") && !args[i2].equals("--server")) continue;
            if (i2 < args.length - 1) {
                IMRManager.deactivateServer(args[++i2]);
                continue;
            }
            System.out.println("You must provide the Server ID");
        }
    }

    private static void deactivateServer(String id) {
        try {
            Long sID = new Long(id);
            rep.deregisterAll(sID);
            System.out.println("Server id " + id + " deactivated");
        }
        catch (NumberFormatException nfe) {
            System.out.println("Invalid server ID - must be numeric");
        }
        catch (NotFound nf) {
            System.out.println("Server not found for " + id);
        }
    }

    private static void shutdown(String[] args) {
        block17: {
            int i2;
            ServerName sname = null;
            long serverID = 0L;
            ServerInfo[] sinfos = null;
            String name = null;
            boolean killIMR = false;
            for (i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("-n") || args[i2].equals(in_name)) {
                    if (i2 >= args.length - 1) continue;
                    name = args[++i2];
                    sname = IMRManager.getServerName(name);
                    continue;
                }
                if (args[i2].equals("-p") || args[i2].equals(in_poa)) {
                    System.out.println("POA shutdown is not yet implemented");
                    System.exit(0);
                    continue;
                }
                if (args[i2].equals("-s") || args[i2].equals("--server")) {
                    if (i2 >= args.length - 1) continue;
                    serverID = Long.parseLong(args[++i2]);
                    continue;
                }
                if (!args[i2].equals("-i") && !args[i2].equals("--imr")) continue;
                killIMR = true;
            }
            try {
                if (sname != null) {
                    sinfos = rep.listServers(sname);
                    if (sinfos.length == 0) {
                        System.out.println("No servers to shutdown");
                        System.exit(0);
                    } else if (sinfos.length > 1) {
                        if (serverID == 0L) {
                            System.out.println("Multiple servers registered");
                            System.out.println("Please provide server ID");
                            System.exit(0);
                        } else {
                            for (i2 = 0; i2 < sinfos.length; ++i2) {
                                if (serverID != sinfos[i2].id) continue;
                                sinfos[i2].srv.shutdown(false);
                                break;
                            }
                        }
                    } else {
                        serverID = sinfos[0].id;
                        sinfos[0].srv.shutdown(false);
                    }
                    System.out.println("Shutdown server " + name + " ID = " + serverID);
                    break block17;
                }
                if (killIMR) {
                    rep.shutdown(false);
                } else {
                    System.out.println("Please provide the server name");
                }
            }
            catch (Exception ex) {
                System.out.println("Exception shutting down server " + sname);
                System.out.println(ex.getMessage());
            }
        }
    }

    private static void getAdmin() {
        try {
            rep = RepositoryAdminHelper.narrow(orb.resolve_initial_references("ImplementationRepository"));
        }
        catch (Exception ex) {
            System.out.println("Unable to resolve initial reference to the IMR");
            System.out.println("Please supply ORBInitRef.ImplementationRepository value");
            System.exit(0);
        }
    }

    private static String getStringValue(boolean active) {
        if (active) {
            return "on";
        }
        return "off";
    }

    private static String getName(ServerName sname) {
        String name = null;
        String[][] names = null;
        Object pnames = null;
        if (sname.discriminator()) {
            name = sname.impl();
        } else {
            names = sname.poas();
            if (names != null) {
                for (int i2 = 0; i2 < names.length; ++i2) {
                    for (int j2 = 0; j2 < names[i2].length; ++j2) {
                        name = name + OBJECT_KEY_SEPARATOR;
                        name = name + names[i2][j2];
                    }
                }
            }
        }
        return name;
    }

    private static ServerName getServerName(String in_name) {
        StringTokenizer st = new StringTokenizer(in_name, OBJECT_KEY_SEPARATOR);
        String name = null;
        String[][] poas = null;
        Vector<String> vpoas = new Vector<String>();
        ServerName sname = new ServerName();
        if (in_name.startsWith(OBJECT_KEY_SEPARATOR)) {
            while (st.hasMoreTokens()) {
                vpoas.add(st.nextToken());
            }
            String[] ipoas = new String[vpoas.size()];
            for (int i2 = 0; i2 < vpoas.size(); ++i2) {
                ipoas[i2] = (String)vpoas.elementAt(i2);
            }
            poas = new String[1][ipoas.length];
            poas[0] = ipoas;
        } else {
            name = st.nextToken();
        }
        if (name != null) {
            sname.impl(name);
        } else {
            sname.poas(poas);
        }
        return sname;
    }

    private static void usage() {
        String separator = "---------------------------------------------------------";
        String poaNYI = " [ -p  | --poa ] <poa name> Not yet implemented          ";
        System.out.println(separator);
        System.out.println("Use this tool to interrogate the Implementation Repository");
        System.out.println("or to pre-register/remove servers.                       ");
        System.out.println("Valid options are as follows:                            ");
        System.out.println();
        System.out.println(" [ -l | --list ]            Lists all registered         ");
        System.out.println("                            implementations              ");
        System.out.println();
        System.out.println("The following options can be used with -l or --list      ");
        System.out.println();
        System.out.println(" [ -n | --name ] <name>     Lists all servers registered ");
        System.out.println("                            for a given implementation   ");
        System.out.println();
        System.out.println(" [ -s  | --server ] <server id> Lists all poas for a given ");
        System.out.println("                              server using the server id   ");
        System.out.println();
        System.out.println(poaNYI);
        System.out.println();
        System.out.println(" [ -v  | --activators ]     Lists all Activators known to");
        System.out.println("                            the ImR                      ");
        System.out.println(separator);
        System.out.println("To add or remove servers use the following commands.     ");
        System.out.println();
        System.out.println("   [ -a | --add ]        Adds implementation details     ");
        System.out.println();
        System.out.println("The following options can be used with -a or --add       ");
        System.out.println();
        System.out.println(" [ -n | --name ] <name>     The server name (mandatory)  ");
        System.out.println();
        System.out.println(poaNYI);
        System.out.println();
        System.out.println(" [ -m | --multiples ] <ON/OFF>                           ");
        System.out.println("                         whether multiple servers are allowed ");
        System.out.println("                          - if not provided the default of OFF");
        System.out.println("                            is used                           ");
        System.out.println();
        System.out.println(" [ -l | --lb_policy ] <int>                              ");
        System.out.println("                         the load balancing policy to be applied");
        System.out.println();
        System.out.println("                           Possible values               ");
        System.out.println();
        System.out.println("                             0 = Random                  ");
        System.out.println("                             1 = Round Robin             ");
        System.out.println("                             2 = FIFO                    ");
        System.out.println("                             3 = LIFO                    ");
        System.out.println("                                                         ");
        System.out.println("                         - if not provided the default of");
        System.out.println("                           Random is used if multiples   ");
        System.out.println("                           allowed                       ");
        System.out.println();
        System.out.println(" [ -v | --act_ior ] <ior>                                ");
        System.out.println("                         the IOR of the Activator to be  ");
        System.out.println("                         used for this server if         ");
        System.out.println("                         auto-activation is allowed      ");
        System.out.println("");
        System.out.println(" [ -e | --mode ] <mode>  the activation mode to be applied ");
        System.out.println();
        System.out.println("                             0 = NORMAL                    ");
        System.out.println("                             1 = MANUAL                    ");
        System.out.println("                             2 = PER_CLIENT                ");
        System.out.println("                             3 = AUTO_START                ");
        System.out.println();
        System.out.println("                          the default of 0 is used if this ");
        System.out.println("                          parameter is not provided        ");
        System.out.println();
        System.out.println(separator);
        System.out.println(" [ -r | --remove ]                                       ");
        System.out.println();
        System.out.println(" [ -n | --name ] <name>  Removes all servers from the    ");
        System.out.println("                         repository for the given name   ");
        System.out.println("                         Name is the name of the server to");
        System.out.println("                         be removed.                     ");
        System.out.println();
        System.out.println(poaNYI);
        System.out.println(separator);
        System.out.println(" [ -d | --deactivate ] [ -s | --server ] <server id>     ");
        System.out.println("                         Forces the server with the given");
        System.out.println("                         id to be deactivated.           ");
        System.out.println(separator);
        System.out.println(" [ -k| --shutdown ]                                      ");
        System.out.println();
        System.out.println(" [ -n | --name ] <name>  The implementation name under   ");
        System.out.println("                         which the server to be shutdown ");
        System.out.println("                         is registered (mandatory).      ");
        System.out.println();
        System.out.println(poaNYI);
        System.out.println("");
        System.out.println(" <-s | --server>         The server ID of the server,");
        System.out.println("                         This must be provided if        ");
        System.out.println("                         multiple servers are registered ");
        System.out.println();
        System.out.println(" <-i | --imr>            Remotely shutdown the IMR process.");
        System.out.println(separator);
        System.out.println(" [ -h | --help ]         Displays this help              ");
        System.out.println(separator);
        System.exit(0);
    }

    static {
        states = new String[]{"ACTIVE", "INACTIVE", "UNKNOWN"};
        policies = new String[]{"Random", "RoundRobin", "FIFO", "LIFO"};
        modes = new String[]{"NORMAL", "MANUAL", "PER_CLIENT", "AUTO_START"};
        rep = null;
        oks = new char[]{'/'};
        OBJECT_KEY_SEPARATOR = String.valueOf(oks);
    }
}

