/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.io.OutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;

class IIOPLoopbackOutputStream
extends OutputStream {
    private IIOPLoopbackInputStream lis;

    public IIOPLoopbackOutputStream() {
    }

    public IIOPLoopbackOutputStream(IIOPLoopbackInputStream lis) throws IOException {
        this();
        lis.connect(this);
    }

    public synchronized void write(byte[] b2, int off, int len) throws IOException {
        this.checkConnect();
        this.lis.writeIntoBuffer(b2, off, len);
    }

    public synchronized void write(int b2) throws IOException {
        this.checkConnect();
        this.lis.writeIntoBuffer(b2);
    }

    public synchronized void close() throws IOException {
        this.checkConnect();
        this.lis.writerClose();
    }

    synchronized void connect(IIOPLoopbackInputStream lis) throws IOException {
        this.lis = lis;
    }

    private void checkConnect() throws IOException {
        if (this.lis == null) {
            throw new IOException("IIOPLoopbackOutputStream not connected");
        }
    }
}

