/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;

public class SSLServerSocketFactory
extends SSLRandom
implements ServerSocketFactory,
Configurable {
    private javax.net.ServerSocketFactory factory = null;
    private boolean require_mutual_auth = false;
    private boolean request_mutual_auth = false;
    private boolean trusteesFromKS = false;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private String keystore_type = null;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    private String keystore_provider = null;
    private String keystore_provider_impl = null;
    private String truststore_type = null;
    private String truststore_location = null;
    private String truststore_passphrase = null;
    private String truststore_provider = null;
    private String truststore_provider_impl = null;
    private String jsseProvider = null;
    private String jsseProviderImpl = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration config;
        block10: {
            super.configure(configuration);
            config = (org.jacorb.config.Configuration)configuration;
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.serverSupportedOptions = (short)config.getAttributeAsInteger("jacorb.security.ssl.server.supported_options", 32, 16);
            this.serverRequiredOptions = (short)config.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 0, 16);
            if ((this.serverSupportedOptions & 0x40) != 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will create SSL sockets that request client authentication");
                }
                this.request_mutual_auth = true;
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                this.require_mutual_auth = true;
                this.request_mutual_auth = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will create SSL sockets that require client authentication");
                }
            }
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password");
            this.keystore_type = configuration.getAttribute("jacorb.security.keystore_type", "JKS");
            this.keyManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.server.key_manager_algorithm", "SunX509");
            this.trustManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.server.trust_manager_algorithm", "SunX509");
            this.keystore_provider = configuration.getAttribute("jacorb.security.keystore_provider", null);
            this.keystore_provider_impl = configuration.getAttribute("jacorb.security.keystore_provider_impl", null);
            this.truststore_type = configuration.getAttribute("jacorb.security.truststore_type", null);
            this.truststore_location = configuration.getAttribute("jacorb.security.truststore", null);
            this.truststore_passphrase = configuration.getAttribute("jacorb.security.truststore_password", null);
            this.truststore_provider = configuration.getAttribute("jacorb.security.truststore_provider", null);
            this.truststore_provider_impl = configuration.getAttribute("jacorb.security.truststore_provider_impl", null);
            this.jsseProvider = configuration.getAttribute("jacorb.security.jsse.provider", null);
            this.jsseProviderImpl = configuration.getAttribute("jacorb.security.jsse.provider_impl", null);
            try {
                this.trustManager = (TrustManager)((org.jacorb.config.Configuration)configuration).getAttributeAsObject("jacorb.security.ssl.server.trust_manager");
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isErrorEnabled()) break block10;
                this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.server.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.server.trust_manager", ""), ce);
            }
        }
        if (config.getAttribute("jacorb.security.ssl.server.protocols", null) != null) {
            this.enabledProtocols = config.getAttributeAsStringsArray("jacorb.security.ssl.server.protocols");
            if (this.enabledProtocols != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified server enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.server.protocols", ""));
            }
        }
        try {
            this.factory = this.createServerSocketFactory();
        }
        catch (Exception e2) {
            this.logger.warn("Unable to create ServerSocketFactory", e2);
            throw new ConfigurationException("Unable to create ServerSocketFactory!", e2);
        }
        this.cipher_suites = config.getAttributeAsStringsArray("jacorb.security.ssl.server.cipher_suites");
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket s2 = (SSLServerSocket)this.factory.createServerSocket(port);
        if (this.request_mutual_auth) {
            s2.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s2.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s2.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s2.setEnabledProtocols(this.enabledProtocols);
        }
        return s2;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket s2 = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        if (this.request_mutual_auth) {
            s2.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s2.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s2.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s2.setEnabledProtocols(this.enabledProtocols);
        }
        return s2;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket s2 = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        if (this.request_mutual_auth) {
            s2.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s2.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s2.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s2.setEnabledProtocols(this.enabledProtocols);
        }
        return s2;
    }

    public boolean isSSL(ServerSocket s2) {
        return s2 instanceof SSLServerSocket;
    }

    private javax.net.ServerSocketFactory createServerSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        KeyStore key_store = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray(), this.keystore_type, this.keystore_provider, this.keystore_provider_impl);
        KeyManagerFactory kmf = null;
        if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
            KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
            kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm, this.jsseProvider);
        } else {
            kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
        }
        if ("WINDOWS-MY".equalsIgnoreCase(this.keystore_type)) {
            kmf.init(key_store, null);
        } else {
            kmf.init(key_store, this.keystore_passphrase.toCharArray());
        }
        TrustManagerFactory tmf = null;
        KeyStore trust_store = null;
        if ((this.serverRequiredOptions & 0x40) != 0 || (this.serverSupportedOptions & 0x40) != 0) {
            if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm, this.jsseProvider);
            } else {
                tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            }
            if (this.trusteesFromKS) {
                trust_store = key_store;
            } else {
                trust_store = this.truststore_provider != null && this.truststore_provider.length() > 0 ? KeyStore.getInstance(this.truststore_type, this.truststore_provider) : KeyStore.getInstance(this.truststore_type);
                if ("PKCS11".equalsIgnoreCase(this.truststore_type)) {
                    trust_store.load(null, this.truststore_passphrase.toCharArray());
                } else if ("WINDOWS-ROOT".equalsIgnoreCase(this.truststore_type)) {
                    trust_store.load(null, null);
                } else if (this.truststore_location != null && this.truststore_passphrase != null) {
                    trust_store = KeyStoreUtil.getKeyStore(this.truststore_location, this.truststore_passphrase.toCharArray(), this.truststore_type, this.truststore_provider, this.truststore_provider_impl);
                }
                this.logger.debug("SSLServerSocketFactory: loaded trust store: " + (trust_store == null ? "default (null)" : trust_store.getProvider().toString()));
            }
            tmf.init(trust_store);
        }
        if (this.trustManager == null) {
            trustManagers = tmf == null ? null : tmf.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{this.trustManager};
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified server TrustManger : " + this.trustManager.getClass().toString());
            }
        }
        SSLContext ctx = null;
        if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
            KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
            ctx = SSLContext.getInstance("TLS", this.jsseProvider);
        } else {
            ctx = SSLContext.getInstance("TLS");
        }
        ctx.init(kmf.getKeyManagers(), trustManagers, this.getSecureRandom());
        return ctx.getServerSocketFactory();
    }
}

