/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl;

import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.LicenseManager;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh2.Ssh2Context;
import com.sshtools.net.SocketTransport;
import java.io.IOException;
import se.ericsson.cello.emt.sshsftpservice.config.ifc.Configuration;
import se.ericsson.cello.emt.sshsftpservice.credential.ifc.SlsCredentialsSupplier;
import se.ericsson.cello.emt.sshsftpservice.credential.ifc.UserCredentials;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.cello.emt.sshsftpservice.factory.impl.TheFactory;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.ifc.Connection;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl.EmKnownHostsKeyVerification;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl.X509AuthenticationClient;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.utils.EmLogger;

public class Connector
implements Connection {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String SSH_FAILURE = "Can not setup SSH.";
    private static final String NOT_AUTHENTICATED = "Authentication using %s towards host %s not possible.";
    private static final String CONNECTION_RESULT = "%s using %s to connect to: %s";
    private static final String SUCCESSFUL = "Success";
    private static final String UNSUCCESSFUL = "Unsuccess";
    private static final String CERTIFICATE = "certificate";
    private static final String USER_CREDENTIALS = "user credentials";
    private static final String CERTIFICATE_OR_USER_CREDENTIALS = "certificate or user credentials";
    private Configuration config;
    private String callingApplicationName;

    public Connector(Configuration config, String callingApplicationTitle) {
        this.config = config;
        this.callingApplicationName = callingApplicationTitle;
        this.setupMaverickLicense();
    }

    public SshClient connect() throws EmSshLoginException {
        SshClient sshClient = null;
        String host = this.config.getHost();
        try {
            sshClient = this.connectWithCertificate(host);
            if (sshClient != null) {
                LOG.info(String.format(CONNECTION_RESULT, SUCCESSFUL, CERTIFICATE, host), new Object[0]);
            }
        }
        catch (EmSshLoginException e) {
            LOG.info(String.format(CONNECTION_RESULT, UNSUCCESSFUL, CERTIFICATE, host), new Object[0]);
        }
        if (sshClient == null) {
            try {
                sshClient = this.connectWithCredentials(host);
                if (sshClient != null) {
                    LOG.info(String.format(CONNECTION_RESULT, SUCCESSFUL, USER_CREDENTIALS, host), new Object[0]);
                }
            }
            catch (EmSshLoginException e) {
                LOG.severe(String.format(CONNECTION_RESULT, UNSUCCESSFUL, USER_CREDENTIALS, host), new Object[0]);
                throw e;
            }
        }
        if (sshClient == null) {
            String msg = String.format(CONNECTION_RESULT, UNSUCCESSFUL, CERTIFICATE_OR_USER_CREDENTIALS, host);
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg);
        }
        return sshClient;
    }

    private SshClient connectWithCertificate(String host) throws EmSshLoginException {
        SshClient sshClient;
        try {
            SlsCredentialsSupplier slsCredentialsSupplier = TheFactory.getFactory().getSlsCredentialsSupplier();
            Credentials credentials = slsCredentialsSupplier.getCredentials(this.callingApplicationName);
            X509AuthenticationClient x509auth = new X509AuthenticationClient(credentials, true);
            sshClient = this.getSshClient(x509auth.getUsername(), host);
            if (sshClient != null && sshClient.authenticate((SshAuthentication)x509auth) != 1) {
                String msg = String.format(NOT_AUTHENTICATED, CERTIFICATE, host);
                LOG.severe(msg, new Object[0]);
                sshClient.disconnect();
                throw new EmSshLoginException(msg);
            }
        }
        catch (SshException e) {
            String msg = SSH_FAILURE;
            LOG.severe(msg, new Object[0]);
            throw new EmSshLoginException(msg, e);
        }
        catch (IOException e) {
            String msg = SSH_FAILURE;
            LOG.severe(msg, new Object[0]);
            throw new EmSshLoginException(msg, e);
        }
        return sshClient;
    }

    private SshClient connectWithCredentials(String host) throws EmSshLoginException {
        SshClient sshClient;
        UserCredentials userCredentials = TheFactory.getUserCredentialsSupplier().getUserCredentials(this.callingApplicationName);
        String userName = userCredentials.getName().toString();
        try {
            sshClient = this.getSshClient(userName, host);
            PasswordAuthentication pwdAuth = new PasswordAuthentication();
            pwdAuth.setUsername(userName);
            pwdAuth.setPassword(new String(userCredentials.getPassword()));
            if (sshClient != null && sshClient.authenticate((SshAuthentication)pwdAuth) != 1) {
                String msg = String.format(NOT_AUTHENTICATED, USER_CREDENTIALS, host);
                LOG.severe(msg, new Object[0]);
                throw new EmSshLoginException(msg);
            }
        }
        catch (SshException e) {
            String msg = SSH_FAILURE;
            LOG.severe(msg, new Object[0]);
            throw new EmSshLoginException(msg, e);
        }
        catch (IOException e) {
            String msg = SSH_FAILURE;
            LOG.severe(msg, new Object[0]);
            throw new EmSshLoginException(msg, e);
        }
        finally {
            if (userCredentials != null) {
                userCredentials.erase();
            }
        }
        return sshClient;
    }

    private void setupMaverickLicense() {
        StringBuilder strB = new StringBuilder();
        strB.append("----BEGIN 3SP LICENSE----\r\n");
        strB.append("Product : J2SSH Maverick\r\n");
        strB.append("Licensee: Ericsson\r\n");
        strB.append("Comments: Uncategorised Project\r\n");
        strB.append("Type    : Professional License\r\n");
        strB.append("Created : 28-May-2013\r\n\r\n");
        strB.append("37872037AC2627DBA600F3CF9CCEF4C8126653D20EE0EE14\r\n");
        strB.append("4D94979AB4F6D5E785DB999E5414C8218D85B8386ADC8A75\r\n");
        strB.append("31EB3B20481F8E9557F84899DBD389F8F80563943141396E\r\n");
        strB.append("0AAA8F0EBC2910F669CFDE0069BB5DE49F40FDF3E511910C\r\n");
        strB.append("CBCE0453997D036F2A27752EF7FD81D5E2D38B43DF42E01D\r\n");
        strB.append("4C2AF915AB97B31867A2BC504BAAA550CD0F0CBE346FD462\r\n");
        strB.append("----END 3SP LICENSE----\r\n");
        LicenseManager.addLicense((String)strB.toString());
    }

    private SshClient getSshClient(String userName, String host) throws SshException, IOException {
        SshConnector sshConnnector = SshConnector.getInstance();
        Ssh2Context ssh2Context = (Ssh2Context)sshConnnector.getContext(2);
        ssh2Context.setHostKeyVerification((HostKeyVerification)new EmKnownHostsKeyVerification(host));
        ssh2Context.setPreferredPublicKey("ssh-rsa");
        ssh2Context.setPreferredCipherCS("aes128-cbc");
        ssh2Context.setPreferredCipherSC("aes128-cbc");
        SocketTransport socket = new SocketTransport(host, this.config.getConnectionPort());
        int defaultTimeoutInMs = 1200000;
        socket.setSoTimeout(defaultTimeoutInMs);
        socket.setTcpNoDelay(true);
        return sshConnnector.connect((SshTransport)socket, userName, true);
    }
}

