/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.utils.impl;

public class SshBuf {
    private static final int INITIAL_SIZE = 1024;
    private byte[] buf = new byte[1024];
    private int size;

    public SshBuf() {
        this.size = 0;
    }

    public SshBuf(byte[] bytes) {
        this.append(bytes);
    }

    public void appendBytes(byte[] bytes) {
        this.append(bytes);
    }

    public void putBoolean(boolean flag) {
        if (flag) {
            this.putByte((byte)1);
        } else {
            this.putByte((byte)0);
        }
    }

    public void putUint32(int uint) {
        byte[] arr = new byte[]{(byte)(uint >> 24 & 0xFF), (byte)(uint >> 16 & 0xFF), (byte)(uint >> 8 & 0xFF), (byte)(uint & 0xFF)};
        this.append(arr);
    }

    public void putString(byte[] bytes) {
        this.putUint32(bytes.length);
        this.append(bytes);
    }

    public void putString(String str) {
        if (str != null) {
            byte[] bytes;
            try {
                bytes = str.getBytes("UTF-8");
            }
            catch (Exception e) {
                return;
            }
            this.putString(bytes);
        }
    }

    public void putByte(byte b) {
        byte[] ba = new byte[]{b};
        this.append(ba);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            ret[i] = this.buf[i];
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("---------------------------------------------------------\n");
        sb.append("Dumping " + this.size + " bytes held in buffer:\n");
        sb.append("---------------------------------------------------------\n");
        int i = 0;
        String address = "";
        String[] hex = new String[]{"", "", "", ""};
        byte[] ascii = new byte[16];
        while (i < this.size) {
            if (i % 16 == 0) {
                address = String.format("%04x", i);
            }
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    int byteValue = this.buf[i++];
                    hex[x] = hex[x] + String.format("%02x", (byte)byteValue);
                    if (byteValue < 33) {
                        byteValue = 46;
                    }
                    ascii[x * 4 + y] = byteValue;
                }
            }
            sb.append(String.format("%s: %s %s %s %s    %s\n", address, hex[0], hex[1], hex[2], hex[3], new String(ascii)));
            hex[3] = "";
            hex[2] = "";
            hex[1] = "";
            hex[0] = "";
        }
        return sb.toString();
    }

    private void append(byte[] bytes) {
        this.extendIfItDoesntFit(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            this.buf[this.size++] = bytes[i];
        }
    }

    private void extendIfItDoesntFit(int wanted) {
        if (wanted > this.available()) {
            int need = wanted - this.available();
            need = need / 1024 * 1024 + 1024;
            this.extend(need);
        }
    }

    private int available() {
        return this.buf.length - this.size;
    }

    private void extend(int size) {
        byte[] newBuf = new byte[this.buf.length + size];
        for (int i = 0; i < this.buf.length; ++i) {
            newBuf[i] = this.buf[i];
        }
        this.buf = newBuf;
    }
}

