/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.emt.logservices.toolservice;

import java.awt.Image;
import java.util.Properties;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.emt.logservices.toolservice.Configuration;

public class ParameterHandler
implements Configuration {
    static final String TITLE_KEY = "CUSTOM_APPL_NAME";
    static final String ICON_KEY = "TOOL_ICON";
    static final String DEFAULT_TITLE = "EM Trace Log";
    static final String HELP_APPLICATION_KEY = "HELPSERVICE_CONFIG";
    static final String SELECTED_LOG = "LOG_NAME";
    public static final String MANAGER_TITLE_KEY = "MANAGER_TITLE";
    public static final String DEFAULT_MANAGER_TITLE = "CPP Element Manager";
    private String title;
    private Image iconImage = null;
    private String iconToPassOn = null;
    private String helpApplication;
    private String selectedLog;
    private Properties props;
    static final String KEY_DELIMITER = ";";
    public static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";

    public ParameterHandler(Properties arguments) {
        this.props = arguments;
        this.parse();
    }

    public void parse() {
        this.iconToPassOn = this.props.getProperty(ICON_KEY);
        this.title = this.props.getProperty(MANAGER_TITLE_KEY, DEFAULT_MANAGER_TITLE) + " - " + this.props.getProperty(TITLE_KEY, DEFAULT_TITLE);
        this.helpApplication = this.props.getProperty(HELP_APPLICATION_KEY);
        this.selectedLog = this.props.getProperty(SELECTED_LOG);
        IconHelper helper = new IconHelper();
        this.iconImage = helper.getIconImage(this.iconToPassOn);
    }

    public String getTitle() {
        return this.title;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public String getIconToPassOn() {
        return this.iconToPassOn;
    }

    public String getSelectedLog() {
        return this.selectedLog;
    }

    public String getHelpApplication() {
        return this.helpApplication;
    }

    public Properties getSupersedingProperties() {
        Properties tempProp = new Properties();
        String strSupersedingList = this.props.getProperty(SUPERSEDING_PARAMETER_LIST);
        if (strSupersedingList != null) {
            tempProp.put(SUPERSEDING_PARAMETER_LIST, strSupersedingList);
            String[] supersedingListArray = strSupersedingList.split(KEY_DELIMITER);
            for (int i = 0; i < supersedingListArray.length; ++i) {
                String supersedingName = supersedingListArray[i];
                String supersedingValue = this.props.getProperty(supersedingName);
                if (null == supersedingValue) continue;
                tempProp.put(supersedingName, supersedingValue);
            }
        }
        return tempProp;
    }
}

