/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomRangeImpl;
import se.ericsson.cello.mimparser.state.DefaultSettable;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MultiplicationFactorSettable;
import se.ericsson.cello.mimparser.state.ResolutionSettable;
import se.ericsson.cello.mimparser.state.UnitSettable;

public class MomCorbaTypeAttributeImpl
extends MomBase
implements MomCorbaTypeAttribute,
MaxMinSettable,
DefaultSettable,
UnitSettable,
MultiplicationFactorSettable,
ResolutionSettable {
    private static final String EMPTY_STRING = "";
    private static final String NULL = "null";
    private static final String DEFAULT_VALUE = "defaultValue: ";
    private static final String DATA_TYPE = "dataType: ";
    private static final String NEWLINE = "\n";
    private static final String RESOLUTION = "resolution: ";
    private static final String MULTIPLICATION_FACTOR = "multiplicationFactor: ";
    private static final String UNIT = "unit: ";
    private static final String VALID_VALUES = "validValues";
    private static final String MIN_VALUE_RANGE = "min: ";
    private static final String MAX_VALUE_RANGE = "max: ";
    private String javaType;
    private String validValues;
    private String unit;
    private String multiplicationFactor;
    private String resolution;
    private String parentName;
    private String defaultRawData;
    private List momRanges = new ArrayList(0);
    private Object myDefaultValue;
    private MomRangeImpl currentMomRange;

    public MomCorbaTypeAttributeImpl(String xmlType, String parentName, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
        this.parentName = parentName;
        this.javaType = this.convertToJavaType(xmlType);
    }

    public Iterator getRanges() {
        return this.momRanges.iterator();
    }

    public String getDefaultRawData() {
        return this.defaultRawData;
    }

    public String getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String validValues) {
        this.validValues = validValues;
    }

    public String getType() {
        return this.javaType;
    }

    public void addMinValue(String minValue) {
        this.currentMomRange = new MomRangeImpl();
        Number min = this.convertToNumber(minValue);
        this.currentMomRange.setMin(min);
        this.currentMomRange.setMinRawData(minValue);
        this.momRanges.add(this.currentMomRange);
    }

    public void addMaxValue(String maxValue) {
        MomRangeImpl tmpRange = this.currentMomRange;
        boolean currentMomRangeExisted = true;
        if (this.currentMomRange == null) {
            currentMomRangeExisted = false;
            tmpRange = new MomRangeImpl();
        }
        Number max = this.convertToNumber(maxValue);
        tmpRange.setMax(max);
        tmpRange.setMaxRawData(maxValue);
        if (!currentMomRangeExisted) {
            this.momRanges.add(tmpRange);
        }
        this.currentMomRange = null;
    }

    public void setDefault(String defaultValue) {
        this.defaultRawData = defaultValue;
        this.myDefaultValue = this.convertToJavaObject(defaultValue);
    }

    public Object getDefault() {
        return this.myDefaultValue;
    }

    private Number convertToNumber(String value) {
        Number convertedValue = null;
        try {
            value = value.trim();
            if (this.getXmlType().equals("double")) {
                convertedValue = new Double(value);
            } else if (this.getXmlType().equals("float")) {
                convertedValue = new Float(value);
            } else if (this.getXmlType().equals("longlong")) {
                convertedValue = new Long(value);
            } else {
                if (value.startsWith("+")) {
                    value = value.substring(1);
                }
                convertedValue = new Integer(value);
            }
            return convertedValue;
        }
        catch (Exception exc) {
            String errMsg = "MomCorbaTypeAttributeImpl.convertToNumber()  Can not convert String to Number for name = " + this.getName() + " xml type=" + this.getXmlType() + "  value_to_convert=" + value + "  Exception=" + exc.toString();
            this.getModel().addToWarningList(errMsg);
            return convertedValue;
        }
    }

    private Object convertToJavaObject(String value) {
        try {
            if (!this.getXmlType().equals("string") && !this.getXmlType().equals("wstring")) {
                if (value.length() < 1) {
                    return null;
                }
                if ((value = value.trim()).length() < 1) {
                    return null;
                }
            }
            Object convertedValue = value;
            if (this.getXmlType().equals("boolean")) {
                convertedValue = new Boolean(value);
            } else if (this.getXmlType().equals("octet")) {
                convertedValue = new Byte(value);
            } else if (this.getXmlType().equals("char")) {
                char c = value.charAt(0);
                convertedValue = new Character(c);
            } else if (this.getXmlType().equals("double")) {
                convertedValue = new Double(value);
            } else if (this.getXmlType().equals("float")) {
                convertedValue = new Float(value);
            } else if (this.getXmlType().equals("long")) {
                convertedValue = new Integer(value);
            } else if (this.getXmlType().equals("longlong")) {
                convertedValue = new Long(value);
            } else if (this.getXmlType().equals("short")) {
                convertedValue = new Short(value);
            }
            return convertedValue;
        }
        catch (Exception exc) {
            String errMsg = "MomCorbaTypeAttributeImpl.convertToJavaObject()  Can not convert String to Java Object for name = " + this.parentName + " xml type=" + this.getXmlType() + "  value_to_convert=" + value + "  Exception=" + exc.toString();
            this.defaultRawData = value;
            this.getModel().addToWarningList(errMsg);
            return null;
        }
    }

    private String convertToJavaType(String corbaType) {
        String convertedType = null;
        if (this.getXmlType().equals("boolean")) {
            convertedType = "Boolean";
        } else if (this.getXmlType().equals("octet")) {
            convertedType = "Byte";
        } else if (this.getXmlType().equals("char")) {
            convertedType = "Character";
        } else if (this.getXmlType().equals("double")) {
            convertedType = "Double";
        } else if (this.getXmlType().equals("float")) {
            convertedType = "Float";
        } else if (this.getXmlType().equals("long")) {
            convertedType = "Integer";
        } else if (this.getXmlType().equals("longlong")) {
            convertedType = "Long";
        } else if (this.getXmlType().equals("short")) {
            convertedType = "Short";
        } else if (this.getXmlType().equals("string")) {
            convertedType = "String";
        } else if (this.getXmlType().equals("wstring")) {
            convertedType = "String";
        } else {
            String errorMsg = "MomCorbaTypeAttributeImpl.convertToJavaType()  Can not convert corba Type to java type for element:" + this.parentName + " corba type=" + corbaType + " reason: Unknown corbaType";
            this.getModel().addToWarningList(errorMsg);
            this.defaultRawData = corbaType;
        }
        return convertedType;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getMultiplicationFactor() {
        return this.multiplicationFactor;
    }

    public void setMultiplicationFactor(String multiplicationFactor) {
        this.multiplicationFactor = multiplicationFactor;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DATA_TYPE + this.getXmlType() + NEWLINE);
        String defaultValues = this.appendDefaultValues(this);
        if (this.getUnit() != null) {
            stringBuffer.append(UNIT + this.getUnit() + NEWLINE);
        }
        if (this.getMultiplicationFactor() != null) {
            stringBuffer.append(MULTIPLICATION_FACTOR + this.getMultiplicationFactor() + NEWLINE);
        }
        if (this.getResolution() != null) {
            stringBuffer.append(RESOLUTION + this.getResolution() + NEWLINE);
        }
        if (!defaultValues.equalsIgnoreCase(NULL) && !defaultValues.equalsIgnoreCase(EMPTY_STRING)) {
            stringBuffer.append(DEFAULT_VALUE + defaultValues + NEWLINE);
        }
        if (this.getValidValues() != null) {
            stringBuffer.append(VALID_VALUES + this.getValidValues() + NEWLINE);
        }
        Iterator iter = this.getRanges();
        while (iter.hasNext()) {
            MomRangeImpl momRange = (MomRangeImpl)iter.next();
            stringBuffer.append(MIN_VALUE_RANGE + momRange.getMinRawData() + "\t");
            stringBuffer.append(MAX_VALUE_RANGE + momRange.getMaxRawData() + NEWLINE);
        }
        return stringBuffer.toString();
    }
}

