/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.state.DependenciesScriptSettable;
import se.ericsson.cello.mimparser.state.DependenciesSettable;
import se.ericsson.cello.mimparser.state.DeprecatedSettable;
import se.ericsson.cello.mimparser.state.DisturbancesSettable;
import se.ericsson.cello.mimparser.state.FeatureSettable;
import se.ericsson.cello.mimparser.state.FilterSettable;
import se.ericsson.cello.mimparser.state.ObsoleteSettable;
import se.ericsson.cello.mimparser.state.PreConditionSettable;
import se.ericsson.cello.mimparser.state.SideEffectsSettable;
import se.ericsson.cello.mimparser.state.SpecificationSettable;
import se.ericsson.cello.mimparser.state.TakesEffectSettable;
import se.ericsson.cello.mimparser.state.VisibilitySettable;

public class MomEnumMemberImpl
extends MomBase
implements MomEnumMember,
DeprecatedSettable,
DisturbancesSettable,
TakesEffectSettable,
SideEffectsSettable,
PreConditionSettable,
ObsoleteSettable,
VisibilitySettable,
FilterSettable,
DependenciesSettable,
DependenciesScriptSettable,
FeatureSettable,
SpecificationSettable {
    private Integer value;
    private static final String TRUE = "true";
    private static final String DISTURBANCES = "disturbances: ";
    private static final String DEPRECATED = "deprecated: ";
    private static final String TAKES_EFFECT = "takesEffect: ";
    private static final String SIDE_EFFECTS = "sideEffects: ";
    private static final String PRECONDITION = "precondition: ";
    private static final String OBSOLETE = "obsolete: ";
    private static final String VISIBILITY = "visibility: ";
    private static final String FILTER = "filter: ";
    private static final String DEPENDENCIES = "dependencies: ";
    private static final String DEPENDENCIES_SCRIPT = "dependenciesScript: ";
    private static final String FEATURE = "feature: ";
    private static final String SPECIFICATION = "specification: ";
    private static final String INTERFACE_ONLY = "interfaceOnly: ";
    private static final String VALUE = "value";
    private static final String APPLICATION_TAG = "applicationTag: ";
    private static final String NEW_LINE = "\n";
    private DomainExtension domainExtension;
    private String deprecated = null;
    private String disturbances;
    private String takesEffect;
    private String sideEffects;
    private String precondition;
    private String obsolete;
    private String visibility;
    private String filter;
    private String dependencies;
    private String dependenciesScript;
    private String feature;
    private String specification;
    private String interfaceOnly;

    public MomEnumMemberImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = this.convertToInteger(value);
    }

    private Integer convertToInteger(String value) {
        Integer convertedValue = null;
        try {
            convertedValue = new Integer(value);
            return convertedValue;
        }
        catch (Exception exc) {
            String errMsg = "MomEnumMemberImpl.convertToInteger()  Can not convert String to Integer for element:" + this.getName() + " String=" + value + "  Exception=" + exc.toString();
            this.getModel().addToWarningList(errMsg);
            return null;
        }
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtension) {
        this.domainExtension = domainExtension;
    }

    public String getDisturbances() {
        return this.disturbances;
    }

    public void setDisturbances(String disturbances) {
        this.disturbances = disturbances;
    }

    public void setTakesEffect(String takesEffect) {
        this.takesEffect = takesEffect;
    }

    public String getTakesEffect() {
        return this.takesEffect;
    }

    public void setSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public void setPreCondition(String precondition) {
        this.precondition = precondition;
    }

    public String getPreCondition() {
        return this.precondition;
    }

    public void setObsolete(String obsolete) {
        this.obsolete = obsolete;
    }

    public String getObsolete() {
        return this.obsolete;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setDependencies(String dependencies) {
        this.dependencies = dependencies;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    public void setDependenciesScript(String dependenciesScript) {
        this.dependenciesScript = dependenciesScript;
    }

    public String getDependenciesScript() {
        return this.dependenciesScript;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setInterfaceOnly() {
        this.interfaceOnly = TRUE;
    }

    public boolean isInterfaceOnly() {
        return TRUE.equals(this.interfaceOnly);
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDeprecated() != null) {
            stringBuffer.append(DEPRECATED + this.getDeprecated() + NEW_LINE);
        }
        if (this.getDisturbances() != null) {
            stringBuffer.append(DISTURBANCES + this.getDisturbances() + NEW_LINE);
        }
        if (this.getTakesEffect() != null) {
            stringBuffer.append(TAKES_EFFECT + this.getTakesEffect() + NEW_LINE);
        }
        if (this.getSideEffects() != null) {
            stringBuffer.append(SIDE_EFFECTS + this.getSideEffects() + NEW_LINE);
        }
        if (this.getPreCondition() != null) {
            stringBuffer.append(PRECONDITION + this.getPreCondition() + NEW_LINE);
        }
        if (this.getObsolete() != null) {
            stringBuffer.append(OBSOLETE + this.getObsolete() + NEW_LINE);
        }
        if (this.getVisibility() != null) {
            stringBuffer.append(VISIBILITY + this.getVisibility() + NEW_LINE);
        }
        if (this.getFilter() != null) {
            stringBuffer.append(FILTER + this.getFilter() + NEW_LINE);
        }
        if (this.getDependencies() != null) {
            stringBuffer.append(DEPENDENCIES + this.getDependencies() + NEW_LINE);
        }
        if (this.getDependenciesScript() != null) {
            stringBuffer.append(DEPENDENCIES_SCRIPT + this.getDependenciesScript() + NEW_LINE);
        }
        if (this.getFeature() != null) {
            stringBuffer.append(FEATURE + this.getFeature() + NEW_LINE);
        }
        if (this.getSpecification() != null) {
            stringBuffer.append(SPECIFICATION + this.getSpecification() + NEW_LINE);
        }
        if (this.isInterfaceOnly()) {
            stringBuffer.append("interfaceOnly: true\n");
        }
        if (this.getApplicationTag() != null) {
            stringBuffer.append(APPLICATION_TAG + this.getApplicationTag() + NEW_LINE);
        }
        return stringBuffer.toString();
    }
}

