/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step2;

import se.ericsson.cello.aueframework.collector.CollectorUpgradeParticipator;
import se.ericsson.cello.aueframework.collector.SystemUpgradeProxy;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.common.TransactionWrapperFactory;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.AbstractLastConversionStep;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;
import se.ericsson.crbs.omf.aue.step2.mao.SystemUpgradeProxyFactoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.SystemUpgradeProxyFactoryWrapperFactory;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;

public class CatLastConversionStep
extends AbstractLastConversionStep
implements CollectorUpgradeParticipator {
    private static final Class THIS_CLASS = CatLastConversionStep.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String name = "CAT OAM Copy positionRef attr";
    private static final String POS_REF_ATTR_NAME = "positionRef";
    private static final String DEVICE_GROUP_TYPE_NAME = "DeviceGroup";
    private TransactionWrapperFactory transactionWrapperFactory;
    private SystemUpgradeProxy systemUpgradeProxy;

    public CatLastConversionStep(XmlHolder resetXmlHolder) {
        super(resetXmlHolder);
        logger.traceEnter(THIS_CLASS, "CatLastConversionStep()");
        logger.traceReturn(THIS_CLASS, "CatLastConversionStep()");
    }

    public void aueSpecificConvert(ConverterContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "aueSpecificConvert ");
        this.transactionWrapperFactory = context.getTransactionWrapperFactory();
        SystemUpgradeProxyFactoryWrapper systemUpgradeProxyFactoryWrapper = SystemUpgradeProxyFactoryWrapperFactory.getInstance().getSystemUpgradeProxyFactoryWrapper();
        this.systemUpgradeProxy = systemUpgradeProxyFactoryWrapper.getProxy((CollectorUpgradeParticipator)this, context);
        logger.traceReturn(THIS_CLASS, "aueSpecificConvert ");
    }

    public String participatorName() {
        return name;
    }

    public void triggerIndicated(String trigger) {
        logger.traceEnter(THIS_CLASS, "triggerIndicated(" + trigger + ")");
        try {
            if ("FINISH".equalsIgnoreCase(trigger)) {
                TransactionWrapper transactionWrapper = this.transactionWrapperFactory.create();
                this.copyPositionRefAttrFromParentToChildren(transactionWrapper.getCoordinator());
                transactionWrapper.commit();
            }
            this.systemUpgradeProxy.triggerConfirmed(trigger, true);
        }
        catch (Throwable throwable) {
            logger.traceError(THIS_CLASS, "Exception caught while copying attr positionRef " + throwable.getMessage());
            this.systemUpgradeProxy.triggerConfirmed(trigger, false);
        }
        logger.traceReturn(THIS_CLASS, "triggerIndicated(" + trigger + ")");
    }

    private void copyPositionRefAttrFromParentToChildren(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "copyPositionRefAttrFromParentToChildren()");
        MoRepositoryWrapper repository = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIter = repository.lookupType(DEVICE_GROUP_TYPE_NAME);
        if (moIter != null) {
            while (moIter.hasMoreElements()) {
                GenericManagedObject deviceGroupMo = (GenericManagedObject)moIter.nextElement();
                try {
                    ManagedObject xPlugInMao = deviceGroupMo.getParent();
                    ManagedObject positionRefValue = (ManagedObject)xPlugInMao.getAttribute(POS_REF_ATTR_NAME, coordinator);
                    deviceGroupMo.setReadOnlyAttribute(POS_REF_ATTR_NAME, (Object)positionRefValue, coordinator);
                }
                catch (MoAccessException mae) {
                    String msg = "Failed to fetch positionRef attr. value from PlugInUnit / AuxPlugInUnit MO   to it's DeviceGroup. Origianl exception thrown: " + mae.getVariablesAsString();
                    logger.traceAbnormal(THIS_CLASS, msg);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "copyPositionRefAttrFromParentToChildren()");
    }
}

