/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Util;

public class CloneNoamRbsConfigurationMao
implements MoDataAction {
    private static final Class THIS_CLASS = CloneNoamRbsConfigurationMao.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String NODE_MANAGEMENT_FUNCTION = "NodeManagementFunction";
    private static final String RBS_CONFIGURATION = "RbsConfiguration";
    private static final String RBS_CONFIGURATION_LDN = "ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        this.assertNodeManagementFunctionExists(converterContext);
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        Collection mos = converterContext.getMoDataAccessor().getByType(RBS_CONFIGURATION);
        boolean moExist = false;
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoDataWrapper mdw = (MoDataWrapper)iter.next();
            if (!mdw.getLocalDistinguishedName().equalsIgnoreCase(RBS_CONFIGURATION_LDN)) continue;
            moExist = true;
            break;
        }
        if (moExist) {
            logger.traceDebug(THIS_CLASS, "perform() no RbsConfiguration cloned as it already exists");
        } else {
            logger.traceDebug(THIS_CLASS, "perform() clone RbsConfiguration");
            MoDataWrapper clone = Step2Util.createMo((MoDataAccessor)moDataAccessor, (String)RBS_CONFIGURATION_LDN, (Coordinator)coordinator, (ConverterContext)converterContext);
            logger.traceEnter(THIS_CLASS, "perform() created MoData");
            Enumeration attrEnumer = moDataWrapper.getAllPersistentAttributes();
            while (attrEnumer.hasMoreElements()) {
                Attribute attr = (Attribute)attrEnumer.nextElement();
                if ("froid".equalsIgnoreCase(attr.getName())) continue;
                clone.registerPersistentAttr(attr);
                logger.traceEnter(THIS_CLASS, "perform() cloned " + attr.getName());
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void assertNodeManagementFunctionExists(ConverterContext converterContext) throws CrbsAueException {
        Collection mos = converterContext.getMoDataAccessor().getByType(NODE_MANAGEMENT_FUNCTION);
        if (mos.isEmpty()) {
            throw new CrbsAueException("Can't create RbsConfiguration as parent NodeManagementFunction does'nt exist");
        }
    }
}

