/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step2.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.FindMoDataByParentLDNFilter;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.DeleteMoInstanceAction;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class CorrectMaoRadioDotAntennaConnectionAction
implements MoDataAction {
    private static final Class THIS_CLASS = CorrectMaoRadioDotAntennaConnectionAction.class;
    private static Step2Handler step2Handler;
    private static MoDataAccessor moDataAccessor;
    private static final AbstractLogger logger;
    private static final String IRU_CONF_TO_BE_COMPLETED = "irusMoToBeCompleted";
    private static int transceiverFroIdGen;
    private static int mcabFroIdGen;

    public void perform(MoDataWrapper dummyDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform() entered");
        String rfPortALdn = "";
        String rfPortBLdn = "";
        String rfBranch1Ldn = "";
        String rfBranch2Ldn = "";
        String auPort1Ldn = "";
        String auPort2Ldn = "";
        String antennaSubunitLdn = "";
        String antennaUnitLdn = "";
        String antennaUnitGroupLdn = "";
        String sectorEquipmentFunctionLdn = "";
        String iruLdns = "";
        String tmpAuxPiuLdn = "";
        String iruDevGrpLdn = "";
        List rdDevGrpLdnList = new ArrayList();
        List transceiverLdnList = new ArrayList();
        List multicastAntennaBranchLdnList = new ArrayList();
        moDataAccessor = converterContext.getMoDataAccessor();
        step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        logger.traceGeneral(THIS_CLASS, "AUE2: Starting to check if any pre-existing Transceivers or MulticastAntennaBranches are already configured on node.");
        if (this.checkExistingMoInConfiguration("Transceiver", converterContext) || this.checkExistingMoInConfiguration("MulticastAntennaBranch", converterContext)) {
            logger.traceGeneral(THIS_CLASS, "AUE2: Pre-existing Transceivers or MulticatAntBr already configured on node. AUE2 will NOT be executed on this node.");
            return;
        }
        logger.traceGeneral(THIS_CLASS, "AUE2: No pre-existing Transceivers or MulticastAntennaBranches on node, continuing AUE2 action.");
        iruLdns = step2Handler.retrieveFromAuePersistency("", IRU_CONF_TO_BE_COMPLETED);
        logger.traceGeneral(THIS_CLASS, "Length of iruLdns variable saved in persistent table (used by AUE2): iruLdns.length(): " + iruLdns.length());
        if (iruLdns != null) {
            BufferedReader reader = new BufferedReader(new StringReader(iruLdns));
            try {
                while (reader != null && (tmpAuxPiuLdn = reader.readLine()) != null && tmpAuxPiuLdn.compareTo("") != 0) {
                    logger.traceDebug(THIS_CLASS, "AuxPlugInUnit of type IRU found: " + tmpAuxPiuLdn);
                    iruDevGrpLdn = this.fetchChildLdn(tmpAuxPiuLdn, "DeviceGroup", converterContext);
                    rfPortALdn = this.fetchRfPortLdn(iruDevGrpLdn, "RfPort", true, converterContext);
                    rfPortBLdn = this.fetchRfPortLdn(iruDevGrpLdn, "RfPort", false, converterContext);
                    if (rfPortALdn.compareTo("") == 0 && rfPortBLdn.compareTo("") == 0) continue;
                    rfBranch1Ldn = this.fetchRfBranchLdn(rfPortALdn, "RfBranch", converterContext);
                    rfBranch2Ldn = this.fetchRfBranchLdn(rfPortBLdn, "RfBranch", converterContext);
                    auPort1Ldn = this.fetchAuPortLdn(rfBranch1Ldn, "RfBranch", converterContext);
                    auPort2Ldn = this.fetchAuPortLdn(rfBranch2Ldn, "RfBranch", converterContext);
                    antennaSubunitLdn = this.fetchParentLdn(auPort1Ldn, "AntennaSubunit", converterContext);
                    antennaUnitLdn = this.fetchParentLdn(antennaSubunitLdn, "AntennaUnit", converterContext);
                    antennaUnitGroupLdn = this.fetchParentLdn(antennaUnitLdn, "AntennaUnitGroup", converterContext);
                    sectorEquipmentFunctionLdn = this.fetchReservedByLdn(rfBranch1Ldn, "RfBranch", converterContext);
                    rdDevGrpLdnList = this.fetchRdDeviceGroupLdns(tmpAuxPiuLdn, converterContext, coordinator);
                    this.deleteMoLdn(rfPortALdn, "RfPort", converterContext, coordinator);
                    this.deleteMoLdn(rfBranch1Ldn, "RfBranch", converterContext, coordinator);
                    this.deleteMoLdn(auPort1Ldn, "AuPort", converterContext, coordinator);
                    this.deleteMoLdn(rfPortBLdn, "RfPort", converterContext, coordinator);
                    this.deleteMoLdn(rfBranch2Ldn, "RfBranch", converterContext, coordinator);
                    this.deleteMoLdn(auPort2Ldn, "AuPort", converterContext, coordinator);
                    if (!this.checkExtraChildren(antennaSubunitLdn, converterContext)) {
                        this.deleteMoLdn(antennaSubunitLdn, "AntennaSubunit", converterContext, coordinator);
                        if (!this.checkExtraChildren(antennaUnitLdn, converterContext)) {
                            this.deleteMoLdn(antennaUnitLdn, "AntennaUnit", converterContext, coordinator);
                        } else {
                            logger.traceGeneral(THIS_CLASS, "Extra (unwanted) childMOs found for specified AntennaUnit, will therefore NOT delete AntennaUnit.");
                        }
                    } else {
                        logger.traceGeneral(THIS_CLASS, "Extra (unwanted) childMOs found for specified AntennaSubunit,  will therefore NOT delete AntennaSubunit nor its parent AntennaUnit.");
                    }
                    transceiverLdnList = this.createTransceivers(rdDevGrpLdnList, converterContext, coordinator);
                    multicastAntennaBranchLdnList = this.createMulticastAntennaBranches(antennaUnitGroupLdn, transceiverLdnList, converterContext, coordinator);
                    this.setSectorEquipmentFunctionReference(sectorEquipmentFunctionLdn, multicastAntennaBranchLdnList, converterContext, coordinator);
                    this.setRemainingReservedByAttributes(transceiverLdnList, multicastAntennaBranchLdnList, sectorEquipmentFunctionLdn, converterContext, coordinator);
                }
            }
            catch (IOException ioex) {
                logger.traceError(THIS_CLASS, "AUE 2 Action Upgrade CorrectMaoRadioDotAntennaConnectionAction failed");
                CrbsAueException cae = new CrbsAueException(ioex.getMessage());
                throw cae;
            }
        }
        logger.traceReturn(THIS_CLASS, "perform() executed");
    }

    private boolean checkExtraChildren(String parentLdn, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkExtraChildren() entered");
        try {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(parentLdn));
            if (children == null) {
                logger.traceReturn(THIS_CLASS, "checkExtraChildren() found NO childMOs (null). checkExtraChildren() returned.");
                return false;
            }
            if (children.isEmpty()) {
                logger.traceReturn(THIS_CLASS, "checkExtraChildren() found NO childMOs (empty). checkExtraChildren() returned.");
                return false;
            }
            logger.traceReturn(THIS_CLASS, "checkExtraChildren() found childMOs. checkExtraChildren() returned.");
            return true;
        }
        catch (AueException ae) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)ae);
        }
    }

    private boolean checkExistingMoInConfiguration(String MoTypeName, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkExistingMoInConfiguration() entered");
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        if (accessor != null) {
            Collection mos = converterContext.getMoDataAccessor().getByType(MoTypeName);
            logger.traceReturn(THIS_CLASS, "checkExistingMoInConfiguration() executed");
            return !mos.isEmpty();
        }
        logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        logger.traceReturn(THIS_CLASS, "checkExistingMoInConfiguration() executed without properly checking existing: " + MoTypeName);
        return true;
    }

    private String fetchChildLdn(String parentLdn, String childType, ConverterContext converterContext) throws CrbsAueException {
        String childLdn;
        block4: {
            logger.traceEnter(THIS_CLASS, "fetchChildLdn() entered");
            childLdn = "";
            try {
                MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
                Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(parentLdn));
                if (children != null) {
                    Iterator childIter = children.iterator();
                    while (childIter.hasNext()) {
                        MoDataWrapper moDataWrapper = (MoDataWrapper)childIter.next();
                        if (moDataWrapper.getMoTypeName().compareTo(childType) != 0) continue;
                        childLdn = moDataWrapper.getLocalDistinguishedName();
                        break block4;
                    }
                    break block4;
                }
                logger.traceAbnormal(THIS_CLASS, " Specified parent-MO has No child-MOs: " + parentLdn);
            }
            catch (AueException ae) {
                throw new CrbsAueException("Failed to read/write TableData", (Throwable)ae);
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchChildLdn() executed");
        return childLdn;
    }

    private String fetchRfPortLdn(String parentLdn, String childType, boolean firstRfPortChild, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchRfPortLdn() entered");
        String rfPortLdn = "";
        try {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(parentLdn));
            boolean firstRfPort = true;
            if (children != null) {
                Iterator childIter = children.iterator();
                while (childIter.hasNext()) {
                    MoDataWrapper moDataWrapper = (MoDataWrapper)childIter.next();
                    if (firstRfPort && moDataWrapper.getMoTypeName().compareTo(childType) == 0) {
                        firstRfPort = false;
                        if (!firstRfPortChild) continue;
                        rfPortLdn = moDataWrapper.getLocalDistinguishedName();
                        break;
                    }
                    if (firstRfPort || moDataWrapper.getMoTypeName().compareTo(childType) != 0) continue;
                    firstRfPort = true;
                    if (firstRfPortChild) continue;
                    rfPortLdn = moDataWrapper.getLocalDistinguishedName();
                    break;
                }
                if (rfPortLdn.equals("")) {
                    logger.traceAbnormal(THIS_CLASS, "NO RfPort children at all found for: " + parentLdn);
                }
            } else {
                logger.traceAbnormal(THIS_CLASS, "NO children at all found for: " + parentLdn);
            }
        }
        catch (AueException ae) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)ae);
        }
        logger.traceReturn(THIS_CLASS, "fetchRfPortLdn() executed");
        return rfPortLdn;
    }

    private String fetchRfBranchLdn(String rfPortLdn, String rfBranchType, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchRfBranchLdn() entered");
        String rfBranchLdn = "";
        String rfPortRefLdn = "";
        Collection rfBranches = converterContext.getMoDataAccessor().getByType(rfBranchType);
        if (rfBranches != null) {
            Iterator rfBranch = rfBranches.iterator();
            while (rfBranch.hasNext()) {
                MoDataWrapper moDataWrapper = (MoDataWrapper)rfBranch.next();
                ReferenceAttribute refAttribute = (ReferenceAttribute)moDataWrapper.getAttribute("rfPortRef");
                rfPortRefLdn = refAttribute.getReferenceAsLDN();
                if (rfPortRefLdn == null) {
                    logger.traceGeneral(THIS_CLASS, "NULL value found for an RfBranch's rfPortRef String value. Continuing checking the rest of the RfPortRefs.");
                    continue;
                }
                if (rfPortLdn.compareTo(rfPortRefLdn) != 0) continue;
                rfBranchLdn = moDataWrapper.getLocalDistinguishedName();
                break;
            }
        } else {
            logger.traceDebug(THIS_CLASS, "IRU has NO RfBranches");
        }
        logger.traceReturn(THIS_CLASS, "fetchRfBranchLdn() executed");
        return rfBranchLdn;
    }

    private String fetchAuPortLdn(String rfBranchLdn, String rfBranchType, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchAuPortLdn() entered");
        String auPortLdn = "";
        try {
            Collection rfBranches = converterContext.getMoDataAccessor().getByType(rfBranchType);
            if (rfBranches != null) {
                Iterator rfBranch = rfBranches.iterator();
                while (rfBranch.hasNext()) {
                    ReferenceAttribute existingRefAttribute;
                    SequenceAttribute seqAttribute;
                    Enumeration enumeration;
                    MoDataWrapper moDataWrapper = (MoDataWrapper)rfBranch.next();
                    if (!moDataWrapper.getLocalDistinguishedName().equals(rfBranchLdn) || !(enumeration = (seqAttribute = (SequenceAttribute)moDataWrapper.getAttribute("auPortRef")).elements()).hasMoreElements() || (auPortLdn = (existingRefAttribute = (ReferenceAttribute)enumeration.nextElement()).getReferenceAsLDN()) != null) continue;
                    logger.traceGeneral(THIS_CLASS, "NULL value found for an RfBranch's auPortRef String value. RfBranch: " + rfBranchLdn);
                    throw new CrbsAueException("Aborting AUE2, since attribute auPortRef has a NULL value.");
                }
            } else {
                logger.traceDebug(THIS_CLASS, "IRU has No RfBranches");
            }
        }
        catch (AueException ae) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)ae);
        }
        logger.traceReturn(THIS_CLASS, "fetchAuPortLdn() executed");
        return auPortLdn;
    }

    private String fetchParentLdn(String childLdn, String parentType, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchParentLdn() entered");
        String parentLdn = "";
        if (childLdn.equals("")) {
            logger.traceGeneral(THIS_CLASS, "Empty value found for input parameter childLdn.");
        } else {
            int lastComma = childLdn.lastIndexOf(",");
            String extractedParentLdn = childLdn.substring(0, lastComma);
            MoDataAccessor accessor = converterContext.getMoDataAccessor();
            Collection parentMos = accessor.getByType(parentType);
            Iterator parentMosMoIter = parentMos.iterator();
            while (parentMosMoIter.hasNext()) {
                MoDataWrapper realMoDataWrapper = (MoDataWrapper)parentMosMoIter.next();
                if (!extractedParentLdn.equals(realMoDataWrapper.getLocalDistinguishedName())) continue;
                parentLdn = extractedParentLdn;
                break;
            }
        }
        if (parentLdn.equals("")) {
            logger.traceAbnormal(THIS_CLASS, "Searched extractedParentLdn does not have its corresponding parent MO in the configuration");
        }
        logger.traceReturn(THIS_CLASS, "fetchParentLdn() executed");
        return parentLdn;
    }

    private String fetchReservedByLdn(String moLdn, String moType, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchReservedByLdn() entered");
        String reservedByLdn = "";
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        Collection mos = accessor.getByType(moType);
        Iterator moIter = mos.iterator();
        while (moIter.hasNext()) {
            ReferenceAttribute existingRefAttribute;
            SequenceAttribute seqAttribute;
            Enumeration enumeration;
            MoDataWrapper realMoDataWrapper = (MoDataWrapper)moIter.next();
            if (!moLdn.equals(realMoDataWrapper.getLocalDistinguishedName()) || !(enumeration = (seqAttribute = (SequenceAttribute)realMoDataWrapper.getAttribute("reservedBy")).elements()).hasMoreElements() || (reservedByLdn = (existingRefAttribute = (ReferenceAttribute)enumeration.nextElement()).getReferenceAsLDN()) != null) continue;
            logger.traceGeneral(THIS_CLASS, "NULL value found for an " + moType + "'s reservedBy String value. " + moType + ": " + moLdn);
            throw new CrbsAueException("Aborting AUE2, since attribute reservedBy has a NULL value.");
        }
        logger.traceReturn(THIS_CLASS, "fetchReservedByLdn() executed");
        return reservedByLdn;
    }

    private List fetchRdDeviceGroupLdns(String iruLdn, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchRdDeviceGroupLdns() entered");
        String remoteRdiPortRefLdn = "";
        String rdDeviceGroupLdn = "";
        String rdLdn = "";
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(iruLdn));
            if (children != null) {
                Iterator childIter = children.iterator();
                while (childIter.hasNext()) {
                    MoDataWrapper moDataWrapper = (MoDataWrapper)childIter.next();
                    if (moDataWrapper.getMoTypeName().compareTo("RdiPort") != 0) continue;
                    logger.traceGeneral(THIS_CLASS, "Current IRU RdiPort: " + moDataWrapper.getLocalDistinguishedName());
                    ReferenceAttribute remoteRdiPortRefAttribute = (ReferenceAttribute)moDataWrapper.getAttribute("remoteRdiPortRef");
                    remoteRdiPortRefLdn = remoteRdiPortRefAttribute.getReferenceAsLDN();
                    if (remoteRdiPortRefLdn == null) {
                        logger.traceGeneral(THIS_CLASS, "NULL value found for the IRU RdiPort's remoteRdiPortRef String value.");
                        logger.traceGeneral(THIS_CLASS, "No Transceiver will therefore be created corresponding to the IRU RdiPort: " + moDataWrapper.getLocalDistinguishedName());
                        continue;
                    }
                    if (remoteRdiPortRefLdn == null || remoteRdiPortRefLdn.compareTo("") == 0) continue;
                    rdLdn = this.fetchParentLdn(remoteRdiPortRefLdn, "AuxPlugInUnit", converterContext);
                    rdDeviceGroupLdn = this.fetchChildLdn(rdLdn, "DeviceGroup", converterContext);
                    if (rdDeviceGroupLdn.compareTo("") == 0) {
                        logger.traceGeneral(THIS_CLASS, "No RD DeviceGroup found at all under the RD: " + rdLdn);
                        logger.traceGeneral(THIS_CLASS, "No Transceiver will therefore be created corresponding to the IRU RdiPort: " + moDataWrapper.getLocalDistinguishedName());
                        continue;
                    }
                    resultList.add(rdDeviceGroupLdn);
                }
            } else {
                logger.traceDebug(THIS_CLASS, "IRU has No children!");
            }
        }
        catch (AueException ae) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)ae);
        }
        logger.traceReturn(THIS_CLASS, "fetchRdDeviceGroupLdns() executed");
        return resultList;
    }

    private void deleteMoLdn(String moLdn, String moType, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "deleteMoLdn() entered");
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        DeleteMoInstanceAction deleteMoInstanceAction = new DeleteMoInstanceAction(moLdn);
        try {
            if (accessor == null) {
                logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
            } else {
                Collection Mos = converterContext.getMoDataAccessor().getByType(moType);
                Iterator MoIter = Mos.iterator();
                while (MoIter.hasNext()) {
                    MoDataWrapper realMoDataWrapper = (MoDataWrapper)MoIter.next();
                    if (!moLdn.equals(realMoDataWrapper.getLocalDistinguishedName())) continue;
                    deleteMoInstanceAction.perform(realMoDataWrapper, converterContext, coordinator);
                }
            }
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
        logger.traceReturn(THIS_CLASS, "deleteMoLdn() executed");
    }

    private List createTransceivers(List rdDeviceGroupLdnList, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createTransceivers() entered");
        ArrayList<String> resultList = new ArrayList<String>();
        String rdDeviceGroupLdn = "";
        if (!rdDeviceGroupLdnList.isEmpty()) {
            for (int i = 0; i < rdDeviceGroupLdnList.size(); ++i) {
                rdDeviceGroupLdn = (String)rdDeviceGroupLdnList.get(i);
                try {
                    String transceiverLdn = rdDeviceGroupLdn + "," + "Transceiver" + "=1";
                    resultList.add(transceiverLdn);
                    MoDataWrapper transceiverMo = moDataAccessor.create(transceiverLdn, coordinator);
                    transceiverMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    this.addFroIdAttribute(transceiverMo, Integer.toString(transceiverFroIdGen));
                    ++transceiverFroIdGen;
                    continue;
                }
                catch (AueException ae) {
                    this.throwException(ae);
                }
            }
        } else {
            logger.traceDebug(THIS_CLASS, "The rdDeviceGroupLdnList parameter is empty!");
        }
        logger.traceReturn(THIS_CLASS, "createTransceivers() executed");
        return resultList;
    }

    private List createMulticastAntennaBranches(String antennaUnitGroupLdn, List TransceiverLdnList, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMulticastAntennaBranches() entered");
        ArrayList<String> resultLdnList = new ArrayList<String>();
        try {
            for (int i = 1; i <= 2; ++i) {
                String mcabLdn = antennaUnitGroupLdn + "," + "MulticastAntennaBranch" + "=" + i;
                resultLdnList.add(mcabLdn);
                MoDataWrapper mcabMo = moDataAccessor.create(mcabLdn, coordinator);
                mcabMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.addFroIdAttribute(mcabMo, Integer.toString(mcabFroIdGen));
                this.addSequenceAttribute(mcabMo, "transceiverRef", TransceiverLdnList);
                ++mcabFroIdGen;
            }
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
        logger.traceReturn(THIS_CLASS, "createMulticastAntennaBranches() executed");
        return resultLdnList;
    }

    private void setSectorEquipmentFunctionReference(String sectorEquipmentFunctionLdn, List multicastAntennaBranchLdnList, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setSectorEquipmentFunctionReference() entered");
        String attributeValue = "";
        ArrayList<ReferenceAttribute> oldRfBranchRefList = new ArrayList<ReferenceAttribute>();
        try {
            Collection sectorEqFuncMos = context.getMoDataAccessor().getByType("SectorEquipmentFunction");
            Iterator moIter = sectorEqFuncMos.iterator();
            while (moIter.hasNext()) {
                MoDataWrapper realMoDataWrapper = (MoDataWrapper)moIter.next();
                String ldn = realMoDataWrapper.getLocalDistinguishedName();
                if (!sectorEquipmentFunctionLdn.equals(ldn)) continue;
                SequenceAttribute seqAttribute = (SequenceAttribute)realMoDataWrapper.getAttribute("rfBranchRef");
                if (seqAttribute == null) {
                    throw new CrbsAueException("Attribute rfBranchRef does not exist.");
                }
                Enumeration enumeration = seqAttribute.elements();
                while (enumeration.hasMoreElements()) {
                    ReferenceAttribute oldRefAttribute = (ReferenceAttribute)enumeration.nextElement();
                    oldRfBranchRefList.add(oldRefAttribute);
                }
                if (!oldRfBranchRefList.isEmpty()) {
                    for (int i = 0; i < oldRfBranchRefList.size(); ++i) {
                        ReferenceAttribute oldRfBranchRefAttribute = (ReferenceAttribute)oldRfBranchRefList.get(i);
                        seqAttribute.removeElement((Attribute)oldRfBranchRefAttribute);
                    }
                } else {
                    logger.traceDebug(THIS_CLASS, "The oldRfBranchRefList parameter is empty!");
                }
                if (!multicastAntennaBranchLdnList.isEmpty()) {
                    for (int i = 0; i < multicastAntennaBranchLdnList.size(); ++i) {
                        attributeValue = (String)multicastAntennaBranchLdnList.get(i);
                        ReferenceAttribute refAttr = new ReferenceAttribute("rfBranchRef", attributeValue, false);
                        seqAttribute.addElement((Attribute)refAttr);
                    }
                    realMoDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    continue;
                }
                logger.traceDebug(THIS_CLASS, "The multicastAntennaBranchLdnList parameter is empty!");
            }
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
        logger.traceReturn(THIS_CLASS, "setSectorEquipmentFunctionReference() executed");
    }

    private void setRemainingReservedByAttributes(List transceiverLdnList, List multicastAntennaBranchLdnList, String sectorEquipmentFunctionLdn, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setRemainingReservedByAttributes() entered");
        try {
            String ldn;
            MoDataWrapper realMoDataWrapper;
            ArrayList<String> sectorEquipmentFunctionLdnList = new ArrayList<String>();
            sectorEquipmentFunctionLdnList.add(sectorEquipmentFunctionLdn);
            Collection transceiverMos = context.getMoDataAccessor().getByType("Transceiver");
            Collection mcabMos = context.getMoDataAccessor().getByType("MulticastAntennaBranch");
            Iterator transceiverMoIter = transceiverMos.iterator();
            Iterator mcabMoIter = mcabMos.iterator();
            while (transceiverMoIter.hasNext()) {
                realMoDataWrapper = (MoDataWrapper)transceiverMoIter.next();
                ldn = realMoDataWrapper.getLocalDistinguishedName();
                if (!transceiverLdnList.contains(ldn)) continue;
                this.addSequenceAttribute(realMoDataWrapper, "reservedBy", multicastAntennaBranchLdnList);
            }
            while (mcabMoIter.hasNext()) {
                realMoDataWrapper = (MoDataWrapper)mcabMoIter.next();
                ldn = realMoDataWrapper.getLocalDistinguishedName();
                if (!multicastAntennaBranchLdnList.contains(ldn)) continue;
                this.addSequenceAttribute(realMoDataWrapper, "reservedBy", sectorEquipmentFunctionLdnList);
            }
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
        logger.traceReturn(THIS_CLASS, "setRemainingReservedByAttributes() executed");
    }

    private void addFroIdAttribute(MoDataWrapper dummyDataWrapper, String froId) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute froIdAttribute = new IntegerAttribute("froId", false, Integer.parseInt(froId));
        dummyDataWrapper.registerPersistentAttr((Attribute)froIdAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute() executed");
    }

    private void addSequenceAttribute(MoDataWrapper moData, String attributeName, List attributeValuesList) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addSequenceAttribute() entered");
        ReferenceAttribute refAttr = null;
        SequenceAttribute seqAttr = new SequenceAttribute(attributeName, true);
        String attributeValue = "";
        if (!attributeValuesList.isEmpty()) {
            for (int i = 0; i < attributeValuesList.size(); ++i) {
                attributeValue = (String)attributeValuesList.get(i);
                refAttr = new ReferenceAttribute(attributeName, attributeValue, false);
                seqAttr.addElement((Attribute)refAttr);
            }
            moData.registerPersistentAttr((Attribute)seqAttr);
        } else {
            logger.traceDebug(THIS_CLASS, "The attributeValuesList parameter is empty!");
        }
        logger.traceReturn(THIS_CLASS, "addSequenceAttribute() executed");
    }

    private void throwException(AueException ae) throws CrbsAueException {
        CrbsAueException cae = new CrbsAueException(ae.getMessage());
        cae.setStackTrace(ae.getStackTrace());
        throw cae;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        transceiverFroIdGen = 0;
        mcabFroIdGen = 0;
    }
}

