/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.vls;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.cello.vls.IpomVlsjiHostcredPasswdReq;
import se.ericsson.cello.vls.IpomVlsjiHostcredPasswdRsp;
import se.ericsson.cello.vls.IpomVlsjiInitiateServiceCfm;
import se.ericsson.cello.vls.IpomVlsjiInitiateServiceReq;
import se.ericsson.cello.vls.IpomVlsjiNotifySubscribeReq;
import se.ericsson.cello.vls.IpomVlsjiSecLogEventReq;
import se.ericsson.cello.vls.IpomVlsjiSecLogEventRsp;
import se.ericsson.cello.vls.IpomVlsjiValidateIdlReq;
import se.ericsson.cello.vls.IpomVlsjiValidateIdlRsp;
import se.ericsson.cello.vls.IpomVlsjiValidateMibReq;
import se.ericsson.cello.vls.IpomVlsjiValidateMibRsp;
import se.ericsson.cello.vls.VLSException;
import se.ericsson.cello.vls.VLSQueryResult;

class VLSSignalProxy
implements SubscriptionObserver {
    private SignalPort signalPort = PortManager.instance();
    private static OseProcess op = null;
    private static final int MAX_NO_OF_RETRIES = 2;
    private static final String SERVICE_NAME = "IPOM_VLSJI_SERVICE";
    private static final String PV_FIRST = "R3A";
    private static final String PV_SECOND = "R3A";
    private static final String PV_THIRD = "R3A";
    private String protocolVersion = "";
    private static final int IPOM_VLSJI_OK = 0;
    private static final int IPOM_VLSJI_NOK = 1;
    private static final int INIT_SERVICE_CFM = 1;
    private static final int INIT_SERVICE_SUS = 2;
    private static final int INIT_SERVICE_REJ = 3;
    private static final int TRACEGROUP = 5;
    private static final int RECEIVE_TIMEOUT = 5000;
    static /* synthetic */ Class class$se$ericsson$cello$vls$IpomVlsjiValidateIdlRsp;
    static /* synthetic */ Class class$se$ericsson$cello$vls$IpomVlsjiSecLogEventRsp;
    static /* synthetic */ Class class$se$ericsson$cello$vls$IpomVlsjiHostcredPasswdRsp;
    static /* synthetic */ Class class$se$ericsson$cello$vls$IpomVlsjiValidateMibRsp;

    public synchronized void serviceAdded(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)"serviceAdded = IPOM_VLSJI_SERVICE");
        if (this.init()) {
            MessageLog.trace((int)5, this.getClass(), (String)"init() called successfully.");
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)"init() returned false.");
        }
    }

    public synchronized void serviceRemoved(String string) {
        op = null;
        this.protocolVersion = "";
    }

    VLSQueryResult isAuthorized(String string, String string2, String string3, String string4) throws VLSException {
        IpomVlsjiValidateIdlReq ipomVlsjiValidateIdlReq = null;
        IpomVlsjiValidateIdlRsp ipomVlsjiValidateIdlRsp = null;
        try {
            ipomVlsjiValidateIdlReq = new IpomVlsjiValidateIdlReq(string, string2, string3, string4);
        }
        catch (VLSException vLSException) {
            MessageLog.info(this.getClass(), (String)vLSException.toString());
            throw vLSException;
        }
        for (int i = 0; i < 2 && ipomVlsjiValidateIdlRsp == null; ++i) {
            if (!this.checkOp()) continue;
            ipomVlsjiValidateIdlRsp = (IpomVlsjiValidateIdlRsp)SignalHelper.sendAndReceive((OseProcess)op, (Signal)ipomVlsjiValidateIdlReq, (Class)(class$se$ericsson$cello$vls$IpomVlsjiValidateIdlRsp == null ? VLSSignalProxy.class$("se.ericsson.cello.vls.IpomVlsjiValidateIdlRsp") : class$se$ericsson$cello$vls$IpomVlsjiValidateIdlRsp));
        }
        if (ipomVlsjiValidateIdlRsp == null) {
            throw new VLSException("VLS not accessible");
        }
        return new VLSQueryResult(ipomVlsjiValidateIdlRsp.getResultCode());
    }

    void logSecEvent(String string, String string2, int n, int n2, String string3) {
        IpomVlsjiSecLogEventReq ipomVlsjiSecLogEventReq = null;
        IpomVlsjiSecLogEventRsp ipomVlsjiSecLogEventRsp = null;
        ipomVlsjiSecLogEventReq = new IpomVlsjiSecLogEventReq(string, string2, n, n2, string3);
        for (int i = 0; i < 2 && ipomVlsjiSecLogEventRsp == null; ++i) {
            if (!this.checkOp()) continue;
            ipomVlsjiSecLogEventRsp = (IpomVlsjiSecLogEventRsp)SignalHelper.sendAndReceive((OseProcess)op, (Signal)ipomVlsjiSecLogEventReq, (Class)(class$se$ericsson$cello$vls$IpomVlsjiSecLogEventRsp == null ? VLSSignalProxy.class$("se.ericsson.cello.vls.IpomVlsjiSecLogEventRsp") : class$se$ericsson$cello$vls$IpomVlsjiSecLogEventRsp));
        }
        if (ipomVlsjiSecLogEventRsp == null) {
            MessageLog.info(this.getClass(), (String)"VLS not accessible");
        }
    }

    public String getHostCredPasswd() throws VLSException {
        IpomVlsjiHostcredPasswdReq ipomVlsjiHostcredPasswdReq = null;
        IpomVlsjiHostcredPasswdRsp ipomVlsjiHostcredPasswdRsp = null;
        ipomVlsjiHostcredPasswdReq = new IpomVlsjiHostcredPasswdReq();
        for (int i = 0; i < 2 && ipomVlsjiHostcredPasswdRsp == null; ++i) {
            if (!this.checkOp()) continue;
            ipomVlsjiHostcredPasswdRsp = (IpomVlsjiHostcredPasswdRsp)SignalHelper.sendAndReceive((OseProcess)op, (Signal)ipomVlsjiHostcredPasswdReq, (Class)(class$se$ericsson$cello$vls$IpomVlsjiHostcredPasswdRsp == null ? VLSSignalProxy.class$("se.ericsson.cello.vls.IpomVlsjiHostcredPasswdRsp") : class$se$ericsson$cello$vls$IpomVlsjiHostcredPasswdRsp));
        }
        if (ipomVlsjiHostcredPasswdRsp == null) {
            throw new VLSException("VLS not accessible");
        }
        return ipomVlsjiHostcredPasswdRsp.getHostCredPasswd();
    }

    VLSQueryResult isAuthorizedInMib(String string, String string2, String string3, int n, String string4) throws VLSException {
        IpomVlsjiValidateMibReq ipomVlsjiValidateMibReq = null;
        IpomVlsjiValidateMibRsp ipomVlsjiValidateMibRsp = null;
        try {
            ipomVlsjiValidateMibReq = new IpomVlsjiValidateMibReq(string, string2, string3, n, string4);
        }
        catch (VLSException vLSException) {
            MessageLog.info(this.getClass(), (String)vLSException.toString());
            throw vLSException;
        }
        for (int i = 0; i < 2 && ipomVlsjiValidateMibRsp == null; ++i) {
            if (!this.checkOp()) continue;
            ipomVlsjiValidateMibRsp = (IpomVlsjiValidateMibRsp)SignalHelper.sendAndReceive((OseProcess)op, (Signal)ipomVlsjiValidateMibReq, (Class)(class$se$ericsson$cello$vls$IpomVlsjiValidateMibRsp == null ? VLSSignalProxy.class$("se.ericsson.cello.vls.IpomVlsjiValidateMibRsp") : class$se$ericsson$cello$vls$IpomVlsjiValidateMibRsp));
        }
        if (ipomVlsjiValidateMibRsp == null) {
            throw new VLSException("VLS not accessible");
        }
        return new VLSQueryResult(ipomVlsjiValidateMibRsp.getResultCode());
    }

    VLSSignalProxy() {
        OseNameServer.addSubscriptionObserver((String)SERVICE_NAME, (SubscriptionObserver)this);
    }

    public boolean checkOp() {
        if (op != null && !this.protocolVersion.equals("")) {
            return true;
        }
        boolean bl = this.init();
        for (int i = 0; !bl && i < 5; ++i) {
            try {
                Thread.sleep(5000L);
                bl = this.init();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized boolean init() {
        op = OseNameServer.lookup((String)SERVICE_NAME);
        if (op == null) {
            return false;
        }
        MessageLog.trace((int)5, this.getClass(), (String)("In init(), op = : " + op));
        IpomVlsjiInitiateServiceReq ipomVlsjiInitiateServiceReq = new IpomVlsjiInitiateServiceReq("R3A", "R3A", "R3A");
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomVlsjiInitiateServiceReq, (Class)IpomVlsjiInitiateServiceCfm.class, (int)5000);
        if (signal == null) {
            MessageLog.trace((int)5, this.getClass(), (String)" init(). No response signal rspSig == null. ");
            return false;
        }
        if (!(signal instanceof IpomVlsjiInitiateServiceCfm)) {
            MessageLog.trace((int)5, this.getClass(), (String)("init(), received rspSig = " + signal.getClass()));
            return false;
        }
        if (((IpomVlsjiInitiateServiceCfm)signal).getResult() == 1) {
            MessageLog.trace((int)5, this.getClass(), (String)(" init() confirmed, pv = : " + ((IpomVlsjiInitiateServiceCfm)signal).getPreferredPV()));
            this.protocolVersion = ((IpomVlsjiInitiateServiceCfm)signal).getPreferredPV();
            this.sendIpomVlsjiNotifySubscribeReq();
            return true;
        }
        if (((IpomVlsjiInitiateServiceCfm)signal).getResult() == 2) {
            MessageLog.info(this.getClass(), (String)" init() suspended");
            return false;
        }
        if (((IpomVlsjiInitiateServiceCfm)signal).getResult() == 3) {
            MessageLog.info(this.getClass(), (String)" init() rejected");
            return false;
        }
        MessageLog.traceError(this.getClass(), (String)(" init(). InitiateServiceCfm status not recognized. status: " + ((IpomVlsjiInitiateServiceCfm)signal).getResult()));
        return false;
    }

    public void sendIpomVlsjiNotifySubscribeReq() {
        IpomVlsjiNotifySubscribeReq ipomVlsjiNotifySubscribeReq = new IpomVlsjiNotifySubscribeReq();
        OseProcess oseProcess = this.signalPort.getOseProcess();
        SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)ipomVlsjiNotifySubscribeReq);
    }
}

