/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroIdFinder;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.crbs.omf.mao.pnp.request.PnpActionRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSubRequest;
import se.ericsson.crbs.omf.mao.pnp.xml.PnpXmlPack;

public class PnpXmlPackImpl
implements PnpXmlPack {
    protected final DocumentBuilder builder;
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = PnpXmlPackImpl.class;

    public PnpXmlPackImpl() {
        logger.traceEnter(THIS_CLASS, "PnpXmlPackImpl()");
        DocumentBuilder tmpBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            tmpBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.traceError(THIS_CLASS, "Document Builder could not be created: " + e.getMessage());
        }
        this.builder = tmpBuilder;
        logger.traceReturn(THIS_CLASS, "PnpXmlPackImpl()");
    }

    public Document createDocument() {
        return this.builder.newDocument();
    }

    public final String packArray(String name, Object[] value) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packArray()");
        Document document = this.createDocument();
        Element arrayElement = this.packArray(name, value, document);
        document.appendChild(arrayElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packArray()");
        return result;
    }

    public final Element packArray(String name, Object[] value, Document document) throws IllegalParameterValueException {
        Element array = document.createElement("array");
        if (name != null) {
            array.setAttribute("name", name);
        }
        List<Object> aList = Arrays.asList(value);
        Iterator<Object> iterator = aList.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) {
                array.appendChild(this.packArrayEntry(new NullManagedObject(), document));
                continue;
            }
            array.appendChild(this.packArrayEntry(next, document));
        }
        return array;
    }

    public final String packBoolean(String name, boolean value) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packBoolean()");
        Document document = this.createDocument();
        Element booleanElement = this.packBoolean(name, value ? Boolean.TRUE : Boolean.FALSE, document);
        document.appendChild(booleanElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packBoolean()");
        return result;
    }

    public final Element packBoolean(String name, Object value, Document document) {
        Element longElement = document.createElement("attr");
        if (name != null) {
            longElement.setAttribute("name", name);
        }
        longElement.setAttribute("type", "boolean");
        longElement.setAttribute("value", value.toString());
        return longElement;
    }

    public final String packBooleanArray(String name, boolean[] attr) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packBooleanArray()");
        Document document = this.createDocument();
        Element booleanElement = this.packBooleanArray(name, attr, document);
        document.appendChild(booleanElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packBooleanArray()");
        return result;
    }

    public final Element packBooleanArray(String name, boolean[] attr, Document document) {
        Element intArray = document.createElement("array");
        if (name != null) {
            intArray.setAttribute("name", name);
        }
        for (int i = 0; i < attr.length; ++i) {
            Element booleanatt = document.createElement("attr");
            booleanatt.setAttribute("type", "boolean");
            booleanatt.setAttribute("value", Boolean.valueOf(attr[i]).toString());
            intArray.appendChild(booleanatt);
        }
        return intArray;
    }

    public final String packInt(String name, int value) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packInt()");
        Document document = this.createDocument();
        Element booleanElement = this.packInt(name, new Integer(value), document);
        document.appendChild(booleanElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packInt()");
        return result;
    }

    public final Element packInt(String name, Object value, Document document) {
        Element integer = document.createElement("attr");
        if (name != null) {
            integer.setAttribute("name", name);
        }
        integer.setAttribute("type", "s32");
        integer.setAttribute("value", value.toString());
        return integer;
    }

    public final String packIntArray(String name, int[] attr) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packIntArray()");
        Document document = this.createDocument();
        Element inArrayElement = this.packIntArray(name, attr, document);
        document.appendChild(inArrayElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packIntArray()");
        return result;
    }

    public final Element packIntArray(String name, int[] attr, Document document) {
        Element intArray = document.createElement("array");
        if (name != null) {
            intArray.setAttribute("name", name);
        }
        for (int i = 0; i < attr.length; ++i) {
            Element integer = document.createElement("attr");
            integer.setAttribute("type", "s32");
            integer.setAttribute("value", Integer.toString(attr[i]));
            intArray.appendChild(integer);
        }
        return intArray;
    }

    public final String packLong(String name, long value) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packLong()");
        Document document = this.createDocument();
        Element booleanElement = this.packLong(name, new Long(value), document);
        document.appendChild(booleanElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packLong()");
        return result;
    }

    public final Element packLong(String name, Object value, Document document) {
        Element long1 = document.createElement("attr");
        if (name != null) {
            long1.setAttribute("name", name);
        }
        long1.setAttribute("type", "s64");
        long1.setAttribute("value", value.toString());
        return long1;
    }

    public final String packLongArray(String name, long[] attr) throws SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packLongArray()");
        Document document = this.createDocument();
        Element inArrayElement = this.packLongArray(name, attr, document);
        document.appendChild(inArrayElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packLongArray()");
        return result;
    }

    public final Element packLongArray(String name, long[] attr, Document document) {
        Element longArray = document.createElement("array");
        if (name != null) {
            longArray.setAttribute("name", name);
        }
        for (int i = 0; i < attr.length; ++i) {
            Element integer = document.createElement("attr");
            integer.setAttribute("type", "s64");
            integer.setAttribute("value", Long.toString(attr[i]));
            longArray.appendChild(integer);
        }
        return longArray;
    }

    public final String packManagedObject(String name, ManagedObject value) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packManagedObject()");
        Document document = this.createDocument();
        Element managedObjectElement = this.packManagedObject(name, value, document);
        document.appendChild(managedObjectElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packManagedObject()");
        return result;
    }

    public final Element packManagedObject(String name, ManagedObject value, Document document) throws IllegalParameterValueException {
        Element moref = document.createElement("moref");
        moref.setAttribute("name", name);
        if (value == null) {
            moref.appendChild(this.packParameter("ldn", "", document));
            moref.appendChild(this.packParameter("froType", new Integer(-1), document));
            moref.appendChild(this.packParameter("froId", new Integer(-1), document));
        } else {
            moref.appendChild(this.packParameter("ldn", value.getLocalDistinguishedName(), document));
            try {
                Integer froType = new Integer(FroIdFinder.getManagedObjectFroType((ManagedObject)value, null));
                moref.appendChild(this.packParameter("froType", froType, document));
                Integer froId = new Integer(FroIdFinder.getManagedObjectFroId((ManagedObject)value, null));
                moref.appendChild(this.packParameter("froId", froId, document));
            }
            catch (MoAccessException e) {
                logger.traceDebug(THIS_CLASS, e.getMessage());
                logger.traceDebugStackTrace(THIS_CLASS, (Throwable)e);
                throw new IllegalParameterValueException(e.getMessage());
            }
        }
        return moref;
    }

    public final Element packParameter(String name, Object value, Document document) throws IllegalParameterValueException {
        Element result = value == null ? this.handleNullValue(name, document) : this.handleNonNullValue(name, value, document);
        return result;
    }

    public final String packStruct(String name, Struct value) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packStruct()");
        Document document = this.createDocument();
        Element structElement = this.packStruct(name, value, document);
        document.appendChild(structElement);
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packStruct()");
        return result;
    }

    public final Element packStruct(String name, Struct value, Document document) throws IllegalParameterValueException {
        Element struct = document.createElement("struct");
        if (name != null) {
            struct.setAttribute("name", name);
        }
        String[] names = value.getNames();
        try {
            Object[] values = value.getValues();
            for (int i = 0; i < names.length; ++i) {
                String aName = names[i];
                Object aVal = values[i];
                struct.appendChild(this.packParameter(aName, aVal, document));
            }
        }
        catch (NotHandledAttributeTypeException e) {
            String errMsg = "Error in packStruct()";
            logger.traceError(THIS_CLASS, "Error in packStruct()", (Throwable)e);
        }
        catch (MoNotFoundException e) {
            String errMsg = "Error in packStruct()";
            logger.traceError(THIS_CLASS, "Error in packStruct()", (Throwable)e);
        }
        return struct;
    }

    public final Element packString(String name, Object value, Document document) {
        Element element = document.createElement("attr");
        if (name != null) {
            element.setAttribute("name", name);
        }
        element.setAttribute("type", "string");
        element.setAttribute("value", value.toString());
        return element;
    }

    public final String transformDocument(Document document) throws SoftwareErrorException {
        return this.transformDocument(document, true);
    }

    public final String transformDocument(Document document, boolean indent) throws SoftwareErrorException {
        String result;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", indent);
        outputFormat.setIndent(1);
        outputFormat.setIndenting(indent);
        XMLSerializer serializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        try {
            serializer.asDOMSerializer();
            serializer.serialize(document);
        }
        catch (IOException e) {
            logger.traceError(THIS_CLASS, "Error while transforming document: " + e.getMessage());
            throw new SoftwareErrorException((Throwable)e);
        }
        try {
            byteArrayOutputStream.flush();
            result = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            logger.traceError(THIS_CLASS, "Stream error: " + e.getMessage());
            throw new SoftwareErrorException((Throwable)e);
        }
        return result;
    }

    protected final Element packArrayEntry(Object next, Document document) throws IllegalParameterValueException {
        return this.packParameter(null, next, document);
    }

    private Element handleNonNullValue(String name, Object value, Document document) throws IllegalParameterValueException {
        Element result = value instanceof Struct ? this.packStruct(name, (Struct)value, document) : (value instanceof int[] ? this.packIntArray(name, (int[])value, document) : (value instanceof long[] ? this.packLongArray(name, (long[])value, document) : (value instanceof boolean[] ? this.packBooleanArray(name, (boolean[])value, document) : (value.getClass().isArray() ? this.packArray(name, (Object[])value, document) : (value instanceof ManagedObject ? this.packManagedObject(name, (ManagedObject)value, document) : this.packPrimitiveParameter(name, value, document))))));
        return result;
    }

    private Element handleNullValue(String name, Document document) throws IllegalParameterValueException {
        if (!name.endsWith("Ref") && name.indexOf("RefPrio") == -1) {
            throw new IllegalParameterValueException("NULL value not permitted in parameter. Parameter = " + name + ".");
        }
        Element result = this.packManagedObject(name, null, document);
        return result;
    }

    protected final Element packPrimitiveParameter(String name, Object value, Document document) {
        Element element = this.isValueNullAndNameIndicatesRef(name, value) ? this.packString(name, "", document) : (value instanceof String ? this.packString(name, value, document) : (value instanceof Integer ? this.packInt(name, value, document) : (value instanceof Boolean ? this.packBoolean(name, value.toString(), document) : (value instanceof Long ? this.packLong(name, value, document) : (value instanceof Float ? this.packInt(name, value, document) : null)))));
        return element;
    }

    private boolean isValueNullAndNameIndicatesRef(String name, Object value) {
        return value == null && name.endsWith("Ref");
    }

    private Element createPnpElement(PnpRequest pnpRequest, Document document) {
        Element pnpElement = document.createElement("pnp");
        pnpElement.setAttribute("version", pnpRequest.getVersion());
        document.appendChild(pnpElement);
        return pnpElement;
    }

    private Element createTypeElement(PnpSubRequest pnpSubRequest, Document document) {
        Element typeElement = document.createElement(pnpSubRequest.getRequestType());
        typeElement.setAttribute("ldn", pnpSubRequest.getLdn());
        if (pnpSubRequest instanceof PnpActionRequest) {
            PnpActionRequest pnpActionRequest = (PnpActionRequest)pnpSubRequest;
            typeElement.setAttribute("actionName", pnpActionRequest.getActionName());
        }
        return typeElement;
    }

    public String packConfirm(PnpRequest pnpRequest, String restultStatus) throws IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "packConfirm");
        Document document = this.createDocument();
        Element pnpElement = this.createPnpElement(pnpRequest, document);
        PnpSubRequest[] pnpSubRequests = pnpRequest.getSubRequests();
        for (int i = 0; i < pnpSubRequests.length; ++i) {
            Element typeElement = this.createTypeElement(pnpSubRequests[i], document);
            pnpElement.appendChild(typeElement);
            Element resultElement = document.createElement("result");
            resultElement.setAttribute("status", restultStatus);
            typeElement.appendChild(resultElement);
            Object resultObject = pnpSubRequests[i].getExecuteResult();
            if (resultObject == null) continue;
            Element resultObjectElement = this.packParameter(pnpSubRequests[i].getExecuteResultName(), resultObject, document);
            typeElement.appendChild(resultObjectElement);
        }
        String result = this.transformDocument(document);
        logger.traceGeneral(THIS_CLASS, result);
        logger.traceReturn(THIS_CLASS, "packConfirm");
        return result;
    }
}

