/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.to;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import se.ericsson.cello.aueframework.collector.AttrListImpl;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.to.Constants;
import se.ericsson.cello.cmaaue.to.ToStateAUEUtil;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;

public class CreateBspVlanMoAction
implements DataCollectorAction,
Constants {
    static /* synthetic */ Class class$se$ericsson$cello$moframework$ManagedObject;
    static /* synthetic */ Class class$se$ericsson$cello$moframework$AttrList;
    static /* synthetic */ Class class$java$lang$String;

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        if ((this.isEvoc8200Node(collectorContext, coordinator) || this.isEvoc8300Node(collectorContext, coordinator)) && !this.bspVlanMoExists(collectorContext, coordinator)) {
            this.createBspVlan(collectorContext, coordinator);
        }
    }

    private boolean isEvoc8300Node(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Slot");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            String string = null;
            String string2 = null;
            try {
                StructImpl structImpl = (StructImpl)managedObject.getAttribute("productData", coordinator);
                if (structImpl != null) {
                    string = (String)structImpl.getValue("productNumber");
                }
            }
            catch (MoAccessException moAccessException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get the  productNumber for SMXB on EvoC8300 Node");
            }
            if (string == null || !(string2 = ToStateAUEUtil.optimize(string)).startsWith("ROJ208476") && !string2.startsWith("ROJ208482")) continue;
            return true;
        }
        return false;
    }

    private boolean isEvoc8200Node(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Subrack");
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            ManagedObject managedObject2 = (ManagedObject)this.getAttribute(managedObject, "SubrackProdTypeRef", coordinator);
            StructImpl structImpl = (StructImpl)this.getAttribute(managedObject2, "BoardPositions", coordinator);
            int n = 0;
            int n2 = 0;
            try {
                n = (Integer)structImpl.getValue("cmxbPositionA");
                n2 = (Integer)structImpl.getValue("cmxbPositionB");
            }
            catch (MoAccessException moAccessException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get the cmxb postions , vlan=BACKPLANE_PORT_SUPERVISION creation failed.");
                moAccessException.printStackTrace();
            }
            if (n == 2 && n2 == 28) {
                return true;
            }
        }
        return false;
    }

    private void createBspVlan(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("Vlan");
        if (moFactory == null) {
            return;
        }
        AttrListImpl attrListImpl = new AttrListImpl(3);
        attrListImpl.addElement("userLabel", (Object)"Cma_autocreated");
        attrListImpl.addElement("vid", (Object)new Integer(this.generateVid(collectorContext, coordinator)));
        attrListImpl.addElement("vlanType", (Object)new Integer(4));
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("EthernetSwitchFabric");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            Method method = null;
            try {
                method = moFactory.getClass().getMethod("autoCreateMo", class$se$ericsson$cello$moframework$ManagedObject == null ? CreateBspVlanMoAction.class$("se.ericsson.cello.moframework.ManagedObject") : class$se$ericsson$cello$moframework$ManagedObject, class$se$ericsson$cello$moframework$AttrList == null ? CreateBspVlanMoAction.class$("se.ericsson.cello.moframework.AttrList") : class$se$ericsson$cello$moframework$AttrList, class$java$lang$String == null ? CreateBspVlanMoAction.class$("java.lang.String") : class$java$lang$String, class$se$ericsson$cello$moframework$ManagedObject == null ? CreateBspVlanMoAction.class$("se.ericsson.cello.moframework.ManagedObject") : class$se$ericsson$cello$moframework$ManagedObject, class$se$ericsson$cello$transaction$Coordinator == null ? CreateBspVlanMoAction.class$("se.ericsson.cello.transaction.Coordinator") : class$se$ericsson$cello$transaction$Coordinator);
                method.invoke((Object)moFactory, managedObject, attrListImpl, "BACKPLANE_PORT_SUPERVISION", null, coordinator);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AueException("vlan=BACKPLANE_PORT_SUPERVISION creation failed", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new AueException("vlan=BACKPLANE_PORT_SUPERVISION creation failed " + exception.getMessage());
            }
            collectorContext.getLogger().info(this.getClass(), "vlan=BACKPLANE_PORT_SUPERVISION created successfully...");
        }
    }

    private int generateVid(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoFilter moFilter = new MoFilter(){

            public boolean accept(ManagedObject managedObject) {
                return managedObject.getType().equals("Vlan") || managedObject.getType().equals("VlanPort");
            }
        };
        MoIterator moIterator = collectorContext.getMoAccessor().select(moFilter);
        if (moIterator == null) {
            return 4090;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            Integer n = (Integer)this.getAttribute(managedObject, "Vid", coordinator);
            hashSet.add(n);
        }
        return this.freeVid(hashSet);
    }

    private int freeVid(HashSet hashSet) {
        for (int i = 4090; i > 1; --i) {
            if (hashSet.contains(new Integer(i))) continue;
            return i;
        }
        return 0;
    }

    private boolean bspVlanMoExists(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        ManagedObject managedObject = collectorContext.getMoAccessor().lookup("ManagedElement=1,EthernetSwitchFabric=1,Vlan=BACKPLANE_PORT_SUPERVISION");
        if (managedObject != null) {
            int n = (Integer)this.getAttribute(managedObject, "VlanType", coordinator);
            if (n != 4) {
                collectorContext.getLogger().error(this.getClass(), "vlan=BACKPLANE_PORT_SUPERVISION already exists which is wrongly configured.");
            }
            return true;
        }
        return false;
    }

    private Object getAttribute(ManagedObject managedObject, String string, Coordinator coordinator) throws AueException {
        Object object = null;
        try {
            Class<?> clazz = managedObject.getClass();
            Class[] classArray = new Class[]{Coordinator.class};
            Method method = clazz.getMethod("get" + string, classArray);
            if (method == null) {
                throw new AueException("method get" + string + "is not found");
            }
            Object[] objectArray = new Object[]{coordinator};
            object = method.invoke((Object)managedObject, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new AueException("Method getAttribute cannot be accessed. " + illegalAccessException.getCause(), (Throwable)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new AueException("Method getAttribute cannot be found. " + noSuchMethodException.getCause(), (Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            throw new AueException("Method getAttribute failed. " + invocationTargetException.getCause(), invocationTargetException.getTargetException());
        }
        return object;
    }
}

