/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.model.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.TableModelListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.em.fm.availability.model.impl.LogRecordEventRow;
import se.ericsson.cello.em.fm.availability.model.impl.XMLTreeDumper;
import se.ericsson.cello.em.fm.common.model.ifc.LogTableModel;
import se.ericsson.cello.em.fm.common.model.impl.LogFileParser;
import se.ericsson.cello.em.fm.common.view.ifc.TablePrintable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityTableModel
implements LogTableModel,
TablePrintable {
    private Header[] logTypeHeaders;
    private List<LogRecordEventRow> logRecordRows = new ArrayList<LogRecordEventRow>();

    public AvailabilityTableModel() {
        this.logTypeHeaders = new Header[]{new Header("LogRecord", Integer.class), new Header("Service", String.class), new Header("Time", String.class), new Header("Type", String.class), new Header("Reason", String.class), new Header("AdditionalInfo", String.class), new Header("Board", String.class), new Header("Prog/Hardware", String.class), new Header("ConfigurationVersion", String.class), new Header("UpgradePackage", String.class)};
    }

    @Override
    public void setInputStreamToModel(InputStream logInputStream) throws ParserConfigurationException, SAXException, IOException {
        String line;
        StringBuilder str = new StringBuilder(3000);
        BufferedReader br = new BufferedReader(new InputStreamReader(logInputStream));
        while ((line = br.readLine()) != null) {
            str.append(line);
            str.append("\n");
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(str.toString().getBytes());
        LogFileParser parser = new LogFileParser();
        NodeList aListOfLogRecords = null;
        try {
            aListOfLogRecords = parser.getNodeList(stream, "LogRecord");
        }
        catch (IOException io) {
        }
        catch (SAXException sax) {
        }
        catch (ParserConfigurationException ex) {
            // empty catch block
        }
        if (aListOfLogRecords == null) {
            Pattern headerPattern = Pattern.compile("(.+);(.+);(.+);(.+);(.+);(.+);(.+);(.+);(.+);(.+);");
            Matcher headerMatcher = headerPattern.matcher(str.toString());
            HashMap<String, Integer> headerMap = new HashMap<String, Integer>();
            boolean headersFound = false;
            boolean logMatchFound = false;
            if (headerMatcher.find()) {
                for (int i = 1; i <= headerMatcher.groupCount(); ++i) {
                    headerMap.put(headerMatcher.group(i), i);
                }
                headersFound = true;
            } else {
                headerMap.put("LogRecord", 1);
                headerMap.put("Service", 2);
                headerMap.put("Time", 3);
                headerMap.put("Type", 4);
                headerMap.put("Reason", 5);
                headerMap.put("AdditionalInfo", 6);
                headerMap.put("Board", 7);
                headerMap.put("Prog/Hardware", 8);
                headerMap.put("ConfigurationVersion", 9);
                headerMap.put("UpgradePackage", 10);
            }
            Pattern pattern = Pattern.compile("(.*);(.*);(.*);(.*);(.*);(.*);(.*);(.*);(.*);(.*);");
            Matcher logMatcher = pattern.matcher(str.toString());
            if (headersFound) {
                logMatcher.find();
                logMatcher.group();
            }
            while (logMatcher.find()) {
                logMatchFound = true;
                LogRecordEventRow rec = new LogRecordEventRow(logMatcher.group((Integer)headerMap.get("LogRecord")), logMatcher.group((Integer)headerMap.get("Service")), logMatcher.group((Integer)headerMap.get("Time")), logMatcher.group((Integer)headerMap.get("Type")), logMatcher.group((Integer)headerMap.get("Reason")), logMatcher.group((Integer)headerMap.get("AdditionalInfo")), logMatcher.group((Integer)headerMap.get("Board")), logMatcher.group((Integer)headerMap.get("Prog/Hardware")), logMatcher.group((Integer)headerMap.get("ConfigurationVersion")), logMatcher.group((Integer)headerMap.get("UpgradePackage")));
                this.logRecordRows.add(rec);
            }
            if (!headersFound && !logMatchFound) {
                throw new IOException("The opened log doesn't appear to be valid XML or CSV.");
            }
        } else {
            for (int i = 0; i < aListOfLogRecords.getLength(); ++i) {
                XMLTreeDumper xmlTreeDumper = new XMLTreeDumper();
                Node logRecordNode = aListOfLogRecords.item(i);
                Node timeStampNode = xmlTreeDumper.getChildNodeByName(logRecordNode, "TimeStamp");
                Node recordContentNode = xmlTreeDumper.getChildNodeByName(logRecordNode, "RecordContent");
                LogRecordEventRow row = new LogRecordEventRow(xmlTreeDumper.getLogRecordNumber(logRecordNode), xmlTreeDumper.getService(recordContentNode), xmlTreeDumper.getTimeValue(timeStampNode), xmlTreeDumper.getEventValue(recordContentNode), xmlTreeDumper.getEventReasonValue(recordContentNode), xmlTreeDumper.getAdditionalInfo(logRecordNode), xmlTreeDumper.getBoardInfo(recordContentNode), xmlTreeDumper.getHwProg(recordContentNode), xmlTreeDumper.getConfigurationValue(recordContentNode), xmlTreeDumper.getUpgradePackage(recordContentNode));
                row.setDetailsInfo(xmlTreeDumper.getDetailsInfo(logRecordNode));
                this.logRecordRows.add(row);
            }
        }
        aListOfLogRecords = null;
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
    }

    @Override
    public Class<?> getColumnClass(int columnPos) {
        return this.logTypeHeaders[columnPos].getColumnType();
    }

    @Override
    public int getColumnCount() {
        return this.logTypeHeaders.length;
    }

    @Override
    public String getColumnName(int columnPos) {
        return this.logTypeHeaders[columnPos].getHeaderName();
    }

    @Override
    public int getRowCount() {
        return this.logRecordRows.size();
    }

    @Override
    public Object getValueAt(int rowPos, int colPos) {
        Object cellValue = null;
        if (this.getColumnName(colPos).equals("LogRecord")) {
            cellValue = this.logRecordRows.get(rowPos).getRecordId();
        } else if (this.getColumnName(colPos).equals("Service")) {
            cellValue = this.logRecordRows.get(rowPos).getService();
        } else if (this.getColumnName(colPos).equals("Time")) {
            cellValue = this.logRecordRows.get(rowPos).getTime();
        } else if (this.getColumnName(colPos).equals("Type")) {
            cellValue = this.logRecordRows.get(rowPos).getEvent();
        } else if (this.getColumnName(colPos).equals("Reason")) {
            cellValue = this.logRecordRows.get(rowPos).getEventReason();
        } else if (this.getColumnName(colPos).equals("AdditionalInfo")) {
            cellValue = this.logRecordRows.get(rowPos).getAdditionalInfo();
        } else if (this.getColumnName(colPos).equals("Board")) {
            cellValue = this.logRecordRows.get(rowPos).getBoard();
        } else if (this.getColumnName(colPos).equals("Prog/Hardware")) {
            cellValue = this.logRecordRows.get(rowPos).getProgHw();
        } else if (this.getColumnName(colPos).equals("ConfigurationVersion")) {
            cellValue = this.logRecordRows.get(rowPos).getConfigurationVersion();
        } else if (this.getColumnName(colPos).equals("UpgradePackage")) {
            cellValue = this.logRecordRows.get(rowPos).getUpgradePackage();
        }
        return cellValue;
    }

    @Override
    public String getDetails(int rowPos) {
        return this.logRecordRows.get(rowPos).getDetailsInfo();
    }

    @Override
    public boolean isCellEditable(int rowPos, int columnPos) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
    }

    @Override
    public void setValueAt(Object arg0, int rowPos, int columnPos) {
    }

    public Document getLogAsDOMObject(InputStream logInputStream) throws ParserConfigurationException, SAXException, IOException {
        Document doc = null;
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        });
        doc = builder.parse(logInputStream);
        return doc;
    }

    @Override
    public String getExportText(int row, String[] columnOrder) {
        return this.logRecordRows.get(row).getExportData("EXPORT", columnOrder, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Header {
        String headerName;
        Class<?> columnType;

        Header(String name, Class<?> type) {
            this.headerName = name;
            this.columnType = type;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public Class<?> getColumnType() {
            return this.columnType;
        }
    }
}

