/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.view.impl;

import java.util.ArrayList;
import java.util.Iterator;

public class Filterator {
    private ArrayList<ColFilter> coulmnPatterns = new ArrayList();
    private String cellPatternValue;

    public boolean match(String[] headers, String[] rowData) {
        boolean foundMatch = false;
        boolean foundColMatch = false;
        Iterator<ColFilter> iter = this.coulmnPatterns.iterator();
        foundMatch = this.checkReg(rowData);
        while (!foundColMatch && iter.hasNext()) {
            ColFilter colFilt = iter.next();
            foundColMatch = this.checkColFilter(colFilt, headers, rowData);
        }
        return foundColMatch && foundMatch;
    }

    private boolean checkColFilter(ColFilter colFilt, String[] headers, String[] rowData) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equals(colFilt.colName)) continue;
            for (int j = 0; j < colFilt.values.length; ++j) {
                if (!rowData[i].equals(colFilt.values[j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkReg(String[] rowData) {
        for (int i = 0; i < rowData.length; ++i) {
            if (this.cellPatternValue == null) {
                return true;
            }
            String row = rowData[i].toLowerCase();
            if (!row.contains(this.cellPatternValue.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void addColumnFilter(String columnName, String[] cellValues) {
        this.coulmnPatterns.add(new ColFilter(columnName, cellValues));
    }

    public void setRegText(String reg) {
        this.cellPatternValue = reg;
    }

    public void clearPatterns() {
        this.cellPatternValue = "";
        this.coulmnPatterns = new ArrayList();
    }

    static class ColFilter {
        String colName = "";
        String[] values = null;

        public ColFilter(String colName, String[] values) {
            this.colName = colName;
            this.values = values;
        }
    }
}

