/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.config.impl;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import se.ericsson.cello.em.fm.common.config.ifc.Configuration;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguration
implements Configuration {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final String PROPERTY_ADDRESS = "address";
    private static final String PROPERTY_PORT = "httpPort";
    private String host;
    private int port;
    private Properties properties;
    private String nodeservicesConfigFile = "/cello/emas/nodeservcfg.xml";
    private String preferenceServiceConfigFile = "/cello/emas/userprefcfg.xml";
    private String emTraceLogConfigFile = "/cello/emas/emtracelogcfg.xml";
    private String helpServicesConfigFile = "/cello/emas/helpservcfg.xml";
    private String iconStringToPassOn = "";
    private String managerTitle = "Element Manager";
    private String supersedingParamList = "";
    private Image iconImage = null;
    private List<Configuration.Tool> hyperTools = new ArrayList<Configuration.Tool>();
    private String customApplName;

    public AbstractConfiguration(Properties properties, String customApplName) {
        this.customApplName = customApplName;
        this.properties = properties;
        if (properties != null) {
            this.host = properties.getProperty(PROPERTY_ADDRESS);
            String portString = properties.getProperty(PROPERTY_PORT);
            this.port = Integer.parseInt(portString);
        }
        this.parseProperties(properties);
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
        this.parseProperties(properties);
    }

    @Override
    public int getConnectionPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getHostAndPortString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.host);
        sb.append(":");
        sb.append(this.port);
        return sb.toString();
    }

    @Override
    public Image getIconImage() {
        return this.iconImage;
    }

    @Override
    public String getIconToPassOn() {
        return this.iconStringToPassOn;
    }

    @Override
    public Properties getProperties() {
        Properties propsCopy = new Properties(this.properties);
        propsCopy.putAll((Map<?, ?>)this.properties);
        return propsCopy;
    }

    @Override
    public Properties getSupersedingProperties() {
        Properties tempProp = new Properties();
        String supersedingList = this.properties.getProperty("SUPERSEDING_PARAMETER_LIST");
        if (supersedingList != null) {
            for (String key : supersedingList.split(";")) {
                String value = this.properties.getProperty(key = key.trim());
                if (value == null) continue;
                tempProp.put(key, value);
            }
        }
        return tempProp;
    }

    @Override
    public String getShortTitle() {
        return this.customApplName;
    }

    @Override
    public String getManagerName() {
        return this.managerTitle;
    }

    @Override
    public String getLongTitle() {
        StringBuilder strB = new StringBuilder();
        strB.append(this.getManagerName());
        strB.append(" - ");
        strB.append(this.customApplName);
        return strB.toString();
    }

    @Override
    public String getTitleForWindow() {
        StringBuilder strB = new StringBuilder();
        strB.append(this.getHost());
        strB.append(" - ");
        strB.append(this.managerTitle);
        strB.append(" - ");
        strB.append(this.customApplName);
        return strB.toString();
    }

    @Override
    public String getHelpServiceConfigurationFile() {
        return this.helpServicesConfigFile;
    }

    @Override
    public String getNodeServiceConfigurationFile() {
        return this.nodeservicesConfigFile;
    }

    @Override
    public String getPreferenceServiceConfigurationFile() {
        return this.preferenceServiceConfigFile;
    }

    @Override
    public List<Configuration.Tool> getHyperTools() {
        return this.hyperTools;
    }

    private void parseProperties(Properties properties) {
        if (properties != null) {
            LOG.fine("Parsing properties", new Object[0]);
            this.managerTitle = properties.getProperty("MANAGER_TITLE", "Element Manager");
            this.helpServicesConfigFile = properties.getProperty("HELPSERVICE_CONFIG", this.helpServicesConfigFile);
            this.nodeservicesConfigFile = properties.getProperty("NODESERVICES_CONFIG", this.nodeservicesConfigFile);
            this.emTraceLogConfigFile = properties.getProperty("EMTRACELOG_CONFIG", this.emTraceLogConfigFile);
            this.preferenceServiceConfigFile = properties.getProperty("PREFERENCESERVICE_CONFIG", this.preferenceServiceConfigFile);
            this.supersedingParamList = properties.getProperty("SUPERSEDING_PARAMETER_LIST", this.supersedingParamList);
            this.iconStringToPassOn = properties.getProperty("TOOL_ICON", this.iconStringToPassOn);
            this.customApplName = properties.getProperty("CUSTOM_APPL_NAME", this.customApplName);
            IconHelper helper = new IconHelper();
            this.iconImage = helper.getIconImage(this.iconStringToPassOn);
            this.parseHyperTools(properties);
        }
    }

    private void parseHyperTools(Properties props) {
        String toolKeys = props.getProperty("HYPER_TOOL_KEYS");
        if (toolKeys != null && !"".equals(toolKeys)) {
            String[] keys = toolKeys.split(";");
            for (int i = 0; i < keys.length; ++i) {
                String cfgFile = props.getProperty(keys[i] + "_CONFIG");
                String name = props.getProperty(keys[i] + "_NAME");
                if (null != cfgFile && null != name && cfgFile.length() > 0 && name.length() > 0) {
                    Configuration.Tool tool = new Configuration.Tool(name, cfgFile);
                    this.hyperTools.add(tool);
                    continue;
                }
                LOG.warning("While parsing the input from configuration file. Information on tool name or tool configuration file missing. \nTool name: " + name + "\nTool config file: " + cfgFile, new Object[0]);
            }
        }
    }
}

