/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.utils.impl;

import java.util.EnumSet;
import java.util.TreeSet;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LogPartComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LogPart {
    ACKNOWLEDGEMENT_STATE("acknowledgeState", "", 99, 13, 99),
    ACKNOWLEDGEMENT_TIME("acknowledgedTime", "", 99, 12, 99),
    ACKNOWLEDGEMENT_USER("ackUserId", "", 99, 11, 99),
    ADDITIONAL_INFORMATION("additionalInformation", "", 17, 17, 10),
    ADDITIONAL_TEXT("additionalText", "Additional Text", 10, 10, 5),
    ALARM_ID("alarmId", "", 1, 1, 99),
    CORRELATED_NOTIFICATIONS("correlatedNotifications", "", 99, 16, 99),
    DOMAIN_NAME("", "", 99, 99, 99),
    EVENT_TIME("eventTime", "Time", 5, 5, 1),
    EVENT_TYPE("eventType", "Event Type", 3, 3, 2),
    EXTENDED_EVENT_TYPE("extendedEventType", "", 99, 4, 3),
    MANAGED_OBJECT_CLASS("managedObjectClass", "", 6, 6, 6),
    MANAGED_OBJECT_INSTANCE("managedObjectInstance", "MO Instance", 7, 7, 7),
    NOTIFICATION_ID("notificationID", "", 14, 14, 8),
    PERCEIVED_SEVERITY("perceivedSeverity", "Severity", 2, 2, 99),
    PROBABLE_CAUSE("probableCause", "Probable Cause", 8, 8, 99),
    SPECIFIC_EVENT("specificEvent", "Specific Event", 99, 99, 4),
    SPECIFIC_PROBLEM("specificProblem", "Specific Problem", 9, 9, 99),
    SYSTEM_DN("systemDN", "", 15, 15, 9),
    TIME_ZONE("", "", 99, 99, 99),
    USER_LABEL("", "", 99, 99, 99);

    public final String COLUMN_TITLE;
    public final String DETAILS_TITLE;
    public final int ALARM_LIST_ORDER;
    public final int ALARM_LOG_ORDER;
    public final int EVENT_ORDER;

    private LogPart(String detailsTitle, String columnTitle, int alarmListOrder, int alarmLogOrder, int eventOrder) {
        this.COLUMN_TITLE = columnTitle;
        this.DETAILS_TITLE = detailsTitle;
        this.ALARM_LIST_ORDER = alarmListOrder;
        this.ALARM_LOG_ORDER = alarmLogOrder;
        this.EVENT_ORDER = eventOrder;
    }

    public static TreeSet<LogPart> getColumns(FmType logType) {
        TreeSet<LogPart> columns = new TreeSet<LogPart>(new LogPartComparator(logType));
        switch (logType) {
            case ALARM_LIST: {
                columns.addAll(EnumSet.of(ADDITIONAL_TEXT, new LogPart[]{EVENT_TIME, EVENT_TYPE, MANAGED_OBJECT_INSTANCE, PERCEIVED_SEVERITY, PROBABLE_CAUSE, SPECIFIC_PROBLEM}));
                break;
            }
            case ALARM_LOG: {
                columns.addAll(EnumSet.of(ADDITIONAL_TEXT, new LogPart[]{EVENT_TIME, EVENT_TYPE, MANAGED_OBJECT_INSTANCE, PERCEIVED_SEVERITY, PROBABLE_CAUSE, SPECIFIC_PROBLEM}));
                break;
            }
            case EVENT: {
                columns.addAll(EnumSet.of(EVENT_TIME, EVENT_TYPE, SPECIFIC_EVENT));
                break;
            }
        }
        return columns;
    }

    public static TreeSet<LogPart> getDetails(FmType logType) {
        TreeSet<LogPart> details = new TreeSet<LogPart>(new LogPartComparator(logType));
        switch (logType) {
            case ALARM_LIST: {
                details.addAll(EnumSet.of(ADDITIONAL_INFORMATION, new LogPart[]{ADDITIONAL_TEXT, ALARM_ID, EVENT_TIME, EVENT_TYPE, MANAGED_OBJECT_CLASS, MANAGED_OBJECT_INSTANCE, NOTIFICATION_ID, PERCEIVED_SEVERITY, PROBABLE_CAUSE, SPECIFIC_PROBLEM, SYSTEM_DN}));
                break;
            }
            case ALARM_LOG: {
                details.addAll(EnumSet.of(ADDITIONAL_INFORMATION, new LogPart[]{ADDITIONAL_TEXT, ALARM_ID, CORRELATED_NOTIFICATIONS, EVENT_TIME, EVENT_TYPE, EXTENDED_EVENT_TYPE, MANAGED_OBJECT_CLASS, MANAGED_OBJECT_INSTANCE, NOTIFICATION_ID, PERCEIVED_SEVERITY, PROBABLE_CAUSE, SPECIFIC_PROBLEM, SYSTEM_DN}));
                break;
            }
            case EVENT: {
                details.addAll(EnumSet.of(ADDITIONAL_INFORMATION, new LogPart[]{ADDITIONAL_TEXT, EVENT_TIME, EVENT_TYPE, EXTENDED_EVENT_TYPE, MANAGED_OBJECT_CLASS, MANAGED_OBJECT_INSTANCE, NOTIFICATION_ID, SPECIFIC_EVENT, SYSTEM_DN}));
                break;
            }
        }
        return details;
    }
}

