/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import se.ericsson.cello.em.fm.common.config.ifc.Configuration;
import se.ericsson.cello.em.fm.common.controller.ifc.ToolController;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.view.ifc.FmView;
import se.ericsson.cello.em.fm.common.view.impl.ColorCodedColumns;
import se.ericsson.cello.em.fm.common.view.impl.FmSortedTable;
import se.ericsson.cello.em.fm.common.view.impl.Menu;
import se.ericsson.cello.em.fm.common.view.impl.RightCellRenderer;
import se.ericsson.cello.em.fm.common.view.impl.Utils;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractView
extends JPanel
implements FmView {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final long serialVersionUID = 1L;
    private JFrame view;
    private JMenuBar menuBar;
    private JLabel statusLabel = new JLabel("   ");
    private FmSortedTable table;
    protected JMenuItem closeMenuItem = new JMenuItem();
    protected JMenuItem detailsMenuItem = new JMenuItem();
    protected JMenuItem exportMenuItem = new JMenuItem();
    protected JMenuItem helpOnAlarmMenuItem = new JMenuItem();
    protected JMenu openInMenu = new JMenu();
    protected JMenuItem pageSetupMenuItem = new JMenuItem();
    protected JMenuItem printMenuItem = new JMenuItem();
    protected JMenuItem refreshMenuItem = new JMenuItem();
    protected JCheckBoxMenuItem communicationMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem environmentalMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem equipmentMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem processingErrorMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem qosMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem soundMenuItem = new JCheckBoxMenuItem();
    protected JMenuItem detailsPopUpMenuItem = new JMenuItem();
    protected JMenuItem openInPopUpMenuItem = new JMenuItem();
    protected JMenuItem helpOnAlarmPopUpMenuItem = new JMenuItem();
    protected ArrayList<JMenuItem> hyperToolMenuItems = new ArrayList();
    private ToolService toolService;
    private ToolController rowSelectedListener;
    private Utils utils = new Utils();

    protected abstract JComponent createToolSpecificPanel();

    protected abstract String getHelpOnWindowSection();

    protected abstract EnumMap<Menu, JMenuItem[]> getToolMenus();

    protected abstract List<JMenuItem> getTablePopUpMenuItems();

    protected abstract ArrayList<String> getRightAlignedColumns();

    protected abstract MenuListener getMenuListener();

    public AbstractView(ToolService toolService) {
        this.toolService = toolService;
    }

    public void init(Dimension dimension) {
        LOG.entering(new Object[0]);
        Configuration configuration = this.toolService.getConfiguration();
        this.view = new JFrame(configuration.getTitleForWindow());
        this.view.setIconImage(configuration.getIconImage());
        this.view.setJMenuBar(this.createMenuBar());
        this.view.setContentPane(this.createContentPane());
        this.view.pack();
        this.view.setSize(dimension);
        this.view.setLocationRelativeTo(null);
        this.view.setVisible(true);
    }

    public void addHyperToolActions(ArrayList<Action> hyperToolActions) {
        LOG.entering(new Object[0]);
        for (Action action : hyperToolActions) {
            LOG.fine("Adding hypertool action " + action.getValue("Name"), new Object[0]);
            JMenuItem menuItem = new JMenuItem(action.getValue("Name").toString());
            menuItem.setAction(action);
            this.hyperToolMenuItems.add(menuItem);
        }
    }

    private JMenuBar createMenuBar() {
        LOG.fine("Creating menubar and menus", new Object[0]);
        this.menuBar = new JMenuBar();
        EnumMap<Menu, JMenuItem[]> toolMenus = this.getToolMenus();
        for (Map.Entry<Menu, JMenuItem[]> toolMenu : toolMenus.entrySet()) {
            JMenu menu = this.utils.createMenu(toolMenu.getKey(), toolMenu.getValue());
            menu.addMenuListener(this.getMenuListener());
            this.menuBar.add(menu);
        }
        JMenu helpMenu = this.utils.createMenu(Menu.HELP, this.utils.getHelpMenuItems(this.toolService, this.view));
        this.menuBar.add(helpMenu);
        return this.menuBar;
    }

    private Container createContentPane() {
        LOG.fine("Creating content pane", new Object[0]);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.createToolSpecificPanel(), "North");
        JScrollPane scrollPane = new JScrollPane(this.createTable());
        content.add((Component)scrollPane, "Center");
        content.add((Component)this.createStatusBar(), "South");
        return content;
    }

    private Container createStatusBar() {
        JPanel statusPanel = new JPanel();
        statusPanel.add((Component)this.statusLabel, "Center");
        return statusPanel;
    }

    private JTable createTable() {
        LOG.fine("Creating table", new Object[0]);
        this.table = new FmSortedTable();
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.addMouseListener(new TableMouseListener());
        return this.table;
    }

    public void setModel(TableModel model) {
        this.table.setModel(model);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new ColorCodedColumns());
        this.rightAlignColumns();
    }

    public void sortTable() {
        this.table.sort();
    }

    public void disposeWindow() {
        if (this.view != null) {
            this.view.setVisible(false);
            this.view.dispose();
            this.view = null;
        }
    }

    public void bringToFront() {
        if (this.view.getState() == 1) {
            this.view.setState(0);
        }
        this.view.toFront();
        this.view.requestFocus();
    }

    public JFrame getView() {
        return this.view;
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    public int getSelectedRow() {
        return this.table.getOriginalRow(this.table.getSelectedRow());
    }

    public void addCloseAction(Action action) {
        this.closeMenuItem.setAction(action);
    }

    public void addDetailsAction(Action action) {
        this.detailsMenuItem.setAction(action);
        this.detailsPopUpMenuItem.setAction(action);
    }

    public void addExportAction(Action action) {
        this.exportMenuItem.setAction(action);
    }

    public void addFilterCommunicationAction(Action action) {
        this.communicationMenuItem.setAction(action);
        this.communicationMenuItem.setState(true);
    }

    public void addFilterEnvironmentalAction(Action action) {
        this.environmentalMenuItem.setAction(action);
        this.environmentalMenuItem.setState(true);
    }

    public void addFilterEquipmentAction(Action action) {
        this.equipmentMenuItem.setAction(action);
        this.equipmentMenuItem.setState(true);
    }

    public void addFilterProcessingErrorAction(Action action) {
        this.processingErrorMenuItem.setAction(action);
        this.processingErrorMenuItem.setState(true);
    }

    public void addFilterQosAction(Action action) {
        this.qosMenuItem.setAction(action);
        this.qosMenuItem.setState(true);
    }

    public void addHelpOnAlarmAction(Action action) {
        this.helpOnAlarmMenuItem.setAction(action);
        this.helpOnAlarmPopUpMenuItem.setAction(action);
    }

    public void addPageSetupAction(Action action) {
        this.pageSetupMenuItem.setAction(action);
    }

    public void addPrintAction(Action action) {
        this.printMenuItem.setAction(action);
    }

    public void addRefreshAction(Action action) {
        this.refreshMenuItem.setAction(action);
    }

    public void addSoundAction(Action action) {
        this.soundMenuItem.setAction(action);
    }

    public void addWindowClosingListener(WindowAdapter listener) {
        this.view.addWindowListener(listener);
    }

    public void addRowSelectedListener(ToolController listener) {
        this.rowSelectedListener = listener;
    }

    private void rightAlignColumns() {
        ArrayList<String> rightAlignedColumns = this.getRightAlignedColumns();
        for (String columnIdentifier : rightAlignedColumns) {
            try {
                TableColumn column = this.table.getColumn(columnIdentifier);
                column.setCellRenderer(new RightCellRenderer());
            }
            catch (IllegalArgumentException e) {
                LOG.info("Column '" + columnIdentifier + "' not valid for current view.", new Object[0]);
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int row = AbstractView.this.table.rowAtPoint(p);
            int col = AbstractView.this.table.columnAtPoint(p);
            AbstractView.this.table.changeSelection(row, col, false, false);
            List<JMenuItem> menuItems = AbstractView.this.getTablePopUpMenuItems();
            for (JMenuItem menuItem : menuItems) {
                if (menuItem instanceof JMenu) {
                    JMenu menu = (JMenu)menuItem;
                    if (menu.getItemCount() != 0) continue;
                    menu.setEnabled(false);
                    continue;
                }
                menuItem.setEnabled(true);
            }
            if (AbstractView.this.rowSelectedListener != null) {
                AbstractView.this.rowSelectedListener.rowSelected();
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                JPopupMenu popupMenu = new JPopupMenu();
                for (JMenuItem menuItem : menuItems) {
                    popupMenu.add(menuItem);
                }
                popupMenu.show(AbstractView.this.table, (int)e.getPoint().getX(), (int)e.getPoint().getY());
            } else {
                super.mouseClicked(e);
            }
        }
    }
}

