/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.ericsson.cello.em.fm.common.view.impl.BevelArrowIcon;

class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    private static final long serialVersionUID = 5992058427066186861L;
    public static final Integer NONE = 0;
    public static final Integer DOWN = 1;
    public static final Integer UP = 2;
    int pushedColumn = -1;
    Hashtable<Integer, Integer> state = new Hashtable();
    JButton downButton;
    JButton upButton;
    private int lastRenderedColumn = 0;
    private String[] toolTips = null;

    public SortButtonRenderer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        this.downButton = new JButton();
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.setHorizontalTextPosition(2);
        this.downButton.setIcon(new BevelArrowIcon(1, false, true));
        this.downButton.setPressedIcon(new BevelArrowIcon(1, false, true));
        this.upButton = new JButton();
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setHorizontalTextPosition(2);
        this.upButton.setIcon(new BevelArrowIcon(0, false, true));
        this.upButton.setPressedIcon(new BevelArrowIcon(0, false, true));
    }

    public void setColumnToolTips(String[] toolTips) {
        this.toolTips = toolTips;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.toolTips != null && this.lastRenderedColumn < this.toolTips.length) {
            return this.toolTips[this.lastRenderedColumn];
        }
        return super.getToolTipText(event);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.lastRenderedColumn = col;
        JButton button = this;
        Integer intState = this.state.get(col);
        if (intState != null) {
            button = intState == DOWN ? this.downButton : this.upButton;
        }
        button.setText(value == null ? "" : value.toString());
        boolean isPressed = col == this.pushedColumn;
        button.getModel().setPressed(isPressed);
        button.getModel().setArmed(isPressed);
        return button;
    }

    public void setPressedColumn(int col) {
        this.pushedColumn = col;
    }

    public boolean isSelectedColumn(int col) {
        if (col < 0) {
            return false;
        }
        return this.state.get(col) != null;
    }

    public void setSelectedColumn(int col) {
        if (col < 0) {
            return;
        }
        Integer intState = this.state.get(col);
        intState = intState == null || intState == DOWN ? UP : DOWN;
        this.state.clear();
        this.state.put(col, intState);
    }

    public void pressedColumnMoved(int col) {
        int oldState = this.getState(this.pushedColumn);
        this.state.clear();
        this.state.put(col, oldState);
        this.setPressedColumn(col);
    }

    public int getState(int col) {
        Integer intState = this.state.get(col);
        return intState == null ? NONE : intState;
    }
}

